/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.conditions;

import com.google.common.base.Strings;
import gigaherz.guidebook.guidebook.BookParsingException;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.conditions.ConditionManager;
import java.util.function.Predicate;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import org.w3c.dom.Node;

public abstract class GameStageCondition
implements Predicate<ConditionContext> {
    public final String stageName;

    protected GameStageCondition(String stageName) {
        this.stageName = stageName;
    }

    public static void register() {
        ConditionManager.register("stage-locked", (doc, node) -> new Locked(GameStageCondition.parseStageName(node)));
        ConditionManager.register("stage-unlocked", (doc, node) -> new Unlocked(GameStageCondition.parseStageName(node)));
    }

    private static String parseStageName(Node xmlNode) {
        Node attr = xmlNode.getAttributes().getNamedItem("stage");
        if (attr == null) {
            throw new BookParsingException("Missing required XML attribute 'stage'.");
        }
        String stageName = attr.getTextContent();
        if (Strings.isNullOrEmpty((String)stageName)) {
            throw new BookParsingException("Missing required XML attribute 'stage'.");
        }
        return stageName;
    }

    public static class Unlocked
    extends GameStageCondition {
        public Unlocked(String stageName) {
            super(stageName);
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            return GameStageHelper.clientHasStage((EntityPlayer)conditionContext.getPlayer(), (String)this.stageName);
        }
    }

    public static class Locked
    extends GameStageCondition {
        public Locked(String stageName) {
            super(stageName);
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            return !GameStageHelper.clientHasStage((EntityPlayer)conditionContext.getPlayer(), (String)this.stageName);
        }
    }
}

