/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtils {
    private static List<ItemStack> oreDictMatches;

    public static void recreateOreDictionary(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs.length == 0) {
            oreDictMatches = null;
        } else {
            oreDictMatches = new ArrayList<ItemStack>();
            for (int id : oreIDs) {
                String oreName = OreDictionary.getOreName((int)id);
                NonNullList list = OreDictionary.getOres((String)oreName);
                for (int i = 0; i < list.size(); ++i) {
                    oreDictMatches.add((ItemStack)list.get(i));
                }
            }
            if (oreDictMatches.size() == 0) {
                oreDictMatches = null;
            }
        }
    }

    public static boolean hasOreDict() {
        return oreDictMatches != null;
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (!stack1.func_77969_a(stack2) || stack1.func_77969_a(stack2) && stack1.func_77952_i() != stack2.func_77952_i()) {
            if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
                return false;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length == 0 || ids2.length == 0) {
                return false;
            }
            boolean oreMatch = false;
            for (int id1 : ids1) {
                for (int id2 : ids2) {
                    String name;
                    if (id1 != id2 || !OreDictUtils.isEntryValid(name = OreDictionary.getOreName((int)id1))) continue;
                    oreMatch = true;
                    break;
                }
                if (oreMatch) break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean isEntryValid(String name) {
        if (OreDictRegistry.instance().getWhitelist().contains(name)) {
            return true;
        }
        return true;
    }

    public static class OreDictRegistry {
        private static final OreDictRegistry INSTANCE = new OreDictRegistry();
        private Set<String> whitelist = new HashSet<String>();

        public void init() {
            for (String item : new String[]{"oreIron", "oreGold", "oreAluminum", "oreAluminium", "oreTin", "oreCopper", "oreLead", "oreSilver", "orePlatinum", "oreNickel"}) {
                this.addWhitelist(item);
            }
            for (String item : new String[]{"blockIron", "blockGold", "blockAluminum", "blockAluminium", "blockTin", "blockCopper", "blockLead", "blockSilver", "blockPlatinum", "blockNickel"}) {
                this.addWhitelist(item);
            }
            for (String item : new String[]{"ingotIron", "ingotGold", "ingotAluminum", "ingotAluminium", "ingotTin", "ingotCopper", "ingotLead", "ingotSilver", "ingotPlatinum", "ingotNickel"}) {
                this.addWhitelist(item);
            }
            for (String item : new String[]{"nuggetIron", "nuggetGold", "nuggetAluminum", "nuggetAluminium", "nuggetTin", "nuggetCopper", "nuggetLead", "nuggetSilver", "nuggetPlatinum", "nuggetNickel"}) {
                this.addWhitelist(item);
            }
        }

        public static OreDictRegistry instance() {
            return INSTANCE;
        }

        public Set getWhitelist() {
            return this.whitelist;
        }

        private boolean addWhitelist(String entry) {
            if (entry == null) {
                return false;
            }
            return this.whitelist.add(entry);
        }
    }
}

