/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.ConfigRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.api.ISubModel;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemAbstractFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDyedFolder
extends ItemAbstractFolder
implements ISubModel,
IFolder {
    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack item = ItemStack.field_190927_a;
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap == null) {
            return item;
        }
        long count = FolderUtils.get(stack).getFileSize();
        long extract = 0L;
        if (count > 0L && cap.isItemStack()) {
            extract = Math.min((long)cap.getItemStack().func_77976_d(), count);
        }
        item = stack.func_77946_l();
        FolderUtils.get(item).remove(extract);
        return item;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + EnumDyeColor.values()[stack.func_77952_i()].func_176610_l().toLowerCase();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack folder = player.func_184586_b(hand);
        return this.placeObject(folder, player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSubModels(Item item) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @Override
    public ItemStack getEmptyFolder(ItemStack stack) {
        return new ItemStack(RFCItems.EMPTYDYEDFOLDER, 1, stack.func_77952_i());
    }

    @Override
    public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        long count;
        Object obj = FolderUtils.get(folder).getObject();
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof ItemBlock && (count = FolderUtils.get(folder).getFileSize()) > 0L) {
            ItemStack stackToPlace = new ItemStack(((ItemStack)obj).func_77973_b(), 1, ((ItemStack)obj).func_77952_i());
            ItemStack savedFolder = player.func_184586_b(hand);
            player.func_184611_a(hand, stackToPlace);
            EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
            player.func_184611_a(hand, savedFolder);
            if (ear == EnumActionResult.SUCCESS) {
                if (!player.field_71075_bZ.field_75098_d) {
                    FolderUtils.get(folder).remove(1L);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public Object insertIntoFolder(ItemStack folder, Object toInsert, boolean simulate, boolean oreDict) {
        CapabilityFolder cap = FolderUtils.get(folder).getCap();
        if (cap == null) {
            return null;
        }
        if (!(toInsert instanceof ItemStack) || !cap.isItemStack()) {
            return null;
        }
        if (!ItemStack.func_179545_c((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) && !oreDict) {
            return null;
        }
        ItemStack stack = (ItemStack)toInsert;
        long newCount = Math.min(cap.getCount() + (long)stack.func_190916_E(), (long)ConfigRFC.folderSizeLimit);
        long remainder = (long)ConfigRFC.folderSizeLimit - cap.getCount();
        stack.func_190920_e(stack.func_190916_E() - (int)remainder);
        if (!simulate) {
            cap.setCount(newCount);
        }
        return stack;
    }

    @Override
    public Object extractFromFolder(ItemStack folder, long amount, boolean simulate, boolean creative) {
        CapabilityFolder cap = FolderUtils.get(folder).getCap();
        return FolderType.NORMAL.extract(cap, amount, simulate, creative);
    }
}

