/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemAbstractFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ItemAutoFolder
extends ItemAbstractFolder
implements IFolder {
    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack item = ItemStack.field_190927_a;
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap == null) {
            return item;
        }
        long count = FolderUtils.get(stack).getFileSize();
        long extract = 0L;
        if (count > 0L && cap.isItemStack()) {
            extract = Math.min((long)cap.getItemStack().func_77976_d(), count);
        }
        item = stack.func_77946_l();
        FolderUtils.get(item).remove(extract);
        return item;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    @Override
    public ItemStack getEmptyFolder(ItemStack stack) {
        return new ItemStack(RFCItems.AUTOFOLDER);
    }

    @Override
    public Object insertIntoFolder(ItemStack folder, Object toInsert, boolean simulate, boolean oreDict) {
        CapabilityFolder cap = FolderUtils.get(folder).getCap();
        if (toInsert instanceof ItemStack) {
            ItemStack stack = (ItemStack)toInsert;
            if (cap.isFluidStack()) {
                return toInsert;
            }
            if (!FolderUtils.allowableIngredient(stack)) {
                return toInsert;
            }
            if (stack.func_77942_o() || stack.func_77951_h()) {
                return toInsert;
            }
            if (!(ItemStack.func_179545_c((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) || oreDict || cap.getItemStack().func_190926_b())) {
                return toInsert;
            }
            if (cap.getItemStack().func_190926_b() && cap.setContents(stack) && !simulate) {
                stack.func_190920_e(0);
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                cap.setCount(cap.getCount() + (long)stack.func_190916_E());
                stack.func_190920_e(0);
            }
            return ItemStack.field_190927_a;
        }
        if (toInsert instanceof FluidStack) {
            if (cap.isItemStack()) {
                return null;
            }
            if (cap.getFluidStack() == null && cap.setContents(toInsert) && simulate) {
                return (FluidStack)toInsert;
            }
            return FolderType.FLUID.insert(cap, toInsert, simulate, oreDict);
        }
        return toInsert;
    }

    @Override
    public Object extractFromFolder(ItemStack folder, long amount, boolean simulate, boolean creative) {
        CapabilityFolder cap = FolderUtils.get(folder).getCap();
        if (cap.isItemStack()) {
            return FolderType.NORMAL.extract(cap, amount, simulate, creative);
        }
        if (cap.isFluidStack()) {
            return FolderType.FLUID.extract(cap, amount, simulate, creative);
        }
        return null;
    }
}

