/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public class ItemAspectFolder
extends Item
implements IFolder {
    private static final int MAX_COUNT = 10000;

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag whatisthis) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RFC_aspectType")) {
            Aspect asp = ItemAspectFolder.getAspectFromFolder(stack);
            int count = ItemAspectFolder.getAspectCount(stack);
            list.add(asp.getName() + " x" + count);
        } else {
            list.add("<Empty>");
        }
    }

    public static boolean isAspectFolderEmpty(ItemStack stack) {
        return !stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b("RFC_aspectType");
    }

    public static Aspect getAspectFromFolder(ItemStack stack) {
        return Aspect.getAspect((String)NBTUtils.getString(stack, "RFC_aspectType", ""));
    }

    public static int getAspectCount(ItemStack stack) {
        return NBTUtils.getInt(stack, "RFC_aspectCount", 0);
    }

    public static void setAspect(ItemStack stack, Aspect asp) {
        NBTUtils.setString(stack, "RFC_aspectType", asp.getTag());
    }

    public static void setAspectCount(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, "RFC_aspectCount", amount);
    }

    public static void incrementAspect(ItemStack stack, int amount) {
        int current = ItemAspectFolder.getAspectCount(stack);
        ItemAspectFolder.setAspectCount(stack, current + amount);
    }

    public static void decrementAspect(ItemStack stack, int amount) {
        int current = ItemAspectFolder.getAspectCount(stack);
        ItemAspectFolder.setAspectCount(stack, Math.max(current - amount, 0));
    }

    public static int getMaxAmount() {
        return 10000;
    }

    @Override
    public ItemStack getEmptyFolder(ItemStack stack) {
        return new ItemStack(RFCItems.FOLDER_ASPECT);
    }

    @Override
    public Object insertIntoFolder(ItemStack folder, Object toInsert, boolean simulate, boolean oreDict) {
        return null;
    }

    @Override
    public Object extractFromFolder(ItemStack folder, long amount, boolean simulate, boolean creative) {
        return null;
    }
}

