/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.integration.loaders;

import com.bafomdad.realfilingcabinet.api.IBlockCabinet;
import com.bafomdad.realfilingcabinet.api.IEntityCabinet;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaLoader {
    public static void load(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaProvider(), BlockRFC.class);
        registrar.registerBodyProvider((IWailaEntityProvider)new WailaEntityProvider(), EntityCabinet.class);
        registrar.registerNBTProvider((IWailaEntityProvider)new WailaEntityProvider(), EntityCabinet.class);
    }

    public static class WailaEntityProvider
    implements IWailaEntityProvider {
        public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getNBTData().func_74764_b("inventory") && accessor.getEntity() instanceof IEntityCabinet) {
                currenttip.add("Currently carrying:");
                NBTTagCompound tag = accessor.getNBTData().func_74775_l("inventory");
                NBTTagList tagList = tag.func_150295_c("Items", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound itemTags = tagList.func_150305_b(i);
                    ItemStack stack = new ItemStack(itemTags);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFolder)) continue;
                    FolderUtils.get(stack).addTooltips(currenttip);
                }
            }
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
            EntityCabinet cabinet = (EntityCabinet)ent;
            tag.func_74782_a("inventory", (NBTBase)cabinet.getInventory().serializeNBT());
            return tag;
        }
    }

    public static class WailaProvider
    implements IWailaDataProvider {
        public List<String> getWailaBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getBlock() instanceof IBlockCabinet) {
                TileEntity tile = accessor.getTileEntity();
                List<String> strList = ((IBlockCabinet)accessor.getBlock()).getInfoOverlay(tile);
                if (!strList.isEmpty()) {
                    strList.stream().forEach(s -> currenttip.add((String)s));
                }
            }
            return currenttip;
        }

        @Nonnull
        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos pos) {
            if (tile instanceof TileFilingCabinet) {
                TileFilingCabinet cabinet = (TileFilingCabinet)tile;
                if (!cabinet.smeltingJobs.isEmpty()) {
                    NBTTagList tagList = new NBTTagList();
                    for (int[] job : cabinet.smeltingJobs) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74783_a("RFC_smeltingJob", job);
                        tagList.func_74742_a((NBTBase)nbt);
                    }
                    tag.func_74782_a("RFC_smeltList", (NBTBase)tagList);
                }
            }
            return tag;
        }
    }
}

