/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.api.ILockableCabinet;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.inventory.InventoryRFC;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityRFC
extends TileEntity
implements ITickable,
ILockableCabinet {
    private UUID owner;
    private InventoryRFC inv = new InventoryRFC(this, 8);
    public boolean isCreative = false;
    private long lastClickTime;
    private UUID lastClickUUID;
    public static final float offsetSpeed = 0.1f;
    public boolean isOpen = false;
    public float offset;
    public float renderOffset;

    public void func_73660_a() {
        if (this.isOpen) {
            this.offset -= 0.1f;
            if (this.offset <= -0.75f) {
                this.offset = -0.75f;
            }
        } else {
            this.offset += 0.1f;
            if (this.offset >= 0.05f) {
                this.offset = 0.05f;
            }
        }
    }

    public InventoryRFC getInventory() {
        return this.inv;
    }

    public EntityItemFrame getItemFrame() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
        List frames = this.func_145831_w().func_72872_a(EntityItemFrame.class, aabb);
        for (EntityItemFrame frame : frames) {
            IBlockState state;
            EnumFacing tileFacing;
            EnumFacing orientation = frame.func_184172_bi();
            if (orientation != (tileFacing = (EnumFacing)(state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177229_b((IProperty)BlockRFC.FACING))) continue;
            return frame;
        }
        return null;
    }

    public ItemStack getFilter() {
        EntityItemFrame frame = this.getItemFrame();
        if (frame != null && !frame.func_82335_i().func_190926_b()) {
            if (frame.func_82335_i().func_77973_b() == RFCItems.FILTER) {
                int rotation = frame.func_82333_j();
                return this.getInventory().getStackFromFolder(rotation);
            }
            return frame.func_82335_i();
        }
        return ItemStack.field_190927_a;
    }

    public boolean calcLastClick(EntityPlayer player) {
        boolean bool = false;
        if (this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID)) {
            bool = true;
        }
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return bool;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeCustomNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readCustomNBT(tag);
    }

    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74757_a("isOpen", this.isOpen);
        tag.func_74757_a("TAG_creativeUpgrade", this.isCreative);
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
        tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
    }

    public void readCustomNBT(NBTTagCompound tag) {
        this.isOpen = tag.func_74767_n("isOpen");
        this.isCreative = tag.func_74767_n("TAG_creativeUpgrade");
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        this.inv.deserializeNBT(tag.func_74775_l("inventory"));
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public boolean isCabinetLocked() {
        return this.getOwner() != null;
    }

    public void doKeyStuff(EntityPlayer player, ItemStack key) {
        if (!this.isCabinetLocked()) {
            if (key.func_77952_i() == 0) {
                this.setOwner(player.func_110124_au());
                player.func_146105_b((ITextComponent)new TextComponentString("Cabinet locked"), true);
                return;
            }
        } else if (this.getOwner().equals(player.func_110124_au())) {
            if (key.func_77952_i() == 0) {
                this.setOwner(null);
                player.func_146105_b((ITextComponent)new TextComponentString("Cabinet unlocked"), true);
                return;
            }
            if (key.func_77952_i() == 1 && (!key.func_77942_o() || key.func_77942_o() && !key.func_77978_p().func_74764_b("OwnCopy"))) {
                NBTUtils.setString(key, "OwnCopy", player.func_110124_au().toString());
                NBTUtils.setString(key, "RFC_playername", player.getDisplayNameString());
            }
        }
    }

    @Override
    public boolean hasKeyCopy(EntityPlayer player, UUID uuid) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack keyCopy = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (keyCopy.func_77973_b() != RFCItems.KEY || keyCopy.func_77952_i() != 1 || !keyCopy.func_77942_o() || !keyCopy.func_77978_p().func_74764_b("OwnCopy")) continue;
            return uuid.equals(UUID.fromString(keyCopy.func_77978_p().func_74779_i("OwnCopy")));
        }
        return false;
    }

    @Override
    public void markBlockForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public void markBlockForRenderUpdate() {
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeCustomNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet != null && packet.func_148857_g() != null) {
            this.readCustomNBT(packet.func_148857_g());
        }
        this.markBlockForRenderUpdate();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (this.hasCapability(cap, side)) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        return (T)super.getCapability(cap, side);
    }

    public void getDrops(NonNullList<ItemStack> list) {
        ItemStack stack = (ItemStack)list.get(0);
        if (!stack.func_190926_b()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        }
    }

    public void onPlaced(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("inventory")) {
            this.inv.deserializeNBT(stack.func_77978_p().func_74775_l("inventory"));
        }
    }
}

