/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.achievements.ARAchivements;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.network.PacketAsteroidInfo;
import zmaster587.advancedRocketry.network.PacketConfigSync;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.advancedRocketry.util.GravityHandler;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;

public class PlanetEventHandler {
    public static long time = 0L;
    private static long endTime;
    private static long duration;
    private static List<TransitionEntity> transitionMap;
    static final ItemStack component;

    public static void addDelayedTransition(TransitionEntity entity) {
        transitionMap.add(entity);
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting != null) {
            Item item = event.crafting.func_77973_b();
        }
    }

    @SubscribeEvent
    public void CheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        DimensionProperties properties;
        World world = event.getWorld();
        DimensionManager manager = DimensionManager.getInstance();
        if (manager.isInitialized() && (properties = manager.getDimensionProperties(world.field_73011_w.getDimension())) != null && !properties.getAtmosphere().isImmune(event.getEntityLiving().getClass())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void SpawnEntity(WorldEvent.PotentialSpawns event) {
        List<SpawnListEntryNBT> entries;
        World world = event.getWorld();
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension());
        if (properties != null && !(entries = properties.getSpawnListEntries()).isEmpty() && event.getType() != EnumCreatureType.MONSTER) {
            event.getList().addAll(entries);
        }
    }

    @SubscribeEvent
    public void onWorldGen(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w instanceof WorldProviderPlanet && DimensionManager.getInstance().getDimensionProperties(event.getWorld().field_73011_w.getDimension()).getOreGenProperties(event.getWorld()) != null) {
            switch (event.getType()) {
                case COAL: 
                case DIAMOND: 
                case EMERALD: 
                case GOLD: 
                case IRON: 
                case LAPIS: 
                case QUARTZ: 
                case REDSTONE: 
                case CUSTOM: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                default: {
                    event.setResult(Event.Result.DEFAULT);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPickup(PlayerEvent.ItemPickupEvent event) {
        if (event.pickedUp == null || !event.pickedUp.func_92059_d().func_190926_b()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_70163_u > 260.0 && event.getEntity().field_70163_u < 270.0 && event.getEntity().field_70181_x < -0.1) {
            RocketEventHandler.destroyOrbitalTextures(event.getEntity().field_70170_p);
        }
        if (event.getEntity().func_70090_H() && AtmosphereType.LOWOXYGEN.isImmune(event.getEntityLiving())) {
            event.getEntity().func_70050_g(300);
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && event.getEntity() instanceof EntityPlayer && DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_70170_p.field_73011_w.getDimension()).getName().equals("Luna") && event.getEntity().func_180425_c().func_177954_c(2347.0, 80.0, 67.0) < 512.0) {
            ARAchivements.WENT_TO_THE_MOON.trigger((EntityPlayerMP)event.getEntity());
        }
        GravityHandler.applyGravity(event.getEntity());
    }

    @SubscribeEvent
    public void sleepEvent(PlayerSleepInBedEvent event) {
        if (event.getEntity().field_70170_p.field_73011_w instanceof WorldProviderPlanet && !Configuration.forcePlayerRespawnInSpace && AtmosphereHandler.hasAtmosphereHandler(event.getEntity().field_70170_p.field_73011_w.getDimension()) && !AtmosphereHandler.getOxygenHandler(event.getEntity().field_70170_p.field_73011_w.getDimension()).getAtmosphereType(event.getPos()).isBreathable()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public void blockPlaceEvent(PlayerInteractEvent.RightClickBlock event) {
        EnumFacing direction = event.getFace();
        if (!event.getWorld().field_72995_K && direction != null && event.getEntityPlayer() != null && AtmosphereHandler.getOxygenHandler(event.getWorld().field_73011_w.getDimension()) != null && !AtmosphereHandler.getOxygenHandler(event.getWorld().field_73011_w.getDimension()).getAtmosphereType(event.getPos().func_177972_a(direction)).allowsCombustion() && event.getEntityPlayer().func_184586_b(event.getHand()) != null) {
            if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && event.getWorld().func_180495_p(event.getPos()).isSideSolid((IBlockAccess)event.getWorld(), event.getPos(), direction)) {
                event.setCanceled(true);
                event.getWorld().func_175656_a(event.getPos().func_177972_a(direction), AdvancedRocketryBlocks.blockUnlitTorch.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)direction));
            } else if (Configuration.torchBlocks.contains(Block.func_149634_a((Item)event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b()))) {
                event.setCanceled(true);
            } else if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151033_d || event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151059_bz || event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151065_br || event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151072_bj || event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151129_at) {
                event.setCanceled(true);
            }
        }
        if (!event.getWorld().field_72995_K && event.getItemStack() != null && event instanceof PlayerInteractEvent.RightClickBlock && event.getItemStack().func_77973_b() == Items.field_151104_aV && event.getWorld().field_73011_w instanceof WorldProviderPlanet) {
            AdvancedRocketryItems.itemAstroBed.func_180614_a(event.getEntityPlayer(), event.getEntityPlayer().field_70170_p, event.getPos(), event.getHand(), event.getFace(), 0.0f, 0.0f, 0.0f);
            event.setCanceled(true);
        }
        if (!event.getWorld().field_72995_K && event.getItemStack() != null && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockGenericSeat) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150335_W) {
            ARAchivements.BEER.trigger((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @Mod.EventHandler
    public void disconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        DimensionManager.getInstance().unregisterAllDimensions();
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensions();
            ++time;
            if (!transitionMap.isEmpty()) {
                Iterator<TransitionEntity> itr = transitionMap.iterator();
                while (itr.hasNext()) {
                    TransitionEntity ent = itr.next();
                    if (ent.entity.field_70170_p.func_82737_E() < ent.time) continue;
                    ent.entity.func_70012_b((double)ent.location.func_177958_n(), (double)ent.location.func_177956_o(), (double)ent.location.func_177952_p(), ent.entity.field_70177_z, ent.entity.field_70125_A);
                    ent.entity.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)ent.entity, ent.dimId, (Teleporter)new TeleporterNoPortal(ent.entity.func_184102_h().func_71218_a(ent.dimId)));
                    ent.entity.func_184220_m(ent.entity2);
                    itr.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensionsClient();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        PacketHandler.sendToDispatcher((BasePacket)new PacketConfigSync(), (NetworkManager)event.getManager());
        Object object = DimensionManager.getInstance().getStarIds().iterator();
        while (object.hasNext()) {
            int n = object.next();
            PacketHandler.sendToDispatcher((BasePacket)new PacketStellarInfo(n, DimensionManager.getInstance().getStar(n)), (NetworkManager)event.getManager());
        }
        object = DimensionManager.getInstance().getRegisteredDimensions();
        int n = ((Integer[])object).length;
        for (int i = 0; i < n; ++i) {
            int i2 = object[i];
            PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(i2, DimensionManager.getInstance().getDimensionProperties(i2)), (NetworkManager)event.getManager());
        }
        for (ISpaceObject iSpaceObject : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            PacketHandler.sendToDispatcher((BasePacket)new PacketSpaceStationInfo(iSpaceObject.getId(), iSpaceObject), (NetworkManager)event.getManager());
        }
        PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(0, DimensionManager.getInstance().getDimensionProperties(0)), (NetworkManager)event.getManager());
        for (Map.Entry entry : Configuration.asteroidTypes.entrySet()) {
            PacketHandler.sendToDispatcher((BasePacket)new PacketAsteroidInfo((AsteroidSmall)entry.getValue()), (NetworkManager)event.getManager());
        }
    }

    public void connectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        DimensionManager.getInstance().unregisterAllDimensions();
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            AtmosphereHandler.registerWorld(event.getWorld().field_73011_w.getDimension());
        } else if (Configuration.skyOverride && event.getWorld().field_73011_w.getDimension() == 0) {
            event.getWorld().field_73011_w.setSkyRenderer((IRenderHandler)new RenderPlanetarySky());
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            AtmosphereHandler.unregisterWorld(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void runBurst(long endTime, long duration) {
        PlanetEventHandler.endTime = endTime;
        PlanetEventHandler.duration = duration;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.FogColors event) {
        IBlockState state = ActiveRenderInfo.func_186703_a((World)event.getEntity().field_70170_p, (Entity)event.getEntity(), (float)((float)event.getRenderPartialTicks()));
        Block block = state.func_177230_c();
        if (block.func_149688_o(state) == Material.field_151586_h) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_71093_bK);
        if (properties != null) {
            float fog = properties.getAtmosphereDensityAtHeight(event.getEntity().field_70163_u);
            if (event.getEntity().field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
                Vec3d color = event.getEntity().field_70170_p.field_73011_w.getSkyColor(event.getEntity(), 0.0f);
                event.setRed((float)Math.min(color.field_72450_a * (double)1.4f, 1.0));
                event.setGreen((float)Math.min(color.field_72448_b * (double)1.4f, 1.0));
                event.setBlue((float)Math.min(color.field_72449_c * (double)1.4f, 1.0));
            }
            if (endTime > 0L) {
                double amt = (double)(endTime - Minecraft.func_71410_x().field_71441_e.func_82737_E()) / (double)duration;
                if (amt < 0.0) {
                    endTime = 0L;
                } else {
                    event.setRed((float)amt);
                    event.setGreen((float)amt);
                    event.setBlue((float)amt);
                }
            } else {
                event.setRed(event.getRed() * fog);
                event.setGreen(event.getGreen() * fog);
                event.setBlue(event.getBlue() * fog);
            }
        }
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.WorldTickEvent event) {
        Collection list;
        if (Configuration.allowTerraforming && event.world.field_73011_w.getClass() == WorldProviderPlanet.class && DimensionManager.getInstance().getDimensionProperties(event.world.field_73011_w.getDimension()).isTerraformed() && (list = ((WorldServer)event.world).func_72863_F().func_189548_a()).size() > 0) {
            try {
                int listSize = list.size();
                for (Chunk chunk : list) {
                    if (Configuration.terraformingBlockSpeed <= listSize && !(event.world.field_73012_v.nextFloat() < (float)Configuration.terraformingBlockSpeed / (float)listSize)) continue;
                    int coord = event.world.field_73012_v.nextInt(256);
                    int x = (coord & 0xF) + chunk.field_76635_g * 16;
                    int z = (coord >> 4) + chunk.field_76647_h * 16;
                    BiomeHandler.changeBiome(event.world, Biome.func_185362_a((Biome)((ChunkManagerPlanet)((WorldProviderPlanet)event.world.field_73011_w).chunkMgrTerraformed).getBiomeGenAt(x, z)), x, z);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(PopulateChunkEvent.Post event) {
        if (Configuration.allowTerraforming && event.getWorld().field_73011_w.getClass() == WorldProviderPlanet.class && DimensionManager.getInstance().getDimensionProperties(event.getWorld().field_73011_w.getDimension()).isTerraformed()) {
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            PlanetEventHandler.modifyChunk(event.getWorld(), (WorldProviderPlanet)event.getWorld().field_73011_w, chunk);
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkEvent.Load event) {
    }

    public static void modifyChunk(World world, WorldProviderPlanet provider, Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeHandler.changeBiome(world, Biome.func_185362_a((Biome)((ChunkManagerPlanet)((WorldProviderPlanet)world.field_73011_w).chunkMgrTerraformed).getBiomeGenAt(x + chunk.field_76635_g * 16, z + chunk.field_76647_h * 16)), chunk, x + chunk.field_76635_g * 16, z + chunk.field_76647_h * 16);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getFogMode() == -1) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_71093_bK);
        if (properties != null && event.getState().func_177230_c() != Blocks.field_150355_j && event.getState().func_177230_c() != Blocks.field_150353_l) {
            float far;
            float near;
            float fog = properties.getAtmosphereDensityAtHeight(event.getEntity().field_70163_u);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            float f1 = event.getFarPlaneDistance();
            int atmosphere = properties.getAtmosphereDensity();
            ItemStack armor = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
            if (armor != null && armor.func_77973_b() instanceof IModularArmor) {
                for (ItemStack i : ((IModularArmor)armor.func_77973_b()).getComponents(armor)) {
                    if (!i.func_77969_a(component)) continue;
                    atmosphere = Math.min(atmosphere, 100);
                    break;
                }
            }
            if (AtmosphereHandler.currentPressure != -1) {
                atmosphere = AtmosphereHandler.currentPressure;
            }
            if (atmosphere > 100) {
                near = 0.75f * f1 * (2.0f - (float)(atmosphere * atmosphere) / 10000.0f);
                far = f1;
            } else {
                near = 0.75f * f1 * (2.0f - (float)atmosphere / 100.0f);
                far = f1 * (2.002f - (float)atmosphere / 100.0f);
            }
            GlStateManager.func_179102_b((float)near);
            GlStateManager.func_179153_c((float)far);
            GlStateManager.func_179095_a((float)0.0f);
        }
    }

    @SubscribeEvent
    public void worldSaveEvent(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            try {
                DimensionManager.getInstance().saveDimensions("advRocketry");
            }
            catch (Exception e) {
                AdvancedRocketry.logger.fatal("An error has occured saving planet data, this can happen if another mod causes the game to crash during game load.  If the game has fully loaded, then this is a serious error, Advanced Rocketry data has not been saved.");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void fallEvent(LivingFallEvent event) {
        if (event.getEntity().field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
            IPlanetaryProvider planet = (IPlanetaryProvider)event.getEntity().field_70170_p.field_73011_w;
            event.setDistance((float)((double)event.getDistance() * planet.getGravitationalMultiplier(event.getEntity().func_180425_c())));
        }
    }

    static {
        transitionMap = new LinkedList<TransitionEntity>();
        component = new ItemStack(AdvancedRocketryItems.itemUpgrade, 1, 4);
    }
}

