/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.gui.GuiWidget;
import codechicken.lib.gui.IGuiActionListener;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiScreenWidget
extends GuiScreen
implements IGuiActionListener {
    public ArrayList<GuiWidget> widgets = new ArrayList();
    public int xSize;
    public int ySize;
    public int guiTop;
    public int guiLeft;

    public GuiScreenWidget() {
        this(176, 166);
    }

    public GuiScreenWidget(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void func_73866_w_() {
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        if (!this.widgets.isEmpty()) {
            this.resize();
        }
    }

    public void reset() {
        this.widgets.clear();
        this.func_73866_w_();
        this.addWidgets();
        this.resize();
    }

    public void func_146280_a(Minecraft mc, int i, int j) {
        boolean init = this.field_146297_k == null;
        super.func_146280_a(mc, i, j);
        if (init) {
            this.addWidgets();
            this.resize();
        }
    }

    public void add(GuiWidget widget) {
        this.widgets.add(widget);
        widget.onAdded(this);
    }

    public void func_73863_a(int mousex, int mousey, float f) {
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawBackground();
        for (GuiWidget widget : this.widgets) {
            widget.draw(mousex - this.guiLeft, mousey - this.guiTop, f);
        }
        this.drawForeground();
        GlStateManager.func_179109_b((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
    }

    public void drawBackground() {
    }

    public void drawForeground() {
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseClicked(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseReleased(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
        for (GuiWidget widget : this.widgets) {
            widget.mouseDragged(x - this.guiLeft, y - this.guiTop, button, time);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.field_146297_k.field_71462_r == this) {
            for (GuiWidget widget : this.widgets) {
                widget.update();
            }
        }
    }

    public void func_73869_a(char c, int keycode) throws IOException {
        super.func_73869_a(c, keycode);
        for (GuiWidget widget : this.widgets) {
            widget.keyTyped(c, keycode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            Point p = GuiDraw.getMousePosition();
            int scroll = i > 0 ? 1 : -1;
            for (GuiWidget widget : this.widgets) {
                widget.mouseScrolled(p.x, p.y, scroll);
            }
        }
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
    }

    public void resize() {
    }

    public void addWidgets() {
    }
}

