/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteFunction;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.function.LongPredicate;
import net.minecraft.util.math.MathHelper;

public abstract class LevelBasedGraph {
    private final int field_215486_a;
    private final LongLinkedOpenHashSet[] field_215487_b;
    private final Long2ByteFunction field_215488_c;
    private int field_215489_d;
    private volatile boolean field_215490_e;

    protected LevelBasedGraph(int levelCount, final int p_i51298_2_, final int p_i51298_3_) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.field_215486_a = levelCount;
        this.field_215487_b = new LongLinkedOpenHashSet[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            this.field_215487_b[i] = new LongLinkedOpenHashSet(p_i51298_2_, 0.5f){

                protected void rehash(int p_rehash_1_) {
                    if (p_rehash_1_ > p_i51298_2_) {
                        super.rehash(p_rehash_1_);
                    }
                }
            };
        }
        this.field_215488_c = new Long2ByteOpenHashMap(p_i51298_3_, 0.5f){

            protected void rehash(int p_rehash_1_) {
                if (p_rehash_1_ > p_i51298_3_) {
                    super.rehash(p_rehash_1_);
                }
            }
        };
        this.field_215488_c.defaultReturnValue((byte)-1);
        this.field_215489_d = levelCount;
    }

    private int func_215482_a(int level1, int level2) {
        int i = level1;
        if (level1 > level2) {
            i = level2;
        }
        if (i > this.field_215486_a - 1) {
            i = this.field_215486_a - 1;
        }
        return i;
    }

    private void func_215472_a(int maxLevel) {
        int i = this.field_215489_d;
        this.field_215489_d = maxLevel;
        for (int j = i + 1; j < maxLevel; ++j) {
            if (this.field_215487_b[j].isEmpty()) continue;
            this.field_215489_d = j;
            break;
        }
    }

    protected void func_215479_e(long positionIn) {
        int i = this.field_215488_c.get(positionIn) & 0xFF;
        if (i != 255) {
            int j = this.func_215471_c(positionIn);
            int k = this.func_215482_a(j, i);
            this.func_215484_a(positionIn, k, this.field_215486_a, true);
            this.field_215490_e = this.field_215489_d < this.field_215486_a;
        }
    }

    private void func_215484_a(long pos, int level, int maxLevel, boolean removeAll) {
        if (removeAll) {
            this.field_215488_c.remove(pos);
        }
        this.field_215487_b[level].remove(pos);
        if (this.field_215487_b[level].isEmpty() && this.field_215489_d == level) {
            this.func_215472_a(maxLevel);
        }
    }

    private void func_215470_a(long pos, int levelToSet, int updateLevel) {
        this.field_215488_c.put(pos, (byte)levelToSet);
        this.field_215487_b[updateLevel].add(pos);
        if (this.field_215489_d > updateLevel) {
            this.field_215489_d = updateLevel;
        }
    }

    protected void func_215473_f(long worldPos) {
        this.func_215469_a(worldPos, worldPos, this.field_215486_a - 1, false);
    }

    protected void func_215469_a(long fromPos, long toPos, int newLevel, boolean isDecreasing) {
        this.func_215474_a(fromPos, toPos, newLevel, this.func_215471_c(toPos), this.field_215488_c.get(toPos) & 0xFF, isDecreasing);
        this.field_215490_e = this.field_215489_d < this.field_215486_a;
    }

    private void func_215474_a(long fromPos, long toPos, int newLevel, int previousLevel, int propagationLevel, boolean isDecreasing) {
        if (!this.func_215485_a(toPos)) {
            boolean flag;
            newLevel = MathHelper.func_76125_a((int)newLevel, (int)0, (int)(this.field_215486_a - 1));
            previousLevel = MathHelper.func_76125_a((int)previousLevel, (int)0, (int)(this.field_215486_a - 1));
            if (propagationLevel == 255) {
                flag = true;
                propagationLevel = previousLevel;
            } else {
                flag = false;
            }
            int i = isDecreasing ? Math.min(propagationLevel, newLevel) : MathHelper.func_76125_a((int)this.func_215477_a(toPos, fromPos, newLevel), (int)0, (int)(this.field_215486_a - 1));
            int j = this.func_215482_a(previousLevel, propagationLevel);
            if (previousLevel != i) {
                int k = this.func_215482_a(previousLevel, i);
                if (j != k && !flag) {
                    this.func_215484_a(toPos, j, k, false);
                }
                this.func_215470_a(toPos, i, k);
            } else if (!flag) {
                this.func_215484_a(toPos, j, this.field_215486_a, true);
            }
        }
    }

    protected final void func_215475_b(long fromPos, long toPos, int sourceLevel, boolean isDecreasing) {
        int i = this.field_215488_c.get(toPos) & 0xFF;
        int j = MathHelper.func_76125_a((int)this.func_215480_b(fromPos, toPos, sourceLevel), (int)0, (int)(this.field_215486_a - 1));
        if (isDecreasing) {
            this.func_215474_a(fromPos, toPos, j, this.func_215471_c(toPos), i, true);
        } else {
            int k;
            boolean flag;
            if (i == 255) {
                flag = true;
                k = MathHelper.func_76125_a((int)this.func_215471_c(toPos), (int)0, (int)(this.field_215486_a - 1));
            } else {
                k = i;
                flag = false;
            }
            if (j == k) {
                this.func_215474_a(fromPos, toPos, this.field_215486_a - 1, flag ? k : this.func_215471_c(toPos), i, false);
            }
        }
    }

    protected final boolean func_215481_b() {
        return this.field_215490_e;
    }

    protected final int func_215483_b(int toUpdateCount) {
        if (this.field_215489_d >= this.field_215486_a) {
            return toUpdateCount;
        }
        while (this.field_215489_d < this.field_215486_a && toUpdateCount > 0) {
            int k;
            --toUpdateCount;
            LongLinkedOpenHashSet longlinkedopenhashset = this.field_215487_b[this.field_215489_d];
            long i = longlinkedopenhashset.removeFirstLong();
            int j = MathHelper.func_76125_a((int)this.func_215471_c(i), (int)0, (int)(this.field_215486_a - 1));
            if (longlinkedopenhashset.isEmpty()) {
                this.func_215472_a(this.field_215486_a);
            }
            if ((k = this.field_215488_c.remove(i) & 0xFF) < j) {
                this.func_215476_a(i, k);
                this.func_215478_a(i, k, true);
                continue;
            }
            if (k <= j) continue;
            this.func_215470_a(i, k, this.func_215482_a(this.field_215486_a - 1, k));
            this.func_215476_a(i, this.field_215486_a - 1);
            this.func_215478_a(i, j, false);
        }
        this.field_215490_e = this.field_215489_d < this.field_215486_a;
        return toUpdateCount;
    }

    protected abstract boolean func_215485_a(long var1);

    protected abstract int func_215477_a(long var1, long var3, int var5);

    protected abstract void func_215478_a(long var1, int var3, boolean var4);

    protected abstract int func_215471_c(long var1);

    protected abstract void func_215476_a(long var1, int var3);

    protected abstract int func_215480_b(long var1, long var3, int var5);

    protected int queuedUpdateSize() {
        return this.field_215488_c.size();
    }

    public final void bulkCancel(LongPredicate pred) {
        ((Long2ByteOpenHashMap)this.field_215488_c).keySet().forEach(l -> {
            if (pred.test(l)) {
                this.func_215479_e(l);
            }
        });
    }
}

