/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final boolean FORGE_ENABLE_EXTENDED_SAVE = Boolean.parseBoolean(System.getProperty("forge.enableExtendedSave", "true"));
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] field_76720_a = new byte[4096];
    private final RandomAccessFile field_76719_c;
    private final int[] field_76716_d = new int[1024];
    private final int[] field_76717_e = new int[1024];
    private final List<Boolean> field_76714_f;
    private final File filepath;

    public RegionFile(File fileNameIn) throws IOException {
        this.filepath = fileNameIn;
        this.field_76719_c = new RandomAccessFile(fileNameIn, "rw");
        if (this.field_76719_c.length() < 4096L) {
            this.field_76719_c.write(field_76720_a);
            this.field_76719_c.write(field_76720_a);
        }
        if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
            int i = 0;
            while ((long)i < (this.field_76719_c.length() & 0xFFFL)) {
                this.field_76719_c.write(0);
                ++i;
            }
        }
        int i1 = (int)this.field_76719_c.length() / 4096;
        this.field_76714_f = Lists.newArrayListWithCapacity((int)i1);
        for (int j = 0; j < i1; ++j) {
            this.field_76714_f.add(true);
        }
        this.field_76714_f.set(0, false);
        this.field_76714_f.set(1, false);
        this.field_76719_c.seek(0L);
        for (int j1 = 0; j1 < 1024; ++j1) {
            int k;
            this.field_76716_d[j1] = k = this.field_76719_c.readInt();
            int length = k & 0xFF;
            if (length == 255 && k >> 8 <= this.field_76714_f.size()) {
                this.field_76719_c.seek((k >> 8) * 4096);
                length = (this.field_76719_c.readInt() + 4) / 4096 + 1;
                this.field_76719_c.seek(j1 * 4 + 4);
            }
            if (k != 0 && (k >> 8) + length <= this.field_76714_f.size()) {
                for (int l = 0; l < length; ++l) {
                    this.field_76714_f.set((k >> 8) + l, false);
                }
                continue;
            }
            if (length <= 0) continue;
            LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Length: {} runs off end file. {}", (Object)(j1 % 32), (Object)(j1 / 32), (Object)(k >> 8), (Object)length, (Object)fileNameIn);
        }
        for (int k1 = 0; k1 < 1024; ++k1) {
            int l1;
            this.field_76717_e[k1] = l1 = this.field_76719_c.readInt();
        }
    }

    @Nullable
    public synchronized DataInputStream func_222666_a(ChunkPos pos) throws IOException {
        int i = this.func_222660_e(pos);
        if (i == 0) {
            return null;
        }
        int j = i >> 8;
        int k = i & 0xFF;
        if (k == 255) {
            this.field_76719_c.seek(j * 4096);
            k = (this.field_76719_c.readInt() + 4) / 4096 + 1;
        }
        if (j + k > this.field_76714_f.size()) {
            return null;
        }
        this.field_76719_c.seek(j * 4096);
        int l = this.field_76719_c.readInt();
        if (l > 4096 * k) {
            LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Invalid Size: {}>{} {}", (Object)pos.field_77276_a, (Object)pos.field_77275_b, (Object)j, (Object)l, (Object)(k * 4096), (Object)this.filepath);
            return null;
        }
        if (l <= 0) {
            LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Invalid Size: {} {}", (Object)pos.field_77276_a, (Object)pos.field_77275_b, (Object)j, (Object)l, (Object)this.filepath);
            return null;
        }
        byte b0 = this.field_76719_c.readByte();
        if (b0 == 1) {
            byte[] abyte1 = new byte[l - 1];
            this.field_76719_c.read(abyte1);
            return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte1))));
        }
        if (b0 == 2) {
            byte[] abyte = new byte[l - 1];
            this.field_76719_c.read(abyte);
            return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte))));
        }
        return null;
    }

    public boolean func_222662_b(ChunkPos p_222662_1_) {
        int i = this.func_222660_e(p_222662_1_);
        if (i == 0) {
            return false;
        }
        int j = i >> 8;
        int k = i & 0xFF;
        if (j + k > this.field_76714_f.size()) {
            return false;
        }
        try {
            this.field_76719_c.seek(j * 4096);
            int l = this.field_76719_c.readInt();
            if (l > 4096 * k) {
                return false;
            }
            return l > 0;
        }
        catch (IOException var6) {
            return false;
        }
    }

    public DataOutputStream func_222661_c(ChunkPos p_222661_1_) {
        return new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(p_222661_1_))));
    }

    protected synchronized void func_222664_a(ChunkPos p_222664_1_, byte[] p_222664_2_, int p_222664_3_) throws IOException {
        int l;
        int i = this.func_222660_e(p_222664_1_);
        int j = i >> 8;
        int k = i & 0xFF;
        if (k == 255) {
            this.field_76719_c.seek(j * 4096);
            k = (this.field_76719_c.readInt() + 4) / 4096 + 1;
        }
        if ((l = (p_222664_3_ + 5) / 4096 + 1) >= 256 && !FORGE_ENABLE_EXTENDED_SAVE) {
            throw new RuntimeException(String.format("Too big to save, %d > 1048576", p_222664_3_));
        }
        if (l >= 256) {
            LOGGER.warn("Large Chunk Detected: ({}, {}) Size: {} {}", (Object)p_222664_1_.field_77276_a, (Object)p_222664_1_.field_77275_b, (Object)l, (Object)this.filepath);
        }
        if (j != 0 && k == l) {
            this.func_76712_a(j, p_222664_2_, p_222664_3_);
        } else {
            for (int i1 = 0; i1 < k; ++i1) {
                this.field_76714_f.set(j + i1, true);
            }
            int l1 = this.field_76714_f.indexOf(true);
            int j1 = 0;
            if (l1 != -1) {
                for (int k1 = l1; k1 < this.field_76714_f.size(); ++k1) {
                    if (j1 != 0) {
                        j1 = this.field_76714_f.get(k1).booleanValue() ? ++j1 : 0;
                    } else if (this.field_76714_f.get(k1).booleanValue()) {
                        l1 = k1;
                        j1 = 1;
                    }
                    if (j1 >= l) break;
                }
            }
            if (j1 >= l) {
                j = l1;
                this.func_222663_a(p_222664_1_, l1 << 8 | (l > 255 ? 255 : l));
                for (int i2 = 0; i2 < l; ++i2) {
                    this.field_76714_f.set(j + i2, false);
                }
                this.func_76712_a(j, p_222664_2_, p_222664_3_);
            } else {
                this.field_76719_c.seek(this.field_76719_c.length());
                j = this.field_76714_f.size();
                for (int j2 = 0; j2 < l; ++j2) {
                    this.field_76719_c.write(field_76720_a);
                    this.field_76714_f.add(false);
                }
                this.func_76712_a(j, p_222664_2_, p_222664_3_);
                this.func_222663_a(p_222664_1_, j << 8 | (l > 255 ? 255 : l));
            }
        }
        this.func_222665_b(p_222664_1_, (int)(Util.func_211179_d() / 1000L));
    }

    private void func_76712_a(int sectorNumber, byte[] data, int length) throws IOException {
        this.field_76719_c.seek(sectorNumber * 4096);
        this.field_76719_c.writeInt(length + 1);
        this.field_76719_c.writeByte(2);
        this.field_76719_c.write(data, 0, length);
    }

    private int func_222660_e(ChunkPos p_222660_1_) {
        return this.field_76716_d[this.func_222668_f(p_222660_1_)];
    }

    public boolean func_222667_d(ChunkPos p_222667_1_) {
        return this.func_222660_e(p_222667_1_) != 0;
    }

    private void func_222663_a(ChunkPos p_222663_1_, int p_222663_2_) throws IOException {
        int i = this.func_222668_f(p_222663_1_);
        this.field_76716_d[i] = p_222663_2_;
        this.field_76719_c.seek(i * 4);
        this.field_76719_c.writeInt(p_222663_2_);
    }

    private int func_222668_f(ChunkPos p_222668_1_) {
        return p_222668_1_.func_222240_j() + p_222668_1_.func_222238_k() * 32;
    }

    private void func_222665_b(ChunkPos p_222665_1_, int p_222665_2_) throws IOException {
        int i = this.func_222668_f(p_222665_1_);
        this.field_76717_e[i] = p_222665_2_;
        this.field_76719_c.seek(4096 + i * 4);
        this.field_76719_c.writeInt(p_222665_2_);
    }

    @Override
    public void close() throws IOException {
        this.field_76719_c.close();
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos field_222659_b;

        public ChunkBuffer(ChunkPos p_i50620_2_) {
            super(8096);
            this.field_222659_b = p_i50620_2_;
        }

        @Override
        public void close() throws IOException {
            RegionFile.this.func_222664_a(this.field_222659_b, this.buf, this.count);
        }
    }
}

