/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import java.util.function.Predicate;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Block;
import net.minecraft.block.PumpkinBlock;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraftforge.common.IExtensibleEnum;

public enum EnchantmentType implements IExtensibleEnum
{
    ALL{

        @Override
        public boolean func_77557_a(Item itemIn) {
            for (EnchantmentType enchantmenttype : EnchantmentType.values()) {
                if (enchantmenttype == ALL || !enchantmenttype.func_77557_a(itemIn)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    ARMOR{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ArmorItem;
        }
    }
    ,
    ARMOR_FEET{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ArmorItem && ((ArmorItem)itemIn).func_185083_B_() == EquipmentSlotType.FEET;
        }
    }
    ,
    ARMOR_LEGS{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ArmorItem && ((ArmorItem)itemIn).func_185083_B_() == EquipmentSlotType.LEGS;
        }
    }
    ,
    ARMOR_CHEST{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ArmorItem && ((ArmorItem)itemIn).func_185083_B_() == EquipmentSlotType.CHEST;
        }
    }
    ,
    ARMOR_HEAD{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ArmorItem && ((ArmorItem)itemIn).func_185083_B_() == EquipmentSlotType.HEAD;
        }
    }
    ,
    WEAPON{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof SwordItem;
        }
    }
    ,
    DIGGER{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof ToolItem;
        }
    }
    ,
    FISHING_ROD{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof FishingRodItem;
        }
    }
    ,
    TRIDENT{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof TridentItem;
        }
    }
    ,
    BREAKABLE{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn.func_77645_m();
        }
    }
    ,
    BOW{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof BowItem;
        }
    }
    ,
    WEARABLE{

        @Override
        public boolean func_77557_a(Item itemIn) {
            Block block = Block.func_149634_a(itemIn);
            return itemIn instanceof ArmorItem || itemIn instanceof ElytraItem || block instanceof AbstractSkullBlock || block instanceof PumpkinBlock;
        }
    }
    ,
    CROSSBOW{

        @Override
        public boolean func_77557_a(Item itemIn) {
            return itemIn instanceof CrossbowItem;
        }
    };

    private Predicate<Item> delegate;

    private EnchantmentType() {
    }

    private EnchantmentType(Predicate<Item> delegate) {
        this.delegate = delegate;
    }

    public static EnchantmentType create(String name, Predicate<Item> delegate) {
        throw new IllegalStateException("Enum not extended");
    }

    public boolean func_77557_a(Item itemIn) {
        return this.delegate == null ? false : this.delegate.test(itemIn);
    }
}

