/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class VertexFormat {
    private static final Logger field_177357_a = LogManager.getLogger();
    private final List<VertexFormatElement> field_177355_b = Lists.newArrayList();
    private final List<Integer> field_177356_c = Lists.newArrayList();
    private int field_177353_d;
    private int field_177354_e = -1;
    private final List<Integer> field_177351_f = Lists.newArrayList();
    private int field_177352_g = -1;
    private int hashCode;

    public VertexFormat(VertexFormat vertexFormatIn) {
        this();
        for (int i = 0; i < vertexFormatIn.func_177345_h(); ++i) {
            this.func_181721_a(vertexFormatIn.func_177348_c(i));
        }
        this.field_177353_d = vertexFormatIn.func_177338_f();
    }

    public VertexFormat() {
    }

    public void func_207749_a() {
        this.field_177355_b.clear();
        this.field_177356_c.clear();
        this.field_177354_e = -1;
        this.field_177351_f.clear();
        this.field_177352_g = -1;
        this.field_177353_d = 0;
        this.hashCode = 0;
    }

    public VertexFormat func_181721_a(VertexFormatElement element) {
        if (element.func_177374_g() && this.func_177341_i()) {
            field_177357_a.warn("VertexFormat error: Trying to add a position VertexFormatElement when one already exists, ignoring.");
            return this;
        }
        this.field_177355_b.add(element);
        this.field_177356_c.add(this.field_177353_d);
        switch (element.func_177375_c()) {
            case NORMAL: {
                this.field_177352_g = this.field_177353_d;
                break;
            }
            case COLOR: {
                this.field_177354_e = this.field_177353_d;
                break;
            }
            case UV: {
                this.field_177351_f.add(element.func_177369_e(), this.field_177353_d);
            }
        }
        this.field_177353_d += element.func_177368_f();
        this.hashCode = 0;
        return this;
    }

    public boolean func_207751_b() {
        return this.field_177352_g >= 0;
    }

    public int func_177342_c() {
        return this.field_177352_g;
    }

    public boolean func_207752_d() {
        return this.field_177354_e >= 0;
    }

    public int func_177340_e() {
        return this.field_177354_e;
    }

    public boolean func_207750_a(int id) {
        return this.field_177351_f.size() - 1 >= id;
    }

    public int func_177344_b(int id) {
        return this.field_177351_f.get(id);
    }

    public String toString() {
        String s = "format: " + this.field_177355_b.size() + " elements: ";
        for (int i = 0; i < this.field_177355_b.size(); ++i) {
            s = s + this.field_177355_b.get(i).toString();
            if (i == this.field_177355_b.size() - 1) continue;
            s = s + " ";
        }
        return s;
    }

    private boolean func_177341_i() {
        int j = this.field_177355_b.size();
        for (int i = 0; i < j; ++i) {
            VertexFormatElement vertexformatelement = this.field_177355_b.get(i);
            if (!vertexformatelement.func_177374_g()) continue;
            return true;
        }
        return false;
    }

    public int func_181719_f() {
        return this.func_177338_f() / 4;
    }

    public int func_177338_f() {
        return this.field_177353_d;
    }

    public List<VertexFormatElement> func_177343_g() {
        return this.field_177355_b;
    }

    public int func_177345_h() {
        return this.field_177355_b.size();
    }

    public VertexFormatElement func_177348_c(int index) {
        return this.field_177355_b.get(index);
    }

    public int func_181720_d(int index) {
        return this.field_177356_c.get(index);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormat vertexformat = (VertexFormat)p_equals_1_;
            if (this.field_177353_d != vertexformat.field_177353_d) {
                return false;
            }
            return !this.field_177355_b.equals(vertexformat.field_177355_b) ? false : this.field_177356_c.equals(vertexformat.field_177356_c);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int i = this.field_177355_b.hashCode();
        i = 31 * i + this.field_177356_c.hashCode();
        this.hashCode = i = 31 * i + this.field_177353_d;
        return i;
    }
}

