/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class Tag<T> {
    private final ResourceLocation field_199888_a;
    private final Set<T> field_199889_b;
    private final Collection<ITagEntry<T>> field_200150_c;

    public Tag(ResourceLocation resourceLocation) {
        this.field_199888_a = resourceLocation;
        this.field_199889_b = Collections.emptySet();
        this.field_200150_c = Collections.emptyList();
    }

    public Tag(ResourceLocation resourceLocation, Collection<ITagEntry<T>> collection, boolean bl) {
        this.field_199888_a = resourceLocation;
        this.field_199889_b = bl ? Sets.newLinkedHashSet() : Sets.newHashSet();
        this.field_200150_c = collection;
        for (ITagEntry<T> iTagEntry : collection) {
            iTagEntry.func_200162_a(this.field_199889_b);
        }
    }

    public JsonObject func_200571_a(Function<T, ResourceLocation> function) {
        JsonObject jsonObject = new JsonObject();
        JsonArray \u26032 = new JsonArray();
        for (ITagEntry<T> iTagEntry : this.field_200150_c) {
            iTagEntry.func_200576_a(\u26032, function);
        }
        jsonObject.addProperty("replace", Boolean.valueOf(false));
        jsonObject.add("values", (JsonElement)\u26032);
        return jsonObject;
    }

    public boolean func_199685_a_(T t) {
        return this.field_199889_b.contains(t);
    }

    public Collection<T> func_199885_a() {
        return this.field_199889_b;
    }

    public Collection<ITagEntry<T>> func_200570_b() {
        return this.field_200150_c;
    }

    public T func_205596_a(Random random) {
        ArrayList arrayList = Lists.newArrayList(this.func_199885_a());
        return (T)arrayList.get(random.nextInt(arrayList.size()));
    }

    public ResourceLocation func_199886_b() {
        return this.field_199888_a;
    }

    public static class TagEntry<T>
    implements ITagEntry<T> {
        @Nullable
        private final ResourceLocation field_200163_a;
        @Nullable
        private Tag<T> field_200164_b;

        public TagEntry(ResourceLocation resourceLocation) {
            this.field_200163_a = resourceLocation;
        }

        public TagEntry(Tag<T> tag) {
            this.field_200163_a = tag.func_199886_b();
            this.field_200164_b = tag;
        }

        @Override
        public boolean func_200161_a(Function<ResourceLocation, Tag<T>> function) {
            if (this.field_200164_b == null) {
                this.field_200164_b = function.apply(this.field_200163_a);
            }
            return this.field_200164_b != null;
        }

        @Override
        public void func_200162_a(Collection<T> collection) {
            if (this.field_200164_b == null) {
                throw new IllegalStateException("Cannot build unresolved tag entry");
            }
            collection.addAll(this.field_200164_b.func_199885_a());
        }

        public ResourceLocation func_200577_a() {
            if (this.field_200164_b != null) {
                return this.field_200164_b.func_199886_b();
            }
            if (this.field_200163_a != null) {
                return this.field_200163_a;
            }
            throw new IllegalStateException("Cannot serialize an anonymous tag to json!");
        }

        @Override
        public void func_200576_a(JsonArray jsonArray, Function<T, ResourceLocation> function) {
            jsonArray.add("#" + this.func_200577_a());
        }
    }

    public static class ListEntry<T>
    implements ITagEntry<T> {
        private final Collection<T> field_200165_a;

        public ListEntry(Collection<T> collection) {
            this.field_200165_a = collection;
        }

        @Override
        public void func_200162_a(Collection<T> collection) {
            collection.addAll(this.field_200165_a);
        }

        @Override
        public void func_200576_a(JsonArray jsonArray, Function<T, ResourceLocation> function) {
            for (T t : this.field_200165_a) {
                ResourceLocation resourceLocation = function.apply(t);
                if (resourceLocation == null) {
                    throw new IllegalStateException("Unable to serialize an anonymous value to json!");
                }
                jsonArray.add(resourceLocation.toString());
            }
        }

        public Collection<T> func_200578_a() {
            return this.field_200165_a;
        }
    }

    public static interface ITagEntry<T> {
        default public boolean func_200161_a(Function<ResourceLocation, Tag<T>> function) {
            return true;
        }

        public void func_200162_a(Collection<T> var1);

        public void func_200576_a(JsonArray var1, Function<T, ResourceLocation> var2);
    }

    public static class Builder<T> {
        private final Set<ITagEntry<T>> field_200052_a = Sets.newLinkedHashSet();
        private boolean field_200053_b;

        public static <T> Builder<T> func_200047_a() {
            return new Builder<T>();
        }

        public Builder<T> func_200575_a(ITagEntry<T> iTagEntry) {
            this.field_200052_a.add(iTagEntry);
            return this;
        }

        public Builder<T> func_200048_a(T t) {
            this.field_200052_a.add(new ListEntry<T>(Collections.singleton(t)));
            return this;
        }

        @SafeVarargs
        public final Builder<T> func_200573_a(T ... TArray) {
            this.field_200052_a.add(new ListEntry(Lists.newArrayList((Object[])TArray)));
            return this;
        }

        public Builder<T> func_200574_a(Tag<T> tag) {
            this.field_200052_a.add(new TagEntry<T>(tag));
            return this;
        }

        public Builder<T> func_200045_a(boolean bl) {
            this.field_200053_b = bl;
            return this;
        }

        public boolean func_200160_a(Function<ResourceLocation, Tag<T>> function) {
            for (ITagEntry<T> iTagEntry : this.field_200052_a) {
                if (iTagEntry.func_200161_a(function)) continue;
                return false;
            }
            return true;
        }

        public Tag<T> func_200051_a(ResourceLocation resourceLocation) {
            return new Tag<T>(resourceLocation, this.field_200052_a, this.field_200053_b);
        }

        public Builder<T> func_219783_a(Function<ResourceLocation, Optional<T>> function, JsonObject jsonObject) {
            JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "values");
            ArrayList \u26032 = Lists.newArrayList();
            for (JsonElement jsonElement : jsonArray) {
                String string = JSONUtils.func_151206_a(jsonElement, "value");
                if (string.startsWith("#")) {
                    \u26032.add(new TagEntry(new ResourceLocation(string.substring(1))));
                    continue;
                }
                ResourceLocation \u26033 = new ResourceLocation(string);
                \u26032.add(new ListEntry<T>(Collections.singleton(function.apply(\u26033).orElseThrow(() -> new JsonParseException("Unknown value '" + \u26033 + "'")))));
            }
            if (JSONUtils.func_151209_a(jsonObject, "replace", false)) {
                this.field_200052_a.clear();
            }
            this.field_200052_a.addAll(\u26032);
            return this;
        }
    }
}

