/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class WalkAndSwimNodeProcessor
extends WalkNodeProcessor {
    private float field_203247_k;
    private float field_203248_l;

    @Override
    public void func_186315_a(IWorldReader iWorldReader, MobEntity mobEntity) {
        super.func_186315_a(iWorldReader, mobEntity);
        mobEntity.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_203247_k = mobEntity.func_184643_a(PathNodeType.WALKABLE);
        mobEntity.func_184644_a(PathNodeType.WALKABLE, 6.0f);
        this.field_203248_l = mobEntity.func_184643_a(PathNodeType.WATER_BORDER);
        mobEntity.func_184644_a(PathNodeType.WATER_BORDER, 4.0f);
    }

    @Override
    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WALKABLE, this.field_203247_k);
        this.field_186326_b.func_184644_a(PathNodeType.WATER_BORDER, this.field_203248_l);
        super.func_176163_a();
    }

    @Override
    public PathPoint func_186318_b() {
        return this.func_176159_a(MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5), MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72339_c));
    }

    @Override
    public FlaggedPathPoint func_224768_a(double d, double d2, double d3) {
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2 + 0.5), MathHelper.func_76128_c(d3)));
    }

    @Override
    public int func_222859_a(PathPoint[] pathPointArray, PathPoint pathPoint) {
        int n = 0;
        boolean \u26032 = true;
        BlockPos \u26033 = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
        double \u26034 = this.func_203246_a(\u26033);
        PathPoint \u26035 = this.func_203245_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, 1, \u26034);
        PathPoint \u26036 = this.func_203245_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c, 1, \u26034);
        PathPoint \u26037 = this.func_203245_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c, 1, \u26034);
        PathPoint \u26038 = this.func_203245_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, 1, \u26034);
        PathPoint \u26039 = this.func_203245_a(pathPoint.field_75839_a, pathPoint.field_75837_b + 1, pathPoint.field_75838_c, 0, \u26034);
        PathPoint \u260310 = this.func_203245_a(pathPoint.field_75839_a, pathPoint.field_75837_b - 1, pathPoint.field_75838_c, 1, \u26034);
        if (\u26035 != null && !\u26035.field_75842_i) {
            pathPointArray[n++] = \u26035;
        }
        if (\u26036 != null && !\u26036.field_75842_i) {
            pathPointArray[n++] = \u26036;
        }
        if (\u26037 != null && !\u26037.field_75842_i) {
            pathPointArray[n++] = \u26037;
        }
        if (\u26038 != null && !\u26038.field_75842_i) {
            pathPointArray[n++] = \u26038;
        }
        if (\u26039 != null && !\u26039.field_75842_i) {
            pathPointArray[n++] = \u26039;
        }
        if (\u260310 != null && !\u260310.field_75842_i) {
            pathPointArray[n++] = \u260310;
        }
        boolean \u260311 = \u26038 == null || \u26038.field_186287_m == PathNodeType.OPEN || \u26038.field_186286_l != 0.0f;
        boolean \u260312 = \u26035 == null || \u26035.field_186287_m == PathNodeType.OPEN || \u26035.field_186286_l != 0.0f;
        boolean \u260313 = \u26037 == null || \u26037.field_186287_m == PathNodeType.OPEN || \u26037.field_186286_l != 0.0f;
        boolean bl = \u2603 = \u26036 == null || \u26036.field_186287_m == PathNodeType.OPEN || \u26036.field_186286_l != 0.0f;
        if (\u260311 && \u2603 && (\u2603 = this.func_203245_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, 1, \u26034)) != null && !\u2603.field_75842_i) {
            pathPointArray[n++] = \u2603;
        }
        if (\u260311 && \u260313 && (\u2603 = this.func_203245_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, 1, \u26034)) != null && !\u2603.field_75842_i) {
            pathPointArray[n++] = \u2603;
        }
        if (\u260312 && \u2603 && (\u2603 = this.func_203245_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, 1, \u26034)) != null && !\u2603.field_75842_i) {
            pathPointArray[n++] = \u2603;
        }
        if (\u260312 && \u260313 && (\u2603 = this.func_203245_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, 1, \u26034)) != null && !\u2603.field_75842_i) {
            pathPointArray[n++] = \u2603;
        }
        return n;
    }

    private double func_203246_a(BlockPos blockPos2) {
        BlockPos blockPos2;
        if (!this.field_186326_b.func_70090_H()) {
            \u2603 = blockPos2.func_177977_b();
            VoxelShape voxelShape = this.field_176169_a.func_180495_p(\u2603).func_196952_d(this.field_176169_a, \u2603);
            return (double)\u2603.func_177956_o() + (voxelShape.func_197766_b() ? 0.0 : voxelShape.func_197758_c(Direction.Axis.Y));
        }
        return (double)blockPos2.func_177956_o() + 0.5;
    }

    @Nullable
    private PathPoint func_203245_a(int n5, int n2, int n3, int n4, double d) {
        PathPoint \u26038 = null;
        BlockPos \u26032 = new BlockPos(n5, n2, n3);
        double \u26033 = this.func_203246_a(\u26032);
        if (\u26033 - d > 1.125) {
            return null;
        }
        PathNodeType \u26034 = this.func_186319_a(this.field_176169_a, n5, n2, n3, this.field_186326_b, this.field_176168_c, this.field_176165_d, this.field_176166_e, false, false);
        float \u26035 = this.field_186326_b.func_184643_a(\u26034);
        double \u26036 = (double)this.field_186326_b.func_213311_cf() / 2.0;
        if (\u26035 >= 0.0f) {
            \u26038 = this.func_176159_a(n5, n2, n3);
            \u26038.field_186287_m = \u26034;
            \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
        }
        if (\u26034 == PathNodeType.WATER || \u26034 == PathNodeType.WALKABLE) {
            if (n2 < this.field_186326_b.field_70170_p.func_181545_F() - 10 && \u26038 != null) {
                \u26038.field_186286_l += 1.0f;
            }
            return \u26038;
        }
        if (\u26038 == null && n4 > 0 && \u26034 != PathNodeType.FENCE && \u26034 != PathNodeType.TRAPDOOR) {
            \u26038 = this.func_203245_a(n5, n2 + 1, n3, n4 - 1, d);
        }
        if (\u26034 == PathNodeType.OPEN) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)n5 - \u26036 + 0.5, (double)n2 + 0.001, (double)n3 - \u26036 + 0.5, (double)n5 + \u26036 + 0.5, (float)n2 + this.field_186326_b.func_213302_cg(), (double)n3 + \u26036 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_195586_b(this.field_186326_b, axisAlignedBB)) {
                return null;
            }
            PathNodeType \u26037 = this.func_186319_a(this.field_176169_a, n5, n2 - 1, n3, this.field_186326_b, this.field_176168_c, this.field_176165_d, this.field_176166_e, false, false);
            if (\u26037 == PathNodeType.BLOCKED) {
                \u26038 = this.func_176159_a(n5, n2, n3);
                \u26038.field_186287_m = PathNodeType.WALKABLE;
                \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
                return \u26038;
            }
            if (\u26037 == PathNodeType.WATER) {
                int n5;
                \u26038 = this.func_176159_a(n5, n2, n3);
                \u26038.field_186287_m = PathNodeType.WATER;
                \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
                return \u26038;
            }
            \u2603 = 0;
            while (n2 > 0 && \u26034 == PathNodeType.OPEN) {
                --n2;
                if (\u2603++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                \u26034 = this.func_186319_a(this.field_176169_a, n5, n2, n3, this.field_186326_b, this.field_176168_c, this.field_176165_d, this.field_176166_e, false, false);
                \u26035 = this.field_186326_b.func_184643_a(\u26034);
                if (\u26034 != PathNodeType.OPEN && \u26035 >= 0.0f) {
                    \u26038 = this.func_176159_a(n5, n2, n3);
                    \u26038.field_186287_m = \u26034;
                    \u26038.field_186286_l = Math.max(\u26038.field_186286_l, \u26035);
                    break;
                }
                if (!(\u26035 < 0.0f)) continue;
                return null;
            }
        }
        return \u26038;
    }

    @Override
    protected PathNodeType func_215744_a(IBlockReader iBlockReader, boolean bl, boolean bl2, BlockPos blockPos, PathNodeType pathNodeType) {
        if (pathNodeType == PathNodeType.RAIL && !(iBlockReader.func_180495_p(blockPos).func_177230_c() instanceof AbstractRailBlock) && !(iBlockReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() instanceof AbstractRailBlock)) {
            pathNodeType = PathNodeType.FENCE;
        }
        if (pathNodeType == PathNodeType.DOOR_OPEN || pathNodeType == PathNodeType.DOOR_WOOD_CLOSED || pathNodeType == PathNodeType.DOOR_IRON_CLOSED) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        if (pathNodeType == PathNodeType.LEAVES) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        return pathNodeType;
    }

    @Override
    public PathNodeType func_186330_a(IBlockReader iBlockReader2, int n, int n2, int n3) {
        IBlockReader iBlockReader2;
        PathNodeType \u26033 = this.func_189553_b(iBlockReader2, n, n2, n3);
        if (\u26033 == PathNodeType.WATER) {
            for (Direction direction : Direction.values()) {
                PathNodeType pathNodeType = this.func_189553_b(iBlockReader2, n + direction.func_82601_c(), n2 + direction.func_96559_d(), n3 + direction.func_82599_e());
                if (pathNodeType != PathNodeType.BLOCKED) continue;
                return PathNodeType.WATER_BORDER;
            }
            return PathNodeType.WATER;
        }
        if (\u26033 == PathNodeType.OPEN && n2 >= 1) {
            Block block = iBlockReader2.func_180495_p(new BlockPos(n, n2 - 1, n3)).func_177230_c();
            PathNodeType \u26032 = this.func_189553_b(iBlockReader2, n, n2 - 1, n3);
            \u26033 = \u26032 == PathNodeType.WALKABLE || \u26032 == PathNodeType.OPEN || \u26032 == PathNodeType.LAVA ? PathNodeType.OPEN : PathNodeType.WALKABLE;
            if (\u26032 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ || block == Blocks.field_222433_lV) {
                \u26033 = PathNodeType.DAMAGE_FIRE;
            }
            if (\u26032 == PathNodeType.DAMAGE_CACTUS) {
                \u26033 = PathNodeType.DAMAGE_CACTUS;
            }
            if (\u26032 == PathNodeType.DAMAGE_OTHER) {
                \u26033 = PathNodeType.DAMAGE_OTHER;
            }
        }
        \u26033 = this.func_193578_a(iBlockReader2, n, n2, n3, \u26033);
        return \u26033;
    }
}

