/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SweetBerryBushBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty field_220125_a = BlockStateProperties.field_208168_U;
    private static final VoxelShape field_220126_b = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private static final VoxelShape field_220127_c = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public SweetBerryBushBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_220125_a, 0));
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (blockState.func_177229_b(field_220125_a) == 0) {
            return field_220126_b;
        }
        if (blockState.func_177229_b(field_220125_a) < 3) {
            return field_220127_c;
        }
        return super.func_220053_a(blockState, iBlockReader, blockPos, iSelectionContext);
    }

    @Override
    public void func_196267_b(BlockState blockState, World world, BlockPos blockPos, Random random) {
        super.func_196267_b(blockState, world, blockPos, random);
        int n = blockState.func_177229_b(field_220125_a);
        if (n < 3 && random.nextInt(5) == 0 && world.func_201669_a(blockPos.func_177984_a(), 0) >= 9) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_220125_a, n + 1), 2);
        }
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.func_200600_R() == EntityType.field_220356_B) {
            return;
        }
        entity.func_213295_a(blockState, new Vec3d(0.8f, 0.75, 0.8f));
        if (!(world.field_72995_K || blockState.func_177229_b(field_220125_a) <= 0 || entity.field_70142_S == entity.field_70165_t && entity.field_70136_U == entity.field_70161_v)) {
            double d = Math.abs(entity.field_70165_t - entity.field_70142_S);
            \u2603 = Math.abs(entity.field_70161_v - entity.field_70136_U);
            if (d >= (double)0.003f || \u2603 >= (double)0.003f) {
                entity.func_70097_a(DamageSource.field_220302_v, 1.0f);
            }
        }
    }

    @Override
    public boolean func_220051_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        int n = blockState.func_177229_b(field_220125_a);
        boolean bl = \u2603 = n == 3;
        if (!\u2603 && playerEntity.func_184586_b(hand).func_77973_b() == Items.field_196106_bc) {
            return false;
        }
        if (n > 1) {
            \u2603 = 1 + world.field_73012_v.nextInt(2);
            SweetBerryBushBlock.func_180635_a(world, blockPos, new ItemStack(Items.field_222112_pR, \u2603 + (\u2603 ? 1 : 0)));
            world.func_184133_a(null, blockPos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_220125_a, 1), 2);
            return true;
        }
        return super.func_220051_a(blockState, world, blockPos, playerEntity, hand, blockRayTraceResult);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_220125_a);
    }

    @Override
    public boolean func_176473_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return blockState.func_177229_b(field_220125_a) < 3;
    }

    @Override
    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    @Override
    public void func_176474_b(World world, Random random, BlockPos blockPos, BlockState blockState) {
        int n = Math.min(3, blockState.func_177229_b(field_220125_a) + 1);
        world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_220125_a, n), 2);
    }
}

