/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ChestBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty field_176459_a = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ChestType> field_196314_b = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty field_204511_c = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196316_c = Block.func_208617_a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196317_y = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape field_196318_z = Block.func_208617_a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196313_A = Block.func_208617_a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape field_196315_B = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final InventoryFactory<IInventory> field_220109_i = new InventoryFactory<IInventory>(){

        @Override
        public IInventory func_212855_b_(ChestTileEntity chestTileEntity, ChestTileEntity chestTileEntity2) {
            return new DoubleSidedInventory(chestTileEntity, chestTileEntity2);
        }

        @Override
        public IInventory func_212856_b_(ChestTileEntity chestTileEntity) {
            return chestTileEntity;
        }

        @Override
        public /* synthetic */ Object func_212856_b_(ChestTileEntity chestTileEntity) {
            return this.func_212856_b_(chestTileEntity);
        }

        @Override
        public /* synthetic */ Object func_212855_b_(ChestTileEntity chestTileEntity, ChestTileEntity chestTileEntity2) {
            return this.func_212855_b_(chestTileEntity, chestTileEntity2);
        }
    };
    private static final InventoryFactory<INamedContainerProvider> field_220110_j = new InventoryFactory<INamedContainerProvider>(){

        @Override
        public INamedContainerProvider func_212855_b_(final ChestTileEntity chestTileEntity, final ChestTileEntity chestTileEntity2) {
            final DoubleSidedInventory doubleSidedInventory = new DoubleSidedInventory(chestTileEntity, chestTileEntity2);
            return new INamedContainerProvider(){

                @Override
                @Nullable
                public Container createMenu(int n, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    if (chestTileEntity.func_213904_e(playerEntity) && chestTileEntity2.func_213904_e(playerEntity)) {
                        chestTileEntity.func_184281_d(playerInventory.field_70458_d);
                        chestTileEntity2.func_184281_d(playerInventory.field_70458_d);
                        return ChestContainer.func_216984_b(n, playerInventory, doubleSidedInventory);
                    }
                    return null;
                }

                @Override
                public ITextComponent func_145748_c_() {
                    if (chestTileEntity.func_145818_k_()) {
                        return chestTileEntity.func_145748_c_();
                    }
                    if (chestTileEntity2.func_145818_k_()) {
                        return chestTileEntity2.func_145748_c_();
                    }
                    return new TranslationTextComponent("container.chestDouble", new Object[0]);
                }
            };
        }

        @Override
        public INamedContainerProvider func_212856_b_(ChestTileEntity chestTileEntity) {
            return chestTileEntity;
        }

        @Override
        public /* synthetic */ Object func_212856_b_(ChestTileEntity chestTileEntity) {
            return this.func_212856_b_(chestTileEntity);
        }

        @Override
        public /* synthetic */ Object func_212855_b_(ChestTileEntity chestTileEntity, ChestTileEntity chestTileEntity2) {
            return this.func_212855_b_(chestTileEntity, chestTileEntity2);
        }
    };

    protected ChestBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176459_a, Direction.NORTH)).func_206870_a(field_196314_b, ChestType.SINGLE)).func_206870_a(field_204511_c, false));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState3, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        BlockState blockState3;
        if (blockState3.func_177229_b(field_204511_c).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (blockState2.func_177230_c() == this && direction.func_176740_k().func_176722_c()) {
            ChestType chestType = blockState2.func_177229_b(field_196314_b);
            if (blockState3.func_177229_b(field_196314_b) == ChestType.SINGLE && chestType != ChestType.SINGLE && blockState3.func_177229_b(field_176459_a) == blockState2.func_177229_b(field_176459_a) && ChestBlock.func_196311_i(blockState2) == direction.func_176734_d()) {
                return (BlockState)blockState3.func_206870_a(field_196314_b, chestType.func_208081_a());
            }
        } else if (ChestBlock.func_196311_i(blockState3) == direction) {
            return (BlockState)blockState3.func_206870_a(field_196314_b, ChestType.SINGLE);
        }
        return super.func_196271_a(blockState3, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (blockState.func_177229_b(field_196314_b) == ChestType.SINGLE) {
            return field_196315_B;
        }
        switch (ChestBlock.func_196311_i(blockState)) {
            default: {
                return field_196316_c;
            }
            case SOUTH: {
                return field_196317_y;
            }
            case WEST: {
                return field_196318_z;
            }
            case EAST: 
        }
        return field_196313_A;
    }

    public static Direction func_196311_i(BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_176459_a);
        return blockState.func_177229_b(field_196314_b) == ChestType.LEFT ? direction.func_176746_e() : direction.func_176735_f();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        ChestType chestType = ChestType.SINGLE;
        Direction \u26032 = blockItemUseContext.func_195992_f().func_176734_d();
        IFluidState \u26033 = blockItemUseContext.func_195991_k().func_204610_c(blockItemUseContext.func_195995_a());
        boolean \u26034 = blockItemUseContext.func_195998_g();
        Direction \u26035 = blockItemUseContext.func_196000_l();
        if (\u26035.func_176740_k().func_176722_c() && \u26034 && (\u2603 = this.func_196312_a(blockItemUseContext, \u26035.func_176734_d())) != null && \u2603.func_176740_k() != \u26035.func_176740_k()) {
            \u26032 = \u2603;
            ChestType chestType2 = chestType = \u26032.func_176735_f() == \u26035.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chestType == ChestType.SINGLE && !\u26034) {
            if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176746_e())) {
                chestType = ChestType.LEFT;
            } else if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176735_f())) {
                chestType = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176459_a, \u26032)).func_206870_a(field_196314_b, chestType)).func_206870_a(field_204511_c, \u26033.func_206886_c() == Fluids.field_204546_a);
    }

    @Override
    public IFluidState func_204507_t(BlockState blockState) {
        if (blockState.func_177229_b(field_204511_c).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(blockState);
    }

    @Nullable
    private Direction func_196312_a(BlockItemUseContext blockItemUseContext, Direction direction) {
        BlockState blockState = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a().func_177972_a(direction));
        return blockState.func_177230_c() == this && blockState.func_177229_b(field_196314_b) == ChestType.SINGLE ? blockState.func_177229_b(field_176459_a) : null;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof ChestTileEntity) {
            ((ChestTileEntity)\u2603).func_213903_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_177230_c() == blockState2.func_177230_c()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a(world, blockPos, (IInventory)((Object)tileEntity));
            world.func_175666_e(blockPos, this);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public boolean func_220051_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return true;
        }
        INamedContainerProvider iNamedContainerProvider = this.func_220052_b(blockState, world, blockPos);
        if (iNamedContainerProvider != null) {
            playerEntity.func_213829_a(iNamedContainerProvider);
            playerEntity.func_71029_a(this.func_196310_d());
        }
        return true;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return Stats.field_199092_j.func_199076_b(Stats.field_188063_ac);
    }

    @Nullable
    public static <T> T func_220106_a(BlockState blockState, IWorld iWorld, BlockPos blockPos, boolean bl, InventoryFactory<T> inventoryFactory2) {
        InventoryFactory<T> inventoryFactory2;
        TileEntity tileEntity = iWorld.func_175625_s(blockPos);
        if (!(tileEntity instanceof ChestTileEntity)) {
            return null;
        }
        if (!bl && ChestBlock.func_220108_a(iWorld, blockPos)) {
            return null;
        }
        ChestTileEntity \u26032 = (ChestTileEntity)tileEntity;
        ChestType \u26033 = blockState.func_177229_b(field_196314_b);
        if (\u26033 == ChestType.SINGLE) {
            return inventoryFactory2.func_212856_b_(\u26032);
        }
        BlockPos \u26034 = blockPos.func_177972_a(ChestBlock.func_196311_i(blockState));
        BlockState \u26035 = iWorld.func_180495_p(\u26034);
        if (\u26035.func_177230_c() == blockState.func_177230_c() && (\u2603 = \u26035.func_177229_b(field_196314_b)) != ChestType.SINGLE && \u26033 != \u2603 && \u26035.func_177229_b(field_176459_a) == blockState.func_177229_b(field_176459_a)) {
            if (!bl && ChestBlock.func_220108_a(iWorld, \u26034)) {
                return null;
            }
            \u2603 = iWorld.func_175625_s(\u26034);
            if (\u2603 instanceof ChestTileEntity) {
                ChestTileEntity chestTileEntity = \u26033 == ChestType.RIGHT ? \u26032 : (ChestTileEntity)\u2603;
                \u2603 = \u26033 == ChestType.RIGHT ? (ChestTileEntity)\u2603 : \u26032;
                return inventoryFactory2.func_212855_b_(chestTileEntity, \u2603);
            }
        }
        return inventoryFactory2.func_212856_b_(\u26032);
    }

    @Nullable
    public static IInventory func_220105_a(BlockState blockState, World world, BlockPos blockPos, boolean bl) {
        return ChestBlock.func_220106_a(blockState, world, blockPos, bl, field_220109_i);
    }

    @Override
    @Nullable
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        return ChestBlock.func_220106_a(blockState, world, blockPos, false, field_220110_j);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new ChestTileEntity();
    }

    private static boolean func_220108_a(IWorld iWorld, BlockPos blockPos) {
        return ChestBlock.func_176456_n(iWorld, blockPos) || ChestBlock.func_220107_b(iWorld, blockPos);
    }

    private static boolean func_176456_n(IBlockReader iBlockReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177984_a();
        return iBlockReader.func_180495_p(\u2603).func_215686_e(iBlockReader, \u2603);
    }

    private static boolean func_220107_b(IWorld iWorld, BlockPos blockPos) {
        List<CatEntity> list = iWorld.func_217357_a(CatEntity.class, new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 2, blockPos.func_177952_p() + 1));
        if (!list.isEmpty()) {
            for (CatEntity catEntity : list) {
                if (!catEntity.func_70906_o()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return Container.func_94526_b(ChestBlock.func_220105_a(blockState, world, blockPos, false));
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176459_a, rotation.func_185831_a(blockState.func_177229_b(field_176459_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_176459_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176459_a, field_196314_b, field_204511_c);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }

    static interface InventoryFactory<T> {
        public T func_212855_b_(ChestTileEntity var1, ChestTileEntity var2);

        public T func_212856_b_(ChestTileEntity var1);
    }
}

