/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public class ChangeDimensionTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation field_193144_a = new ResourceLocation("changed_dimension");
    private final Map<PlayerAdvancements, Listeners> field_193145_b = Maps.newHashMap();

    @Override
    public ResourceLocation func_192163_a() {
        return field_193144_a;
    }

    @Override
    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193145_b.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.field_193145_b.put(playerAdvancements, listeners);
        }
        listeners.func_193233_a(listener);
    }

    @Override
    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193145_b.get(playerAdvancements);
        if (listeners != null) {
            listeners.func_193231_b(listener);
            if (listeners.func_193232_a()) {
                this.field_193145_b.remove(playerAdvancements);
            }
        }
    }

    @Override
    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.field_193145_b.remove(playerAdvancements);
    }

    @Override
    public Instance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        DimensionType dimensionType = jsonObject.has("from") ? DimensionType.func_193417_a(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "from"))) : null;
        \u2603 = jsonObject.has("to") ? DimensionType.func_193417_a(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "to"))) : null;
        return new Instance(dimensionType, \u2603);
    }

    public void func_193143_a(ServerPlayerEntity serverPlayerEntity, DimensionType dimensionType, DimensionType dimensionType2) {
        Listeners listeners = this.field_193145_b.get(serverPlayerEntity.func_192039_O());
        if (listeners != null) {
            listeners.func_193234_a(dimensionType, dimensionType2);
        }
    }

    @Override
    public /* synthetic */ ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        return this.func_192166_a(jsonObject, jsonDeserializationContext);
    }

    static class Listeners {
        private final PlayerAdvancements field_193235_a;
        private final Set<ICriterionTrigger.Listener<Instance>> field_193236_b = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.field_193235_a = playerAdvancements;
        }

        public boolean func_193232_a() {
            return this.field_193236_b.isEmpty();
        }

        public void func_193233_a(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193236_b.add(listener);
        }

        public void func_193231_b(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193236_b.remove(listener);
        }

        public void func_193234_a(DimensionType dimensionType, DimensionType dimensionType2) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.field_193236_b) {
                if (!listener.func_192158_a().func_193190_a(dimensionType, dimensionType2)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener : list) {
                    listener.func_192159_a(this.field_193235_a);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        @Nullable
        private final DimensionType field_193191_a;
        @Nullable
        private final DimensionType field_193192_b;

        public Instance(@Nullable DimensionType dimensionType, @Nullable DimensionType dimensionType2) {
            super(field_193144_a);
            this.field_193191_a = dimensionType;
            this.field_193192_b = dimensionType2;
        }

        public static Instance func_203911_a(DimensionType dimensionType) {
            return new Instance(null, dimensionType);
        }

        public boolean func_193190_a(DimensionType dimensionType, DimensionType dimensionType2) {
            if (this.field_193191_a != null && this.field_193191_a != dimensionType) {
                return false;
            }
            return this.field_193192_b == null || this.field_193192_b == dimensionType2;
        }

        @Override
        public JsonElement func_200288_b() {
            JsonObject jsonObject = new JsonObject();
            if (this.field_193191_a != null) {
                jsonObject.addProperty("from", DimensionType.func_212678_a(this.field_193191_a).toString());
            }
            if (this.field_193192_b != null) {
                jsonObject.addProperty("to", DimensionType.func_212678_a(this.field_193192_b).toString());
            }
            return jsonObject;
        }
    }
}

