/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class LanguageProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> data = new TreeMap<String, String>();
    private final DataGenerator gen;
    private final String modid;
    private final String locale;

    public LanguageProvider(DataGenerator gen, String modid, String locale) {
        this.gen = gen;
        this.modid = modid;
        this.locale = locale;
    }

    protected abstract void addTranslations();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addTranslations();
        if (!this.data.isEmpty()) {
            this.save(cache, this.data, this.gen.func_200391_b().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String func_200397_b() {
        return "Languages: " + this.locale;
    }

    private void save(DirectoryCache cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    protected void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.func_149739_a(), name);
    }

    protected void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.func_77658_a(), name);
    }

    protected void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.func_77977_a(), name);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.func_77320_a(), name);
    }

    protected void addBiome(Supplier<? extends Biome> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Biome key, String name) {
        this.add(key.func_210773_k(), name);
    }

    protected void addEffect(Supplier<? extends Effect> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Effect key, String name) {
        this.add(key.func_76393_a(), name);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.func_210760_d(), name);
    }

    protected void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

