/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeConfig;

public class ForgeBlockModelRenderer
extends BlockModelRenderer {
    private final ThreadLocal<VertexLighterFlat> lighterFlat;
    private final ThreadLocal<VertexLighterSmoothAo> lighterSmooth;
    private final ThreadLocal<VertexBufferConsumer> consumerFlat = ThreadLocal.withInitial(VertexBufferConsumer::new);
    private final ThreadLocal<VertexBufferConsumer> consumerSmooth = ThreadLocal.withInitial(VertexBufferConsumer::new);

    public ForgeBlockModelRenderer(BlockColors colors) {
        super(colors);
        this.lighterFlat = ThreadLocal.withInitial(() -> new VertexLighterFlat(colors));
        this.lighterSmooth = ThreadLocal.withInitial(() -> new VertexLighterSmoothAo(colors));
    }

    public boolean renderModelFlat(IEnviromentBlockReader world, IBakedModel model, BlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random rand, long seed, IModelData modelData) {
        if (((Boolean)ForgeConfig.CLIENT.forgeLightPipelineEnabled.get()).booleanValue()) {
            VertexBufferConsumer consumer = this.consumerFlat.get();
            consumer.setBuffer(buffer);
            consumer.setOffset(pos);
            VertexLighterFlat lighter = this.lighterFlat.get();
            lighter.setParent(consumer);
            return ForgeBlockModelRenderer.render(lighter, world, model, state, pos, buffer, checkSides, rand, seed, modelData);
        }
        return super.renderModelFlat(world, model, state, pos, buffer, checkSides, rand, seed, modelData);
    }

    public boolean renderModelSmooth(IEnviromentBlockReader world, IBakedModel model, BlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random rand, long seed, IModelData modelData) {
        if (((Boolean)ForgeConfig.CLIENT.forgeLightPipelineEnabled.get()).booleanValue()) {
            VertexBufferConsumer consumer = this.consumerSmooth.get();
            consumer.setBuffer(buffer);
            consumer.setOffset(pos);
            VertexLighterSmoothAo lighter = this.lighterSmooth.get();
            lighter.setParent(consumer);
            return ForgeBlockModelRenderer.render(lighter, world, model, state, pos, buffer, checkSides, rand, seed, modelData);
        }
        return super.renderModelSmooth(world, model, state, pos, buffer, checkSides, rand, seed, modelData);
    }

    public static boolean render(VertexLighterFlat lighter, IEnviromentBlockReader world, IBakedModel model, BlockState state, BlockPos pos, BufferBuilder wr, boolean checkSides, Random rand, long seed, IModelData modelData) {
        lighter.setWorld(world);
        lighter.setState(state);
        lighter.setBlockPos(pos);
        boolean empty = true;
        rand.setSeed(seed);
        List quads = model.getQuads(state, null, rand, modelData);
        if (!quads.isEmpty()) {
            lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        for (Direction side : Direction.values()) {
            rand.setSeed(seed);
            quads = model.getQuads(state, side, rand, modelData);
            if (quads.isEmpty() || checkSides && !Block.func_176225_a((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)side)) continue;
            if (empty) {
                lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        lighter.resetBlockInfo();
        return !empty;
    }
}

