/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class ModelProvider<T extends ModelBuilder<T>>
implements IDataProvider {
    public static final String BLOCK_FOLDER = "block";
    public static final String ITEM_FOLDER = "item";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final String modid;
    protected final String folder;
    protected final Function<ResourceLocation, T> factory;
    @VisibleForTesting
    protected final Map<ResourceLocation, T> generatedModels = new HashMap<ResourceLocation, T>();
    protected final ExistingFileHelper existingFileHelper;
    protected DirectoryCache cache;

    protected abstract void registerModels();

    public ModelProvider(DataGenerator generator, String modid, String folder, Function<ResourceLocation, T> factory, ExistingFileHelper existingFileHelper) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        Preconditions.checkNotNull((Object)modid);
        this.modid = modid;
        Preconditions.checkNotNull((Object)folder);
        this.folder = folder;
        Preconditions.checkNotNull(factory);
        this.factory = factory;
        Preconditions.checkNotNull((Object)existingFileHelper);
        this.existingFileHelper = new ExistingFileHelperIncludingGenerated(existingFileHelper);
    }

    public ModelProvider(DataGenerator generator, String modid, String folder, BiFunction<ResourceLocation, ExistingFileHelper, T> builderFromModId, ExistingFileHelper existingFileHelper) {
        this(generator, modid, folder, (ResourceLocation loc) -> (ModelBuilder)builderFromModId.apply((ResourceLocation)loc, existingFileHelper), existingFileHelper);
    }

    protected T getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path));
        return (T)((ModelBuilder)this.generatedModels.computeIfAbsent(outputLoc, this.factory));
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.func_110623_a().contains("/")) {
            return rl;
        }
        return new ResourceLocation(rl.func_110624_b(), this.folder + "/" + rl.func_110623_a());
    }

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    protected ResourceLocation mcLoc(String name) {
        return new ResourceLocation(name);
    }

    protected T withExistingParent(String name, String parent) {
        return this.withExistingParent(name, this.mcLoc(parent));
    }

    protected T withExistingParent(String name, ResourceLocation parent) {
        return ((ModelBuilder)this.getBuilder(name)).parent(this.getExistingFile(parent));
    }

    protected T cube(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "cube")).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west);
    }

    private T singleTexture(String name, String parent, ResourceLocation texture) {
        return this.singleTexture(name, this.mcLoc(parent), texture);
    }

    protected T singleTexture(String name, ResourceLocation parent, ResourceLocation texture) {
        return this.singleTexture(name, parent, "texture", texture);
    }

    private T singleTexture(String name, String parent, String textureKey, ResourceLocation texture) {
        return this.singleTexture(name, this.mcLoc(parent), textureKey, texture);
    }

    protected T singleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture) {
        return ((ModelBuilder)this.withExistingParent(name, parent)).texture(textureKey, texture);
    }

    protected T cubeAll(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/cube_all", "all", texture);
    }

    protected T cubeTop(String name, ResourceLocation side, ResourceLocation top) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/cube_top")).texture("side", side)).texture("top", top);
    }

    private T sideBottomTop(String name, String parent, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, parent)).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    protected T cubeBottomTop(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/cube_bottom_top", side, bottom, top);
    }

    protected T cubeColumn(String name, ResourceLocation side, ResourceLocation end) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/cube_column")).texture("side", side)).texture("end", end);
    }

    protected T orientableVertical(String name, ResourceLocation side, ResourceLocation front) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable_vertical")).texture("side", side)).texture("front", front);
    }

    protected T orientableWithBottom(String name, ResourceLocation side, ResourceLocation front, ResourceLocation bottom, ResourceLocation top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable_with_bottom")).texture("side", side)).texture("front", front)).texture("bottom", bottom)).texture("top", top);
    }

    protected T orientable(String name, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        return ((ModelBuilder)((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/orientable")).texture("side", side)).texture("front", front)).texture("top", top);
    }

    protected T crop(String name, ResourceLocation crop) {
        return this.singleTexture(name, "block/crop", "crop", crop);
    }

    protected T cross(String name, ResourceLocation cross) {
        return this.singleTexture(name, "block/cross", "cross", cross);
    }

    protected T stairs(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/stairs", side, bottom, top);
    }

    protected T stairsOuter(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/outer_stairs", side, bottom, top);
    }

    protected T stairsInner(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/inner_stairs", side, bottom, top);
    }

    protected T slab(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/slab", side, bottom, top);
    }

    protected T slabTop(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.sideBottomTop(name, "block/slab_top", side, bottom, top);
    }

    protected T fencePost(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/fence_post", texture);
    }

    protected T fenceSide(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/fence_side", texture);
    }

    protected T fenceInventory(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/fence_inventory", texture);
    }

    protected T fenceGate(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_fence_gate", texture);
    }

    protected T fenceGateOpen(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_fence_gate_open", texture);
    }

    protected T fenceGateWall(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_fence_gate_wall", texture);
    }

    protected T fenceGateWallOpen(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_fence_gate_wall_open", texture);
    }

    protected T wallPost(String name, ResourceLocation wall) {
        return this.singleTexture(name, "block/template_wall_post", "wall", wall);
    }

    protected T wallSide(String name, ResourceLocation wall) {
        return this.singleTexture(name, "block/template_wall_side", "wall", wall);
    }

    protected T wallInventory(String name, ResourceLocation wall) {
        return this.singleTexture(name, "block/wall_inventory", "wall", wall);
    }

    private T pane(String name, String parent, ResourceLocation pane, ResourceLocation edge) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/" + parent)).texture("pane", pane)).texture("edge", edge);
    }

    protected T panePost(String name, ResourceLocation pane, ResourceLocation edge) {
        return this.pane(name, "template_glass_pane_post", pane, edge);
    }

    protected T paneSide(String name, ResourceLocation pane, ResourceLocation edge) {
        return this.pane(name, "template_glass_pane_side", pane, edge);
    }

    protected T paneSideAlt(String name, ResourceLocation pane, ResourceLocation edge) {
        return this.pane(name, "template_glass_pane_side_alt", pane, edge);
    }

    protected T paneNoSide(String name, ResourceLocation pane) {
        return this.singleTexture(name, "block/template_glass_pane_noside", "pane", pane);
    }

    protected T paneNoSideAlt(String name, ResourceLocation pane) {
        return this.singleTexture(name, "block/template_glass_pane_noside_alt", "pane", pane);
    }

    private T door(String name, String model, ResourceLocation bottom, ResourceLocation top) {
        return ((ModelBuilder)((ModelBuilder)this.withExistingParent(name, "block/" + model)).texture("bottom", bottom)).texture("top", top);
    }

    protected T doorBottomLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom", bottom, top);
    }

    protected T doorBottomRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom_rh", bottom, top);
    }

    protected T doorTopLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top", bottom, top);
    }

    protected T doorTopRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top_rh", bottom, top);
    }

    protected T trapdoorBottom(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_trapdoor_bottom", texture);
    }

    protected T trapdoorTop(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_trapdoor_top", texture);
    }

    protected T trapdoorOpen(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_trapdoor_open", texture);
    }

    protected T trapdoorOrientableBottom(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_bottom", texture);
    }

    protected T trapdoorOrientableTop(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_top", texture);
    }

    protected T trapdoorOrientableOpen(String name, ResourceLocation texture) {
        return this.singleTexture(name, "block/template_orientable_trapdoor_open", texture);
    }

    protected T torch(String name, ResourceLocation torch) {
        return this.singleTexture(name, "block/template_torch", "torch", torch);
    }

    protected T torchWall(String name, ResourceLocation torch) {
        return this.singleTexture(name, "block/torch_wall", "torch", torch);
    }

    protected T carpet(String name, ResourceLocation wool) {
        return this.singleTexture(name, "block/carpet", "wool", wool);
    }

    protected ModelFile.ExistingModelFile getExistingFile(ResourceLocation path) {
        ModelFile.ExistingModelFile ret = new ModelFile.ExistingModelFile(this.extendWithFolder(path), this.existingFileHelper);
        ret.assertExistence();
        return ret;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.cache = cache;
        this.generatedModels.clear();
        this.registerModels();
        this.generateAll();
        this.cache = null;
    }

    private void generateAll() {
        for (ModelBuilder model : this.generatedModels.values()) {
            Path target = this.getPath(model);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)this.cache, (JsonElement)model.toJson(), (Path)target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Path getPath(T model) {
        ResourceLocation loc = ((ModelFile)model).getLocation();
        return this.generator.func_200391_b().resolve("assets/" + loc.func_110624_b() + "/models/" + loc.func_110623_a() + ".json");
    }

    private class ExistingFileHelperIncludingGenerated
    extends ExistingFileHelper {
        private final ExistingFileHelper delegate;

        public ExistingFileHelperIncludingGenerated(ExistingFileHelper delegate) {
            super(Collections.emptyList(), true);
            this.delegate = delegate;
        }

        @Override
        public boolean exists(ResourceLocation loc, ResourcePackType type, String pathSuffix, String pathPrefix) {
            if (ModelProvider.this.generatedModels.containsKey(loc)) {
                return true;
            }
            return this.delegate.exists(loc, type, pathSuffix, pathPrefix);
        }
    }
}

