/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DeferredRegister<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> type;
    private final String modid;
    private List<Supplier<? extends T>> entries = new ArrayList<Supplier<? extends T>>();

    public DeferredRegister(IForgeRegistry<T> reg, String modid) {
        this.type = reg;
        this.modid = modid;
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<I> sup) {
        ResourceLocation key = new ResourceLocation(this.modid, name);
        this.entries.add(() -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(key));
        return RegistryObject.of(key.toString(), this.type);
    }

    public void register(IEventBus bus) {
        bus.addListener(this::addEntries);
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        if (event.getGenericType() == this.type.getRegistrySuperType()) {
            IForgeRegistry<?> reg = event.getRegistry();
            this.entries.stream().map(Supplier::get).forEach(reg::register);
        }
    }
}

