/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.ILootGenerator;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomRanges;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    private final String name;
    private final List<LootEntry> field_186453_a;
    private final List<ILootCondition> field_186454_b;
    private final Predicate<LootContext> field_216101_c;
    private final ILootFunction[] field_216102_d;
    private final BiFunction<ItemStack, LootContext, ItemStack> field_216103_e;
    private IRandomRange field_186455_c;
    private RandomValueRange field_186456_d;
    private boolean isFrozen = false;

    private LootPool(LootEntry[] p_i51268_1_, ILootCondition[] p_i51268_2_, ILootFunction[] p_i51268_3_, IRandomRange p_i51268_4_, RandomValueRange p_i51268_5_, String name) {
        this.name = name;
        this.field_186453_a = Lists.newArrayList((Object[])p_i51268_1_);
        this.field_186454_b = Lists.newArrayList((Object[])p_i51268_2_);
        this.field_216101_c = LootConditionManager.func_216305_a((Predicate[])p_i51268_2_);
        this.field_216102_d = p_i51268_3_;
        this.field_216103_e = LootFunctionManager.func_216241_a((BiFunction[])p_i51268_3_);
        this.field_186455_c = p_i51268_4_;
        this.field_186456_d = p_i51268_5_;
    }

    private void func_216095_b(Consumer<ItemStack> p_216095_1_, LootContext p_216095_2_) {
        Random random = p_216095_2_.func_216032_b();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        for (LootEntry lootentry : this.field_186453_a) {
            lootentry.expand(p_216095_2_, p_216097_3_ -> {
                int k = p_216097_3_.func_186361_a(p_216095_2_.func_186491_f());
                if (k > 0) {
                    list.add(p_216097_3_);
                    mutableint.add(k);
                }
            });
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((ILootGenerator)list.get(0)).func_216188_a(p_216095_1_, p_216095_2_);
            } else {
                int j = random.nextInt(mutableint.intValue());
                for (ILootGenerator ilootgenerator : list) {
                    if ((j -= ilootgenerator.func_186361_a(p_216095_2_.func_186491_f())) >= 0) continue;
                    ilootgenerator.func_216188_a(p_216095_1_, p_216095_2_);
                    return;
                }
            }
        }
    }

    public void func_216091_a(Consumer<ItemStack> p_216091_1_, LootContext p_216091_2_) {
        if (this.field_216101_c.test(p_216091_2_)) {
            Consumer consumer = ILootFunction.func_215858_a(this.field_216103_e, p_216091_1_, (LootContext)p_216091_2_);
            Random random = p_216091_2_.func_216032_b();
            int i = this.field_186455_c.func_186511_a(random) + MathHelper.func_76141_d((float)(this.field_186456_d.func_186507_b(random) * p_216091_2_.func_186491_f()));
            for (int j = 0; j < i; ++j) {
                this.func_216095_b(consumer, p_216091_2_);
            }
        }
    }

    public void func_216099_a(ValidationResults p_216099_1_, Function<ResourceLocation, LootTable> p_216099_2_, Set<ResourceLocation> p_216099_3_, LootParameterSet p_216099_4_) {
        for (int i = 0; i < this.field_186454_b.size(); ++i) {
            this.field_186454_b.get(i).func_215856_a(p_216099_1_.func_216108_b(".condition[" + i + "]"), p_216099_2_, p_216099_3_, p_216099_4_);
        }
        for (int j = 0; j < this.field_216102_d.length; ++j) {
            this.field_216102_d[j].func_215856_a(p_216099_1_.func_216108_b(".functions[" + j + "]"), p_216099_2_, p_216099_3_, p_216099_4_);
        }
        for (int k = 0; k < this.field_186453_a.size(); ++k) {
            this.field_186453_a.get(k).func_216142_a(p_216099_1_.func_216108_b(".entries[" + k + "]"), p_216099_2_, p_216099_3_, p_216099_4_);
        }
    }

    public static Builder func_216096_a() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    public String getName() {
        return this.name;
    }

    public IRandomRange getRolls() {
        return this.field_186455_c;
    }

    public IRandomRange getBonusRolls() {
        return this.field_186456_d;
    }

    public void setRolls(RandomValueRange v) {
        this.checkFrozen();
        this.field_186455_c = v;
    }

    public void setBonusRolls(RandomValueRange v) {
        this.checkFrozen();
        this.field_186456_d = v;
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot pool");
            LootEntry[] alootentry = (LootEntry[])JSONUtils.func_188174_a((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)p_deserialize_3_, LootEntry[].class);
            ILootCondition[] ailootcondition = (ILootCondition[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"conditions", (Object)new ILootCondition[0], (JsonDeserializationContext)p_deserialize_3_, ILootCondition[].class);
            ILootFunction[] ailootfunction = (ILootFunction[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"functions", (Object)new ILootFunction[0], (JsonDeserializationContext)p_deserialize_3_, ILootFunction[].class);
            IRandomRange irandomrange = RandomRanges.func_216130_a((JsonElement)jsonobject.get("rolls"), (JsonDeserializationContext)p_deserialize_3_);
            RandomValueRange randomvaluerange = (RandomValueRange)JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"bonus_rolls", (Object)new RandomValueRange(0.0f, 0.0f), (JsonDeserializationContext)p_deserialize_3_, RandomValueRange.class);
            return new LootPool(alootentry, ailootcondition, ailootfunction, irandomrange, randomvaluerange, ForgeHooks.readPoolName((JsonObject)jsonobject));
        }

        public JsonElement serialize(LootPool p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.name != null && !p_serialize_1_.name.startsWith("custom#")) {
                jsonobject.add("name", p_serialize_3_.serialize((Object)p_serialize_1_.name));
            }
            jsonobject.add("rolls", RandomRanges.func_216131_a((IRandomRange)p_serialize_1_.field_186455_c, (JsonSerializationContext)p_serialize_3_));
            jsonobject.add("entries", p_serialize_3_.serialize((Object)p_serialize_1_.field_186453_a));
            if (p_serialize_1_.field_186456_d.func_186509_a() != 0.0f && p_serialize_1_.field_186456_d.func_186512_b() != 0.0f) {
                jsonobject.add("bonus_rolls", p_serialize_3_.serialize((Object)p_serialize_1_.field_186456_d));
            }
            if (!p_serialize_1_.field_186454_b.isEmpty()) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.field_186454_b));
            }
            if (!ArrayUtils.isEmpty((Object[])p_serialize_1_.field_216102_d)) {
                jsonobject.add("functions", p_serialize_3_.serialize((Object)p_serialize_1_.field_216102_d));
            }
            return jsonobject;
        }
    }

    public static class Builder
    implements ILootFunctionConsumer<Builder>,
    ILootConditionConsumer<Builder> {
        private final List<LootEntry> field_216047_a = Lists.newArrayList();
        private final List<ILootCondition> field_216048_b = Lists.newArrayList();
        private final List<ILootFunction> field_216049_c = Lists.newArrayList();
        private IRandomRange field_216050_d = new RandomValueRange(1.0f);
        private RandomValueRange field_216051_e = new RandomValueRange(0.0f, 0.0f);
        private String name;

        public Builder func_216046_a(IRandomRange rollsIn) {
            this.field_216050_d = rollsIn;
            return this;
        }

        public Builder func_212862_c_() {
            return this;
        }

        public Builder func_216045_a(LootEntry.Builder<?> entriesBuilder) {
            this.field_216047_a.add(entriesBuilder.func_216081_b());
            return this;
        }

        public Builder func_212840_b_(ILootCondition.IBuilder conditionBuilder) {
            this.field_216048_b.add(conditionBuilder.build());
            return this;
        }

        public Builder func_212841_b_(ILootFunction.IBuilder functionBuilder) {
            this.field_216049_c.add(functionBuilder.func_216052_b());
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder bonusRolls(float min, float max) {
            this.field_216051_e = new RandomValueRange(min, max);
            return this;
        }

        public LootPool func_216044_b() {
            if (this.field_216050_d == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootPool(this.field_216047_a.toArray(new LootEntry[0]), this.field_216048_b.toArray(new ILootCondition[0]), this.field_216049_c.toArray(new ILootFunction[0]), this.field_216050_d, this.field_216051_e, this.name);
        }
    }
}

