/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldInfo;

public class ServerChunkProvider
extends AbstractChunkProvider {
    private static final int field_217238_b = (int)Math.pow(17.0, 2.0);
    private static final List<ChunkStatus> field_217239_c = ChunkStatus.func_222582_a();
    private final TicketManager field_217240_d;
    private final ChunkGenerator<?> field_186029_c;
    private final ServerWorld field_73251_h;
    private final Thread field_217241_g;
    private final ServerWorldLightManager field_217242_h;
    private final ChunkExecutor field_217243_i;
    public final ChunkManager field_217237_a;
    private final DimensionSavedDataManager field_217244_j;
    private long field_217245_k;
    private boolean field_217246_l = true;
    private boolean field_217247_m = true;
    private final long[] field_222875_n = new long[4];
    private final ChunkStatus[] field_222876_o = new ChunkStatus[4];
    private final IChunk[] field_222877_p = new IChunk[4];

    public ServerChunkProvider(ServerWorld serverWorld, File file, DataFixer dataFixer, TemplateManager templateManager, Executor executor, ChunkGenerator<?> chunkGenerator, int n, IChunkStatusListener iChunkStatusListener, Supplier<DimensionSavedDataManager> supplier) {
        this.field_73251_h = serverWorld;
        this.field_217243_i = new ChunkExecutor(serverWorld);
        this.field_186029_c = chunkGenerator;
        this.field_217241_g = Thread.currentThread();
        File file2 = serverWorld.func_201675_m().func_186058_p().func_212679_a(file);
        \u2603 = new File(file2, "data");
        \u2603.mkdirs();
        this.field_217244_j = new DimensionSavedDataManager(\u2603, dataFixer);
        this.field_217237_a = new ChunkManager(serverWorld, file, dataFixer, templateManager, executor, this.field_217243_i, this, this.func_201711_g(), iChunkStatusListener, supplier, n);
        this.field_217242_h = this.field_217237_a.func_219207_a();
        this.field_217240_d = this.field_217237_a.func_219246_e();
        this.func_222869_l();
    }

    @Override
    public ServerWorldLightManager func_212863_j_() {
        return this.field_217242_h;
    }

    @Nullable
    private ChunkHolder func_217213_a(long l) {
        return this.field_217237_a.func_219219_b(l);
    }

    public int func_217229_b() {
        return this.field_217237_a.func_219174_c();
    }

    private void func_225315_a(long l2, IChunk iChunk, ChunkStatus chunkStatus) {
        long l2;
        for (int i = 3; i > 0; --i) {
            this.field_222875_n[i] = this.field_222875_n[i - 1];
            this.field_222876_o[i] = this.field_222876_o[i - 1];
            this.field_222877_p[i] = this.field_222877_p[i - 1];
        }
        this.field_222875_n[0] = l2;
        this.field_222876_o[0] = chunkStatus;
        this.field_222877_p[0] = iChunk;
    }

    @Override
    @Nullable
    public IChunk func_212849_a_(int n3, int n2, ChunkStatus chunkStatus, boolean bl) {
        int n3;
        if (Thread.currentThread() != this.field_217241_g) {
            return CompletableFuture.supplyAsync(() -> this.func_212849_a_(n3, n2, chunkStatus, bl), this.field_217243_i).join();
        }
        long l = ChunkPos.func_77272_a(n3, n2);
        for (int i = 0; i < 4; ++i) {
            if (l != this.field_222875_n[i] || chunkStatus != this.field_222876_o[i] || (\u26033 = this.field_222877_p[i]) == null && bl) continue;
            return \u26033;
        }
        CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> \u26032 = this.func_217233_c(n3, n2, chunkStatus, bl);
        this.field_217243_i.func_213161_c(\u26032::isDone);
        IChunk \u26033 = (IChunk)\u26032.join().map(iChunk -> iChunk, iChunkLoadingError -> {
            if (bl) {
                throw new IllegalStateException("Chunk not there when requested: " + iChunkLoadingError);
            }
            return null;
        });
        this.func_225315_a(l, \u26033, chunkStatus);
        return \u26033;
    }

    @Override
    @Nullable
    public Chunk func_225313_a(int n, int n2) {
        if (Thread.currentThread() != this.field_217241_g) {
            return null;
        }
        long l = ChunkPos.func_77272_a(n, n2);
        for (int i = 0; i < 4; ++i) {
            if (l != this.field_222875_n[i] || this.field_222876_o[i] != ChunkStatus.field_222617_m) continue;
            IChunk iChunk = this.field_222877_p[i];
            return iChunk instanceof Chunk ? (Chunk)iChunk : null;
        }
        ChunkHolder \u26032 = this.func_217213_a(l);
        if (\u26032 == null) {
            return null;
        }
        Either \u26033 = \u26032.func_225410_b(ChunkStatus.field_222617_m).getNow(null);
        if (\u26033 == null) {
            return null;
        }
        IChunk \u26034 = \u26033.left().orElse(null);
        if (\u26034 != null) {
            this.func_225315_a(l, \u26034, ChunkStatus.field_222617_m);
            if (\u26034 instanceof Chunk) {
                return (Chunk)\u26034;
            }
        }
        return null;
    }

    private void func_222869_l() {
        Arrays.fill(this.field_222875_n, ChunkPos.field_222244_a);
        Arrays.fill(this.field_222876_o, null);
        Arrays.fill(this.field_222877_p, null);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_217233_c(int n, int n2, ChunkStatus chunkStatus2, boolean bl) {
        ChunkStatus chunkStatus2;
        ChunkPos chunkPos = new ChunkPos(n, n2);
        long \u26032 = chunkPos.func_201841_a();
        int \u26033 = 33 + ChunkStatus.func_222599_a(chunkStatus2);
        ChunkHolder \u26034 = this.func_217213_a(\u26032);
        if (bl) {
            this.field_217240_d.func_219356_a(TicketType.field_219494_g, chunkPos, \u26033, chunkPos);
            if (this.func_217224_a(\u26034, \u26033)) {
                IProfiler iProfiler = this.field_73251_h.func_217381_Z();
                iProfiler.func_76320_a("chunkLoad");
                this.func_217235_l();
                \u26034 = this.func_217213_a(\u26032);
                iProfiler.func_76319_b();
                if (this.func_217224_a(\u26034, \u26033)) {
                    throw new IllegalStateException("No chunk holder after ticket has been added");
                }
            }
        }
        if (this.func_217224_a(\u26034, \u26033)) {
            return ChunkHolder.field_219307_b;
        }
        return \u26034.func_219276_a(chunkStatus2, this.field_217237_a);
    }

    private boolean func_217224_a(@Nullable ChunkHolder chunkHolder, int n) {
        return chunkHolder == null || chunkHolder.func_219299_i() > n;
    }

    @Override
    public boolean func_73149_a(int n, int n2) {
        ChunkHolder chunkHolder = this.func_217213_a(new ChunkPos(n, n2).func_201841_a());
        return !this.func_217224_a(chunkHolder, \u2603 = 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222617_m));
    }

    @Override
    public IBlockReader func_217202_b(int n, int n2) {
        long l = ChunkPos.func_77272_a(n, n2);
        ChunkHolder \u26032 = this.func_217213_a(l);
        if (\u26032 == null) {
            return null;
        }
        int \u26033 = field_217239_c.size() - 1;
        while (true) {
            if ((\u2603 = \u26032.func_219301_a(\u2603 = field_217239_c.get(\u26033)).getNow(ChunkHolder.field_219306_a).left()).isPresent()) {
                return (IBlockReader)\u2603.get();
            }
            if (\u2603 == ChunkStatus.field_222614_j.func_222593_e()) break;
            --\u26033;
        }
        return null;
    }

    @Override
    public World func_212864_k_() {
        return this.field_73251_h;
    }

    public boolean func_217234_d() {
        return this.field_217243_i.func_213168_p();
    }

    private boolean func_217235_l() {
        boolean bl = this.field_217240_d.func_219353_a(this.field_217237_a);
        \u2603 = this.field_217237_a.func_219245_b();
        if (bl || \u2603) {
            this.func_222869_l();
            return true;
        }
        return false;
    }

    @Override
    public boolean func_217204_a(Entity entity) {
        long l = ChunkPos.func_77272_a(MathHelper.func_76128_c(entity.field_70165_t) >> 4, MathHelper.func_76128_c(entity.field_70161_v) >> 4);
        return this.func_222872_a(l, ChunkHolder::func_219297_b);
    }

    @Override
    public boolean func_222865_a(ChunkPos chunkPos) {
        return this.func_222872_a(chunkPos.func_201841_a(), ChunkHolder::func_219297_b);
    }

    @Override
    public boolean func_222866_a(BlockPos blockPos) {
        long l = ChunkPos.func_77272_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        return this.func_222872_a(l, ChunkHolder::func_219296_a);
    }

    public boolean func_223435_b(Entity entity) {
        long l = ChunkPos.func_77272_a(MathHelper.func_76128_c(entity.field_70165_t) >> 4, MathHelper.func_76128_c(entity.field_70161_v) >> 4);
        return this.func_222872_a(l, ChunkHolder::func_223492_c);
    }

    private boolean func_222872_a(long l, Function<ChunkHolder, CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>>> function) {
        ChunkHolder chunkHolder = this.func_217213_a(l);
        if (chunkHolder == null) {
            return false;
        }
        Either<Chunk, ChunkHolder.IChunkLoadingError> \u26032 = function.apply(chunkHolder).getNow(ChunkHolder.field_219308_c);
        return \u26032.left().isPresent();
    }

    public void func_217210_a(boolean bl) {
        this.func_217235_l();
        this.field_217237_a.func_219177_a(bl);
    }

    @Override
    public void close() throws IOException {
        this.func_217210_a(true);
        this.field_217242_h.close();
        this.field_217237_a.close();
    }

    public void func_217207_a(BooleanSupplier booleanSupplier) {
        this.field_73251_h.func_217381_Z().func_76320_a("purge");
        this.field_217240_d.func_219340_a();
        this.func_217235_l();
        this.field_73251_h.func_217381_Z().func_219895_b("chunks");
        this.func_217220_m();
        this.field_73251_h.func_217381_Z().func_219895_b("unload");
        this.field_217237_a.func_219204_a(booleanSupplier);
        this.field_73251_h.func_217381_Z().func_76319_b();
        this.func_222869_l();
    }

    private void func_217220_m() {
        long l = this.field_73251_h.func_82737_E();
        \u2603 = l - this.field_217245_k;
        this.field_217245_k = l;
        WorldInfo \u26032 = this.field_73251_h.func_72912_H();
        boolean \u26033 = \u26032.func_76067_t() == WorldType.field_180272_g;
        boolean \u26034 = this.field_73251_h.func_82736_K().func_223586_b(GameRules.field_223601_d);
        if (!\u26033) {
            this.field_73251_h.func_217381_Z().func_76320_a("pollingChunks");
            int n = this.field_73251_h.func_82736_K().func_223592_c(GameRules.field_223610_m);
            BlockPos \u26035 = this.field_73251_h.func_175694_M();
            boolean \u26036 = \u26032.func_82573_f() % 400L == 0L;
            this.field_73251_h.func_217381_Z().func_76320_a("naturalSpawnCount");
            \u2603 = this.field_217240_d.func_219358_b();
            EntityClassification[] \u26037 = EntityClassification.values();
            Object2IntMap<EntityClassification> \u26038 = this.field_73251_h.func_217450_l();
            this.field_73251_h.func_217381_Z().func_76319_b();
            this.field_217237_a.func_223491_f().forEach(chunkHolder -> {
                int n22;
                Optional optional = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (!optional.isPresent()) {
                    return;
                }
                Chunk \u26032 = (Chunk)optional.get();
                this.field_73251_h.func_217381_Z().func_76320_a("broadcast");
                chunkHolder.func_219274_a(\u26032);
                this.field_73251_h.func_217381_Z().func_76319_b();
                ChunkPos \u26033 = chunkHolder.func_219277_h();
                if (this.field_217237_a.func_219243_d(\u26033)) {
                    return;
                }
                \u26032.func_177415_c(\u26032.func_177416_w() + \u2603);
                if (\u26034 && (this.field_217246_l || this.field_217247_m) && this.field_73251_h.func_175723_af().func_177730_a(\u26032.func_76632_l())) {
                    this.field_73251_h.func_217381_Z().func_76320_a("spawner");
                    for (EntityClassification entityClassification : \u26037) {
                        if (entityClassification == EntityClassification.MISC || entityClassification.func_75599_d() && !this.field_217247_m || !entityClassification.func_75599_d() && !this.field_217246_l || entityClassification.func_82705_e() && !\u26036) continue;
                        int n3 = entityClassification.func_75601_b() * \u2603 / field_217238_b;
                        if (\u26038.getInt((Object)entityClassification) > n3) continue;
                        WorldEntitySpawner.func_222263_a(entityClassification, this.field_73251_h, \u26032, \u26035);
                    }
                    this.field_73251_h.func_217381_Z().func_76319_b();
                }
                this.field_73251_h.func_217441_a(\u26032, n);
            });
            this.field_73251_h.func_217381_Z().func_76320_a("customSpawners");
            if (\u26034) {
                this.field_186029_c.func_203222_a(this.field_73251_h, this.field_217246_l, this.field_217247_m);
            }
            this.field_73251_h.func_217381_Z().func_76319_b();
            this.field_73251_h.func_217381_Z().func_76319_b();
        }
        this.field_217237_a.func_219169_g();
    }

    @Override
    public String func_73148_d() {
        return "ServerChunkCache: " + this.func_73152_e();
    }

    @VisibleForTesting
    public int func_225314_f() {
        return this.field_217243_i.func_223704_be();
    }

    @Override
    public ChunkGenerator<?> func_201711_g() {
        return this.field_186029_c;
    }

    public int func_73152_e() {
        return this.field_217237_a.func_219194_d();
    }

    public void func_217217_a(BlockPos blockPos) {
        int n = blockPos.func_177958_n() >> 4;
        ChunkHolder \u26032 = this.func_217213_a(ChunkPos.func_77272_a(n, \u2603 = blockPos.func_177952_p() >> 4));
        if (\u26032 != null) {
            \u26032.func_219279_a(blockPos.func_177958_n() & 0xF, blockPos.func_177956_o(), blockPos.func_177952_p() & 0xF);
        }
    }

    @Override
    public void func_217201_a(LightType lightType, SectionPos sectionPos) {
        this.field_217243_i.execute(() -> {
            ChunkHolder chunkHolder = this.func_217213_a(sectionPos.func_218155_u().func_201841_a());
            if (chunkHolder != null) {
                chunkHolder.func_219280_a(lightType, sectionPos.func_218163_b());
            }
        });
    }

    public <T> void func_217228_a(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        this.field_217240_d.func_219331_c(ticketType, chunkPos, n, t);
    }

    public <T> void func_217222_b(TicketType<T> ticketType, ChunkPos chunkPos, int n, T t) {
        this.field_217240_d.func_219362_d(ticketType, chunkPos, n, t);
    }

    @Override
    public void func_217206_a(ChunkPos chunkPos, boolean bl) {
        this.field_217240_d.func_219364_a(chunkPos, bl);
    }

    public void func_217221_a(ServerPlayerEntity serverPlayerEntity) {
        this.field_217237_a.func_219183_a(serverPlayerEntity);
    }

    public void func_217226_b(Entity entity) {
        this.field_217237_a.func_219231_b(entity);
    }

    public void func_217230_c(Entity entity) {
        this.field_217237_a.func_219210_a(entity);
    }

    public void func_217216_a(Entity entity, IPacket<?> iPacket) {
        this.field_217237_a.func_219225_b(entity, iPacket);
    }

    public void func_217218_b(Entity entity, IPacket<?> iPacket) {
        this.field_217237_a.func_219222_a(entity, iPacket);
    }

    public void func_217219_a(int n) {
        this.field_217237_a.func_219175_a(n);
    }

    @Override
    public void func_217203_a(boolean bl, boolean bl2) {
        this.field_217246_l = bl;
        this.field_217247_m = bl2;
    }

    public DimensionSavedDataManager func_217227_h() {
        return this.field_217244_j;
    }

    public PointOfInterestManager func_217231_i() {
        return this.field_217237_a.func_219189_h();
    }

    @Override
    public /* synthetic */ WorldLightManager func_212863_j_() {
        return this.func_212863_j_();
    }

    @Override
    public /* synthetic */ IBlockReader func_212864_k_() {
        return this.func_212864_k_();
    }

    final class ChunkExecutor
    extends ThreadTaskExecutor<Runnable> {
        private ChunkExecutor(World world) {
            super("Chunk source main thread executor for " + Registry.field_212622_k.func_177774_c(world.func_201675_m().func_186058_p()));
        }

        @Override
        protected Runnable func_212875_d_(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean func_212874_c_(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean func_213164_aw() {
            return true;
        }

        @Override
        protected Thread func_213170_ax() {
            return ServerChunkProvider.this.field_217241_g;
        }

        @Override
        protected boolean func_213168_p() {
            if (ServerChunkProvider.this.func_217235_l()) {
                return true;
            }
            ServerChunkProvider.this.field_217242_h.func_215588_z_();
            return super.func_213168_p();
        }
    }
}

