/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.FortressPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FortressStructure
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> field_202381_d = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200792_f, 10, 2, 3), new Biome.SpawnListEntry(EntityType.field_200785_Y, 5, 4, 4), new Biome.SpawnListEntry(EntityType.field_200722_aA, 8, 5, 5), new Biome.SpawnListEntry(EntityType.field_200741_ag, 2, 5, 5), new Biome.SpawnListEntry(EntityType.field_200771_K, 3, 4, 4)});

    public FortressStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2) {
        \u2603 = n >> 4;
        \u2603 = n2 >> 4;
        random.setSeed((long)(\u2603 ^ \u2603 << 4) ^ chunkGenerator.func_202089_c());
        random.nextInt();
        if (random.nextInt(3) != 0) {
            return false;
        }
        if (n != (\u2603 << 4) + 4 + random.nextInt(8)) {
            return false;
        }
        if (n2 != (\u2603 << 4) + 4 + random.nextInt(8)) {
            return false;
        }
        Biome biome = chunkGenerator.func_202090_b().func_222364_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9));
        return chunkGenerator.func_202094_a(biome, Feature.field_202337_o);
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "Fortress";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_202381_d;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            FortressPieces.Start start = new FortressPieces.Start(this.field_214631_d, (n << 4) + 2, (n2 << 4) + 2);
            this.field_75075_a.add(start);
            start.func_74861_a(start, this.field_75075_a, this.field_214631_d);
            List<StructurePiece> \u26032 = start.field_74967_d;
            while (!\u26032.isEmpty()) {
                int n3 = this.field_214631_d.nextInt(\u26032.size());
                StructurePiece \u26033 = \u26032.remove(n3);
                \u26033.func_74861_a(start, this.field_75075_a, this.field_214631_d);
            }
            this.func_202500_a();
            this.func_214626_a(this.field_214631_d, 48, 70);
        }
    }
}

