/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;

public class ModDirTransformerDiscoverer
implements ITransformerDiscoveryService {
    public List<Path> candidates(Path gameDirectory) {
        Path modsDir = gameDirectory.resolve(FMLPaths.MODSDIR.relative());
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        try {
            Files.createDirectories(modsDir, new FileAttribute[0]);
            Files.walk(modsDir, 1, new FileVisitOption[0]).forEach(p -> {
                if (!Files.isRegularFile(p, new LinkOption[0])) {
                    return;
                }
                if (!p.toString().endsWith(".jar")) {
                    return;
                }
                if ((Long)LamdbaExceptionUtils.uncheck(() -> Files.size(p)) == 0L) {
                    return;
                }
                try (ZipFile zf = new ZipFile(new File(p.toUri()));){
                    if (zf.getEntry("META-INF/services/cpw.mods.modlauncher.api.ITransformationService") != null) {
                        paths.add((Path)p);
                    }
                }
                catch (IOException ioe) {
                    LogManager.getLogger().error("Zip Error when loading jar file {}", p, (Object)ioe);
                }
            });
        }
        catch (IOException | IllegalStateException ioe) {
            LogManager.getLogger().error("Error during early discovery", (Throwable)ioe);
        }
        return paths;
    }
}

