/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.INameMappingService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.accesstransformer.service.AccessTransformerService;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLCommonLaunchHandler;
import net.minecraftforge.fml.loading.FixSSL;
import net.minecraftforge.fml.loading.LanguageLoadingProvider;
import net.minecraftforge.fml.loading.LauncherVersion;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModJarURLHandler;
import net.minecraftforge.fml.loading.RuntimeDistCleaner;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.coremod.ICoreModProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static AccessTransformerService accessTransformer;
    private static ModDiscoverer modDiscoverer;
    private static ICoreModProvider coreModProvider;
    private static ILaunchPluginService eventBus;
    private static LanguageLoadingProvider languageLoadingProvider;
    private static Dist dist;
    private static String naming;
    private static LoadingModList loadingModList;
    private static TransformingClassLoader launchClassLoader;
    private static RuntimeDistCleaner runtimeDistCleaner;
    private static Path gamePath;
    private static Path forgePath;
    private static Path[] mcPaths;
    static String mcVersion;
    private static String mcpVersion;
    static String forgeVersion;
    private static String forgeGroup;
    private static Predicate<String> classLoaderExclusions;
    private static String launchHandlerName;

    static void onInitialLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
        String version = LauncherVersion.getVersion();
        LOGGER.debug(LogMarkers.CORE, "FML {} loading", (Object)version);
        Package modLauncherPackage = ITransformationService.class.getPackage();
        LOGGER.debug(LogMarkers.CORE, "FML found ModLauncher version : {}", (Object)modLauncherPackage.getImplementationVersion());
        if (!modLauncherPackage.isCompatibleWith("2.0")) {
            LOGGER.fatal(LogMarkers.CORE, "Found incompatible ModLauncher specification : {}, version {} from {}", (Object)modLauncherPackage.getSpecificationVersion(), (Object)modLauncherPackage.getImplementationVersion(), (Object)modLauncherPackage.getImplementationVendor());
            throw new IncompatibleEnvironmentException("Incompatible modlauncher found " + modLauncherPackage.getSpecificationVersion());
        }
        LOGGER.debug(LogMarkers.CORE, "Initializing modjar URL handler");
        URL.setURLStreamHandlerFactory(p -> p.equals("modjar") ? new ModJarURLHandler() : null);
        accessTransformer = (AccessTransformerService)environment.findLaunchPlugin("accesstransformer").orElseThrow(() -> {
            LOGGER.fatal(LogMarkers.CORE, "Access Transformer library is missing, we need this to run");
            return new IncompatibleEnvironmentException("Missing AccessTransformer, cannot run");
        });
        Package atPackage = accessTransformer.getClass().getPackage();
        LOGGER.debug(LogMarkers.CORE, "FML found AccessTransformer version : {}", (Object)atPackage.getImplementationVersion());
        if (!atPackage.isCompatibleWith("1.0")) {
            LOGGER.fatal(LogMarkers.CORE, "Found incompatible AccessTransformer specification : {}, version {} from {}", (Object)atPackage.getSpecificationVersion(), (Object)atPackage.getImplementationVersion(), (Object)atPackage.getImplementationVendor());
            throw new IncompatibleEnvironmentException("Incompatible accesstransformer found " + atPackage.getSpecificationVersion());
        }
        eventBus = (ILaunchPluginService)environment.findLaunchPlugin("eventbus").orElseThrow(() -> {
            LOGGER.fatal(LogMarkers.CORE, "Event Bus library is missing, we need this to run");
            return new IncompatibleEnvironmentException("Missing EventBus, cannot run");
        });
        Package eventBusPackage = eventBus.getClass().getPackage();
        LOGGER.debug(LogMarkers.CORE, "FML found EventBus version : {}", (Object)eventBusPackage.getImplementationVersion());
        if (!eventBusPackage.isCompatibleWith("1.0")) {
            LOGGER.fatal(LogMarkers.CORE, "Found incompatible EventBus specification : {}, version {} from {}", (Object)eventBusPackage.getSpecificationVersion(), (Object)eventBusPackage.getImplementationVersion(), (Object)eventBusPackage.getImplementationVendor());
            throw new IncompatibleEnvironmentException("Incompatible eventbus found " + eventBusPackage.getSpecificationVersion());
        }
        runtimeDistCleaner = (RuntimeDistCleaner)environment.findLaunchPlugin("runtimedistcleaner").orElseThrow(() -> {
            LOGGER.fatal(LogMarkers.CORE, "Dist Cleaner is missing, we need this to run");
            return new IncompatibleEnvironmentException("Missing DistCleaner, cannot run!");
        });
        LOGGER.debug(LogMarkers.CORE, "Found Runtime Dist Cleaner");
        ArrayList coreModProviders = new ArrayList();
        ServiceLoaderStreamUtils.errorHandlingServiceLoader(ICoreModProvider.class, serviceConfigurationError -> LOGGER.fatal(LogMarkers.CORE, "Failed to load a coremod library, expect problems", (Throwable)serviceConfigurationError)).forEach(coreModProviders::add);
        if (coreModProviders.isEmpty()) {
            LOGGER.fatal(LogMarkers.CORE, "Found no coremod provider. Cannot run");
            throw new IncompatibleEnvironmentException("No coremod library found");
        }
        if (coreModProviders.size() > 1) {
            LOGGER.fatal(LogMarkers.CORE, "Found multiple coremod providers : {}. Cannot run", coreModProviders.stream().map(p -> p.getClass().getName()).collect(Collectors.toList()));
            throw new IncompatibleEnvironmentException("Multiple coremod libraries found");
        }
        coreModProvider = (ICoreModProvider)coreModProviders.get(0);
        Package coremodPackage = coreModProvider.getClass().getPackage();
        LOGGER.debug(LogMarkers.CORE, "FML found CoreMod version : {}", (Object)coremodPackage.getImplementationVersion());
        LOGGER.debug(LogMarkers.CORE, "Found ForgeSPI package implementation version {}", (Object)Environment.class.getPackage().getImplementationVersion());
        LOGGER.debug(LogMarkers.CORE, "Found ForgeSPI package specification {}", (Object)Environment.class.getPackage().getSpecificationVersion());
        if (Integer.parseInt(Environment.class.getPackage().getSpecificationVersion()) < 2) {
            LOGGER.fatal(LogMarkers.CORE, "Found an out of date ForgeSPI implementation: {}, loading cannot continue", (Object)Environment.class.getPackage().getSpecificationVersion());
            throw new IncompatibleEnvironmentException("ForgeSPI is out of date, we cannot continue");
        }
        try {
            Class.forName("com.electronwill.nightconfig.core.Config", false, environment.getClass().getClassLoader());
            Class.forName("com.electronwill.nightconfig.toml.TomlFormat", false, environment.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.fatal(LogMarkers.CORE, "Failed to load NightConfig");
            throw new IncompatibleEnvironmentException("Missing NightConfig");
        }
        FixSSL.fixup();
    }

    static void setupLaunchHandler(IEnvironment environment, Map<String, ?> arguments) {
        String launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).orElse("MISSING");
        Optional launchHandler = environment.findLaunchHandler(launchTarget);
        LOGGER.debug(LogMarkers.CORE, "Using {} as launch service", (Object)launchTarget);
        if (!launchHandler.isPresent()) {
            LOGGER.fatal(LogMarkers.CORE, "Missing LaunchHandler {}, cannot continue", (Object)launchTarget);
            throw new RuntimeException("Missing launch handler");
        }
        if (!(launchHandler.get() instanceof FMLCommonLaunchHandler)) {
            LOGGER.fatal(LogMarkers.CORE, "Incompatible Launch handler found - type {}, cannot continue", (Object)((ILaunchHandlerService)launchHandler.get()).getClass().getName());
            throw new RuntimeException("Incompatible launch handler found");
        }
        launchHandlerName = ((ILaunchHandlerService)launchHandler.get()).name();
        gamePath = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElse(Paths.get(".", new String[0]).toAbsolutePath());
        FMLCommonLaunchHandler commonLaunchHandler = (FMLCommonLaunchHandler)launchHandler.get();
        naming = commonLaunchHandler.getNaming();
        dist = commonLaunchHandler.getDist();
        accessTransformer.getExtension().accept(Pair.of((Object)naming, (Object)"srg"));
        mcVersion = (String)arguments.get("mcVersion");
        mcpVersion = (String)arguments.get("mcpVersion");
        forgeVersion = (String)arguments.get("forgeVersion");
        forgeGroup = (String)arguments.get("forgeGroup");
        LOGGER.debug(LogMarkers.CORE, "Received command line version data  : MC Version: '{}' MCP Version: '{}' Forge Version: '{}' Forge group: '{}'", (Object)mcVersion, (Object)mcpVersion, (Object)forgeVersion, (Object)forgeGroup);
        forgePath = commonLaunchHandler.getForgePath(mcVersion, forgeVersion, forgeGroup);
        mcPaths = commonLaunchHandler.getMCPaths(mcVersion, mcpVersion, forgeVersion, forgeGroup);
        commonLaunchHandler.validatePaths(forgePath, mcPaths, forgeVersion, mcVersion, mcpVersion);
        commonLaunchHandler.setup(environment, arguments);
        classLoaderExclusions = commonLaunchHandler.getPackagePredicate();
        languageLoadingProvider = new LanguageLoadingProvider();
        languageLoadingProvider.addForgeLanguage(forgePath);
        runtimeDistCleaner.getExtension().accept(dist);
    }

    public static void beginModScan(Map<String, ?> arguments) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for Mod Locators");
        modDiscoverer = new ModDiscoverer(arguments);
        BackgroundScanHandler backgroundScanHandler = modDiscoverer.discoverMods();
        loadingModList = backgroundScanHandler.getLoadingModList();
    }

    public static ICoreModProvider getCoreModProvider() {
        return coreModProvider;
    }

    public static LanguageLoadingProvider getLanguageLoadingProvider() {
        return languageLoadingProvider;
    }

    static ModDiscoverer getModDiscoverer() {
        return modDiscoverer;
    }

    public static void addAccessTransformer(Path atPath, ModFile modName) {
        LOGGER.debug(LogMarkers.SCAN, "Adding Access Transformer in {}", (Object)modName.getFilePath());
        accessTransformer.addResource(atPath, modName.getFileName());
    }

    public static Dist getDist() {
        return dist;
    }

    public static void beforeStart(ITransformingClassLoader launchClassLoader) {
        FMLLoader.launchClassLoader = (TransformingClassLoader)launchClassLoader.getInstance();
    }

    public static LoadingModList getLoadingModList() {
        return loadingModList;
    }

    public static TransformingClassLoader getLaunchClassLoader() {
        return launchClassLoader;
    }

    public static Path getGamePath() {
        return gamePath;
    }

    public static Path getForgePath() {
        return forgePath;
    }

    public static Path[] getMCPaths() {
        return mcPaths;
    }

    public static Predicate<String> getClassLoaderExclusions() {
        return classLoaderExclusions;
    }

    public static String getNaming() {
        return naming;
    }

    public static Optional<BiFunction<INameMappingService.Domain, String, String>> getNameFunction(String naming) {
        return Launcher.INSTANCE.environment().findNameMapping(naming);
    }

    public static String getMcpVersion() {
        return mcpVersion;
    }

    public static String getLauncherInfo() {
        return Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.MLIMPL_VERSION.get()).orElse("MISSING");
    }

    public static List<Map<String, String>> modLauncherModList() {
        return Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.MODLIST.get()).orElseGet(Collections::emptyList);
    }

    public static String launcherHandlerName() {
        return launchHandlerName;
    }
}

