/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ClearableRegistry<V>
implements IRegistry<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REGISTRY = MarkerManager.getMarker((String)"REGISTRY");
    private final IntIdentityHashBiMap<V> ids = new IntIdentityHashBiMap(256);
    private final BiMap<ResourceLocation, V> map = HashBiMap.create();
    private final Set<ResourceLocation> keys = Collections.unmodifiableSet(this.map.keySet());
    private List<V> values = new ArrayList<V>();
    private final ResourceLocation name;
    private int nextId = 0;

    public ClearableRegistry(ResourceLocation name) {
        this.name = name;
    }

    @Nullable
    public ResourceLocation func_177774_c(V value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    public V func_82594_a(ResourceLocation key) {
        throw new UnsupportedOperationException("No default value");
    }

    public ResourceLocation func_212609_b() {
        throw new UnsupportedOperationException("No default key");
    }

    @Nullable
    public int func_148757_b(V value) {
        return this.ids.func_186815_a(value);
    }

    @Nullable
    public V func_148754_a(int id) {
        return (V)this.ids.func_186813_a(id);
    }

    public Iterator<V> iterator() {
        return this.ids.iterator();
    }

    @Nullable
    public V func_212608_b(ResourceLocation key) {
        return (V)this.map.get((Object)key);
    }

    public void func_177775_a(int id, ResourceLocation key, V value) {
        Validate.isTrue((id >= 0 ? 1 : 0) != 0, (String)"Invalid ID, can not be < 0", (Object[])new Object[0]);
        Validate.notNull((Object)key);
        Validate.notNull(value);
        Object old = this.map.get((Object)key);
        if (old != null) {
            LOGGER.debug(REGISTRY, "{}: Adding suplicate key '{}' to registry. Old: {} New: {}", (Object)this.name, (Object)key, old, value);
            this.values.remove(old);
        }
        this.map.put((Object)key, value);
        this.ids.func_186814_a(value, id);
        this.values.add(value);
        if (this.nextId <= id) {
            this.nextId = id + 1;
        }
    }

    public void func_82595_a(ResourceLocation key, V value) {
        this.func_177775_a(this.nextId, key, value);
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.keys;
    }

    public boolean func_195866_d() {
        return this.map.isEmpty();
    }

    @Nullable
    public V func_186801_a(Random random) {
        return this.values.isEmpty() ? null : (V)this.values.get(random.nextInt(this.values.size()));
    }

    public boolean func_212607_c(ResourceLocation key) {
        return this.map.containsKey((Object)key);
    }

    public void clear() {
        LOGGER.debug(REGISTRY, "{}: Clearing registry", (Object)this.name);
        this.map.clear();
        this.values.clear();
        this.ids.func_186812_a();
        this.nextId = 0;
    }

    public int getNextId() {
        return this.nextId;
    }
}

