/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.WorldPersistenceHooks;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class FMLWorldPersistenceHook
implements WorldPersistenceHooks.WorldPersistenceHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker WORLDPERSISTENCE = MarkerManager.getMarker((String)"WP");

    @Override
    public String getModId() {
        return "fml";
    }

    @Override
    public NBTTagCompound getDataForWriting(SaveHandler handler, WorldInfo info) {
        NBTTagCompound fmlData = new NBTTagCompound();
        NBTTagList modList = new NBTTagList();
        ModList.get().getMods().forEach(mi -> {
            NBTTagCompound mod = new NBTTagCompound();
            mod.func_74778_a("ModId", mi.getModId());
            mod.func_74778_a("ModVersion", MavenVersionStringHelper.artifactVersionToString(mi.getVersion()));
            modList.add((INBTBase)mod);
        });
        fmlData.func_74782_a("LoadingModList", (INBTBase)modList);
        NBTTagCompound registries = new NBTTagCompound();
        fmlData.func_74782_a("Registries", (INBTBase)registries);
        LOGGER.debug(WORLDPERSISTENCE, "Gathering id map for writing to world save {}", (Object)info.func_76065_j());
        for (Map.Entry<ResourceLocation, ForgeRegistry.Snapshot> e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
            registries.func_74782_a(e.getKey().toString(), (INBTBase)e.getValue().write());
        }
        return fmlData;
    }

    @Override
    public void readData(SaveHandler handler, WorldInfo info, NBTTagCompound tag) {
        if (tag.func_74764_b("LoadingModList")) {
            NBTTagList modList = tag.func_150295_c("LoadingModList", 10);
            for (int i = 0; i < modList.size(); ++i) {
                NBTTagCompound mod = modList.func_150305_b(i);
                String modId = mod.func_74779_i("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.func_74779_i("ModVersion");
                Optional<? extends ModContainer> container = ModList.get().getModContainerById(modId);
                if (!container.isPresent()) {
                    LOGGER.error(WORLDPERSISTENCE, "This world was saved with mod {} which appears to be missing, things may not work well", (Object)modId);
                    continue;
                }
                if (Objects.equals(modVersion, MavenVersionStringHelper.artifactVersionToString(container.get().getModInfo().getVersion()))) continue;
                LOGGER.warn(WORLDPERSISTENCE, "This world was saved with mod {} version {} and it is now at version {}, things may not work well", (Object)modId, (Object)modVersion, (Object)MavenVersionStringHelper.artifactVersionToString(container.get().getModInfo().getVersion()));
            }
        }
        Multimap<ResourceLocation, ResourceLocation> failedElements = null;
        if (tag.func_74764_b("ModItemData") || tag.func_74764_b("ItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.func_74764_b("Registries")) {
            HashMap<ResourceLocation, ForgeRegistry.Snapshot> snapshot = new HashMap<ResourceLocation, ForgeRegistry.Snapshot>();
            NBTTagCompound regs = tag.func_74775_l("Registries");
            for (String key : regs.func_150296_c()) {
                snapshot.put(new ResourceLocation(key), ForgeRegistry.Snapshot.read(regs.func_74775_l(key)));
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Forge Mod Loader could not load this save.\n\n").append("There are ").append(failedElements.size()).append(" unassigned registry entries in this save.\n").append("You will not be able to load until they are present again.\n\n");
            failedElements.asMap().forEach((name, entries) -> {
                buf.append("Missing ").append(name).append(":\n");
                entries.forEach(rl -> buf.append("    ").append(rl).append("\n"));
            });
            StartupQuery.notify(buf.toString());
            StartupQuery.abort();
        }
    }
}

