/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.common.util.NonNullSupplier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LazyOptional<T> {
    private final NonNullSupplier<T> supplier;
    private AtomicReference<T> resolved;
    private Set<NonNullConsumer<LazyOptional<T>>> listeners = new HashSet<NonNullConsumer<LazyOptional<T>>>();
    private boolean isValid = true;
    @Nonnull
    private static final LazyOptional<Void> EMPTY = new LazyOptional(null);

    public static <T> LazyOptional<T> of(@Nullable NonNullSupplier<T> instanceSupplier) {
        return instanceSupplier == null ? LazyOptional.empty() : new LazyOptional<T>(instanceSupplier);
    }

    public static <T> LazyOptional<T> empty() {
        return EMPTY.cast();
    }

    public <X> LazyOptional<X> cast() {
        return this;
    }

    private LazyOptional(@Nullable NonNullSupplier<T> instanceSupplier) {
        this.supplier = instanceSupplier;
    }

    @Nullable
    private T getValue() {
        if (!this.isValid) {
            return null;
        }
        if (this.resolved != null) {
            return this.resolved.get();
        }
        if (this.supplier != null) {
            this.resolved = new AtomicReference<Object>(null);
            try {
                T temp = this.supplier.get();
                if (temp == null) {
                    throw new IllegalStateException("Supplier must not return null value");
                }
                this.resolved.set(temp);
                return this.resolved.get();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private T getValueUnsafe() {
        T ret = this.getValue();
        if (ret == null) {
            throw new IllegalStateException("LazyOptional is empty or otherwise returned null from getValue() unexpectedly");
        }
        return ret;
    }

    public boolean isPresent() {
        return this.supplier != null && this.isValid;
    }

    public void ifPresent(NonNullConsumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        T val = this.getValue();
        if (this.isValid && val != null) {
            consumer.accept(val);
        }
    }

    public <U> LazyOptional<U> map(NonNullFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? LazyOptional.of(() -> mapper.apply((T)this.getValueUnsafe())) : LazyOptional.empty();
    }

    public LazyOptional<T> filter(NonNullPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        Object value = this.getValue();
        return value != null && predicate.test(value) ? LazyOptional.of(() -> value) : LazyOptional.empty();
    }

    public T orElse(T other) {
        T val = this.getValue();
        return val != null ? val : other;
    }

    public T orElseGet(NonNullSupplier<? extends T> other) {
        T val = this.getValue();
        return val != null ? val : other.get();
    }

    public <X extends Throwable> T orElseThrow(NonNullSupplier<? extends X> exceptionSupplier) throws X {
        T val = this.getValue();
        if (val != null) {
            return val;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public void addListener(NonNullConsumer<LazyOptional<T>> listener) {
        if (this.isPresent()) {
            this.listeners.add(listener);
        } else {
            listener.accept(this);
        }
    }

    public void invalidate() {
        this.isValid = false;
        this.listeners.forEach(e -> e.accept(this));
    }
}

