/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface IForgeTileEntity
extends ICapabilitySerializable<NBTTagCompound> {
    public static final AxisAlignedBB INFINITE_EXTENT_AABB = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    default public TileEntity getTileEntity() {
        return (TileEntity)this;
    }

    @Override
    default public void deserializeNBT(NBTTagCompound nbt) {
        this.getTileEntity().func_145839_a(nbt);
    }

    @Override
    default public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.getTileEntity().func_189515_b(ret);
        return ret;
    }

    default public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
    }

    default public void handleUpdateTag(NBTTagCompound tag) {
        this.getTileEntity().func_145839_a(tag);
    }

    public NBTTagCompound getTileData();

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        IBlockState state = this.getTileEntity().func_195044_w();
        Block block = state.func_177230_c();
        BlockPos pos = this.getTileEntity().func_174877_v();
        if (block == Blocks.field_150381_bn) {
            bb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        } else if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
            bb = new AxisAlignedBB(pos.func_177982_a(-1, 0, -1), pos.func_177982_a(2, 2, 2));
        } else if (block == Blocks.field_185779_df) {
            bb = INFINITE_EXTENT_AABB;
        } else if (block != null && block != Blocks.field_150461_bJ) {
            AxisAlignedBB cbb = null;
            try {
                cbb = state.func_196952_d((IBlockReader)this.getTileEntity().func_145831_w(), pos).func_197752_a().func_186670_a(pos);
            }
            catch (Exception e) {
                cbb = new AxisAlignedBB(pos.func_177982_a(-1, 0, -1), pos.func_177982_a(1, 1, 1));
            }
            if (cbb != null) {
                bb = cbb;
            }
        }
        return bb;
    }

    default public boolean canRenderBreaking() {
        Block block = this.getTileEntity().func_195044_w().func_177230_c();
        return block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
    }

    default public boolean hasFastRenderer() {
        return false;
    }

    default public void requestModelDataUpdate() {
        TileEntity te = this.getTileEntity();
        World world = te.func_145831_w();
        if (world != null && world.field_72995_K) {
            ModelDataManager.requestModelDataRefresh(te);
        }
    }

    @Nonnull
    default public IModelData getModelData() {
        return EmptyModelData.INSTANCE;
    }
}

