/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PerspectiveMapWrapper
implements IBakedModel {
    private final IBakedModel parent;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

    public PerspectiveMapWrapper(IBakedModel parent, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        this.parent = parent;
        this.transforms = transforms;
    }

    public PerspectiveMapWrapper(IBakedModel parent, IModelState state) {
        this(parent, PerspectiveMapWrapper.getTransforms(state));
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IModelState state) {
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            Optional<TRSRTransformation> tr = state.apply(Optional.of(type));
            if (!tr.isPresent()) continue;
            map.put(type, tr.get());
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(ItemCameraTransforms transforms) {
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            if (!transforms.func_181687_c(type)) continue;
            map.put(type, TRSRTransformation.blockCenterToCorner(TRSRTransformation.from(transforms.func_181688_b(type))));
        }
        return ImmutableMap.copyOf(map);
    }

    public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation tr = (TRSRTransformation)transforms.getOrDefault((Object)cameraTransformType, (Object)TRSRTransformation.identity());
        if (!tr.isIdentity()) {
            return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrixVec());
        }
        return Pair.of((Object)model, null);
    }

    public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, IModelState state, ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation tr = state.apply(Optional.of(cameraTransformType)).orElse(TRSRTransformation.identity());
        if (!tr.isIdentity()) {
            return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrixVec());
        }
        return Pair.of((Object)model, null);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.parent.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    public List<BakedQuad> func_200117_a(@Nullable IBlockState state, @Nullable EnumFacing side, Random rand) {
        return this.parent.func_200117_a(state, side, rand);
    }

    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, cameraTransformType);
    }
}

