/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class EntityViewRenderEvent
extends Event {
    private final GameRenderer renderer;
    private final Entity entity;
    private final IBlockState state;
    private final IFluidState fluidState;
    private final double renderPartialTicks;

    public EntityViewRenderEvent(GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks) {
        this.renderer = renderer;
        this.entity = entity;
        this.state = state;
        this.fluidState = fluidState;
        this.renderPartialTicks = renderPartialTicks;
    }

    public GameRenderer getRenderer() {
        return this.renderer;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public IFluidState getFluidState() {
        return this.fluidState;
    }

    public double getRenderPartialTicks() {
        return this.renderPartialTicks;
    }

    public static class FOVModifier
    extends EntityViewRenderEvent {
        private double fov;

        public FOVModifier(GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks, double fov) {
            super(renderer, entity, state, fluidState, renderPartialTicks);
            this.setFOV(fov);
        }

        public double getFOV() {
            return this.fov;
        }

        public void setFOV(double fov) {
            this.fov = fov;
        }
    }

    public static class CameraSetup
    extends EntityViewRenderEvent {
        private float yaw;
        private float pitch;
        private float roll;

        public CameraSetup(GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(renderer, entity, state, fluidState, renderPartialTicks);
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }

    public static class FogColors
    extends FogEvent {
        private float red;
        private float green;
        private float blue;

        public FogColors(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks, float red, float green, float blue) {
            super(fogRenderer, renderer, entity, state, fluidState, renderPartialTicks);
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        public float getRed() {
            return this.red;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public float getGreen() {
            return this.green;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    @Event.HasResult
    public static class RenderFogEvent
    extends FogEvent {
        private final int fogMode;
        private final float farPlaneDistance;

        public RenderFogEvent(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks, int fogMode, float farPlaneDistance) {
            super(fogRenderer, renderer, entity, state, fluidState, renderPartialTicks);
            this.fogMode = fogMode;
            this.farPlaneDistance = farPlaneDistance;
        }

        public int getFogMode() {
            return this.fogMode;
        }

        public float getFarPlaneDistance() {
            return this.farPlaneDistance;
        }
    }

    @Cancelable
    public static class FogDensity
    extends FogEvent {
        private float density;

        public FogDensity(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks, float density) {
            super(fogRenderer, renderer, entity, state, fluidState, renderPartialTicks);
            this.setDensity(density);
        }

        public float getDensity() {
            return this.density;
        }

        public void setDensity(float density) {
            this.density = density;
        }
    }

    private static class FogEvent
    extends EntityViewRenderEvent {
        private final FogRenderer fogRenderer;

        protected FogEvent(FogRenderer fogRenderer, GameRenderer renderer, Entity entity, IBlockState state, IFluidState fluidState, double renderPartialTicks) {
            super(renderer, entity, state, fluidState, renderPartialTicks);
            this.fogRenderer = fogRenderer;
        }

        public FogRenderer getFogRenderer() {
            return this.fogRenderer;
        }
    }
}

