/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerAuditTrail;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TransformerAuditTrail
implements ITransformerAuditTrail {
    private Map<String, List<TransformerActivity>> audit = new HashMap<String, List<TransformerActivity>>();

    public void addPluginAuditTrail(String clazz, ILaunchPluginService plugin, ILaunchPluginService.Phase phase) {
        this.getTransformerActivities(clazz).add(new TransformerActivity(Type.PLUGIN, new String[]{plugin.name(), phase.name().substring(0, 1)}));
    }

    public void addTransformerAuditTrail(String clazz, ITransformationService transformService, ITransformer<?> transformer) {
        this.getTransformerActivities(clazz).add(new TransformerActivity(Type.TRANSFORMER, this.concat(transformService.name(), transformer.labels())));
    }

    private String[] concat(String first, String[] rest) {
        String[] res = new String[rest.length + 1];
        res[0] = first;
        System.arraycopy(rest, 0, res, 1, rest.length);
        return res;
    }

    private List<TransformerActivity> getTransformerActivities(String clazz) {
        return this.audit.computeIfAbsent(clazz, v -> new ArrayList());
    }

    @Override
    public String getAuditString(String clazz) {
        return this.audit.getOrDefault(clazz, Collections.emptyList()).stream().map(TransformerActivity::getActivityString).collect(Collectors.joining(","));
    }

    static enum Type {
        PLUGIN("pl"),
        TRANSFORMER("xf");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static class TransformerActivity {
        private final Type type;
        private final String[] context;

        private TransformerActivity(Type type, String ... context) {
            this.type = type;
            this.context = context;
        }

        String getActivityString() {
            return this.type.getLabel() + ":" + String.join((CharSequence)":", this.context);
        }
    }
}

