/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger field_186465_b = LogManager.getLogger();
    public static final LootTable field_186464_a = new LootTable(new LootPool[0]);
    private final List<LootPool> field_186466_c;
    private boolean isFrozen = false;

    public LootTable(LootPool[] poolsIn) {
        this.field_186466_c = Lists.newArrayList((Object[])poolsIn);
    }

    public List<ItemStack> func_186462_a(Random rand, LootContext context) {
        ArrayList list = Lists.newArrayList();
        if (context.func_186496_a(this)) {
            for (LootPool lootpool : this.field_186466_c) {
                lootpool.func_186449_b(list, rand, context);
            }
            context.func_186490_b(this);
        } else {
            field_186465_b.warn("Detected infinite loop in loot tables");
        }
        return list;
    }

    public void func_186460_a(IInventory inventory, Random rand, LootContext context) {
        List<ItemStack> list = this.func_186462_a(rand, context);
        List<Integer> list1 = this.func_186459_a(inventory, rand);
        this.func_186463_a(list, list1.size(), rand);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(list1.remove(list1.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(list1.remove(list1.size() - 1).intValue(), itemstack);
        }
    }

    private void func_186463_a(List<ItemStack> stacks, int p_186463_2_, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_186463_2_ - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)((Object)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1))));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    private List<Integer> func_186459_a(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public void freeze() {
        this.isFrozen = true;
        this.field_186466_c.forEach(LootPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public LootPool getPool(String name) {
        return this.field_186466_c.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.field_186466_c) {
            if (!name.equals(pool.getName())) continue;
            this.field_186466_c.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        if (this.field_186466_c.stream().anyMatch(e -> e == pool || e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.field_186466_c.add(pool);
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot table");
            LootPool[] alootpool = (LootPool[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"pools", (Object)new LootPool[0], (JsonDeserializationContext)p_deserialize_3_, LootPool[].class);
            return new LootTable(alootpool);
        }

        public JsonElement serialize(LootTable p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("pools", p_serialize_3_.serialize((Object)p_serialize_1_.field_186466_c));
            return jsonobject;
        }
    }
}

