/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiome
implements IC0Transformer {
    private static final int field_202727_a = IRegistry.field_212624_m.func_148757_b(Biomes.field_150583_P);
    private static final int field_202728_b = IRegistry.field_212624_m.func_148757_b(Biomes.field_76769_d);
    private static final int field_202729_c = IRegistry.field_212624_m.func_148757_b(Biomes.field_76770_e);
    private static final int field_202730_d = IRegistry.field_212624_m.func_148757_b(Biomes.field_76767_f);
    private static final int field_202731_e = IRegistry.field_212624_m.func_148757_b(Biomes.field_76774_n);
    private static final int field_202732_f = IRegistry.field_212624_m.func_148757_b(Biomes.field_76782_w);
    private static final int field_202733_g = IRegistry.field_212624_m.func_148757_b(Biomes.field_150608_ab);
    private static final int field_202734_h = IRegistry.field_212624_m.func_148757_b(Biomes.field_150607_aa);
    private static final int field_202735_i = IRegistry.field_212624_m.func_148757_b(Biomes.field_76789_p);
    private static final int field_202736_j = IRegistry.field_212624_m.func_148757_b(Biomes.field_76772_c);
    private static final int field_202737_k = IRegistry.field_212624_m.func_148757_b(Biomes.field_150578_U);
    private static final int field_202738_l = IRegistry.field_212624_m.func_148757_b(Biomes.field_150585_R);
    private static final int field_202739_m = IRegistry.field_212624_m.func_148757_b(Biomes.field_150588_X);
    private static final int field_202740_n = IRegistry.field_212624_m.func_148757_b(Biomes.field_76780_h);
    private static final int field_202741_o = IRegistry.field_212624_m.func_148757_b(Biomes.field_76768_g);
    private static final int field_202742_p = IRegistry.field_212624_m.func_148757_b(Biomes.field_150584_S);
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final OverworldGenSettings field_175973_g;

    public GenLayerBiome(WorldType p_i48641_1_, OverworldGenSettings p_i48641_2_) {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
        if (p_i48641_1_ == WorldType.field_77136_e) {
            this.biomes[desertIdx].clear();
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76767_f, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76770_e, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76780_h, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76768_g, 10));
            this.field_175973_g = null;
        } else {
            this.field_175973_g = p_i48641_2_;
        }
    }

    public int func_202726_a(IContext context, int value) {
        if (this.field_175973_g != null && this.field_175973_g.func_202199_l() >= 0) {
            return this.field_175973_g.func_202199_l();
        }
        int i = (value & 0xF00) >> 8;
        if (!LayerUtil.func_202827_a(value &= 0xFFFFF0FF) && value != field_202735_i) {
            switch (value) {
                case 1: {
                    if (i > 0) {
                        return context.func_202696_a(3) == 0 ? field_202733_g : field_202734_h;
                    }
                    return IRegistry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (IContext)context).biome);
                }
                case 2: {
                    if (i > 0) {
                        return field_202732_f;
                    }
                    return IRegistry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (IContext)context).biome);
                }
                case 3: {
                    if (i > 0) {
                        return field_202737_k;
                    }
                    return IRegistry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (IContext)context).biome);
                }
                case 4: {
                    return IRegistry.field_212624_m.func_148757_b(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (IContext)context).biome);
                }
            }
            return field_202735_i;
        }
        return value;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type, IContext context) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

