/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.IPlantable;

public abstract class HugeTreesFeature<T extends IFeatureConfig>
extends AbstractTreeFeature<T> {
    protected final int field_76522_a;
    protected final IBlockState field_76520_b;
    protected final IBlockState field_76521_c;
    protected int field_150538_d;
    protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

    public HugeTreesFeature(boolean notify, int baseHeightIn, int extraRandomHeightIn, IBlockState woodMetadataIn, IBlockState leavesMetadataIn) {
        super(notify);
        this.field_76522_a = baseHeightIn;
        this.field_150538_d = extraRandomHeightIn;
        this.field_76520_b = woodMetadataIn;
        this.field_76521_c = leavesMetadataIn;
    }

    protected int func_150533_a(Random rand) {
        int i = rand.nextInt(3) + this.field_76522_a;
        if (this.field_150538_d > 1) {
            i += rand.nextInt(this.field_150538_d);
        }
        return i;
    }

    private boolean func_175926_c(IBlockReader worldIn, BlockPos leavesPos, int height) {
        int worldHeight;
        boolean flag = true;
        int n = worldHeight = worldIn instanceof IWorld ? ((IWorld)worldIn).func_201672_e().func_72800_K() : 256;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= worldHeight) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < 256 && this.canGrowInto(worldIn, leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean func_202405_b(IWorld p_202405_1_, BlockPos p_202405_2_) {
        BlockPos blockpos = p_202405_2_.func_177977_b();
        boolean isSoil = p_202405_1_.func_180495_p(blockpos).canSustainPlant((IBlockReader)p_202405_1_, blockpos, EnumFacing.UP, this.sapling);
        if (isSoil && p_202405_2_.func_177956_o() >= 2) {
            this.setDirtAt(p_202405_1_, blockpos, p_202405_2_);
            this.setDirtAt(p_202405_1_, blockpos.func_177974_f(), p_202405_2_);
            this.setDirtAt(p_202405_1_, blockpos.func_177968_d(), p_202405_2_);
            this.setDirtAt(p_202405_1_, blockpos.func_177968_d().func_177974_f(), p_202405_2_);
            return true;
        }
        return false;
    }

    protected boolean func_203427_a(IWorld p_203427_1_, BlockPos p_203427_2_, int p_203427_3_) {
        return this.func_175926_c((IBlockReader)p_203427_1_, p_203427_2_, p_203427_3_) && this.func_202405_b(p_203427_1_, p_203427_2_);
    }

    protected void func_175925_a(IWorld worldIn, BlockPos layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                IBlockState iblockstate;
                int i1;
                int l = Math.min(Math.abs(j), Math.abs(j - 1));
                if (l + (i1 = Math.min(Math.abs(k), Math.abs(k - 1))) >= 7 || l * l + i1 * i1 > i || !(iblockstate = worldIn.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).isAir((IBlockReader)worldIn, blockpos) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                this.func_202278_a(worldIn, blockpos, this.field_76521_c);
            }
        }
    }

    protected void func_175928_b(IWorld worldIn, BlockPos layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width; ++j) {
            for (int k = -width; k <= width; ++k) {
                BlockPos blockpos;
                IBlockState iblockstate;
                if (j * j + k * k > i || !(iblockstate = worldIn.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).isAir((IBlockReader)worldIn, blockpos) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                this.func_202278_a(worldIn, blockpos, this.field_76521_c);
            }
        }
    }

    public HugeTreesFeature<T> setSapling(IPlantable sapling) {
        this.sapling = sapling;
        return this;
    }
}

