/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathType;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();
    private static final int field_180268_a = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> field_77193_b = Sets.newHashSet();

    public int func_77192_a(WorldServer worldServerIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        this.field_77193_b.clear();
        int i = 0;
        for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int l = 8;
            for (int i1 = -8; i1 <= 8; ++i1) {
                for (int j1 = -8; j1 <= 8; ++j1) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean flag = i1 == -8 || i1 == 8 || j1 == -8 || j1 == 8;
                    ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                    if (this.field_77193_b.contains(chunkpos)) continue;
                    ++i;
                    if (flag || !worldServerIn.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = worldServerIn.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                    this.field_77193_b.add(chunkpos);
                }
            }
        }
        int k4 = 0;
        BlockPos blockpos1 = worldServerIn.func_175694_M();
        for (EnumCreatureType enumcreaturetype : EnumCreatureType.values()) {
            int l4;
            int i5;
            if (enumcreaturetype.func_75599_d() && !spawnPeacefulMobs || !enumcreaturetype.func_75599_d() && !spawnHostileMobs || enumcreaturetype.func_82705_e() && !spawnOnSetTickRate || (i5 = worldServerIn.countEntities(enumcreaturetype, l4 = enumcreaturetype.func_75601_b() * i / field_180268_a, true)) > l4) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            ArrayList<ChunkPos> shuffled = new ArrayList<ChunkPos>(this.field_77193_b);
            Collections.shuffle(shuffled);
            block6: for (ChunkPos chunkpos1 : shuffled) {
                BlockPos blockpos = WorldEntitySpawner.func_180621_a(worldServerIn, chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                int k1 = blockpos.func_177958_n();
                int l1 = blockpos.func_177956_o();
                int i2 = blockpos.func_177952_p();
                IBlockState iblockstate = worldServerIn.func_180495_p(blockpos);
                if (iblockstate.func_185915_l()) continue;
                int j2 = 0;
                block7: for (int k2 = 0; k2 < 3; ++k2) {
                    int l2 = k1;
                    int i3 = l1;
                    int j3 = i2;
                    int k3 = 6;
                    Biome.SpawnListEntry biome$spawnlistentry = null;
                    IEntityLivingData ientitylivingdata = null;
                    int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                    int i4 = 0;
                    for (int j4 = 0; j4 < l3; ++j4) {
                        EntityLiving entityliving;
                        EntitySpawnPlacementRegistry.SpawnPlacementType entityspawnplacementregistry$spawnplacementtype;
                        double d0;
                        blockpos$mutableblockpos.func_181079_c(l2 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6), i3 += worldServerIn.field_73012_v.nextInt(1) - worldServerIn.field_73012_v.nextInt(1), j3 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6));
                        float f = (float)l2 + 0.5f;
                        float f1 = (float)j3 + 0.5f;
                        EntityPlayer entityplayer1 = worldServerIn.func_212817_a(f, f1, -1.0);
                        if (entityplayer1 == null || (d0 = entityplayer1.func_70092_e(f, i3, f1)) <= 576.0 || blockpos1.func_177954_c((double)f, (double)i3, (double)f1) < 576.0) continue;
                        if (biome$spawnlistentry == null) {
                            biome$spawnlistentry = worldServerIn.func_175734_a(enumcreaturetype, (BlockPos)blockpos$mutableblockpos);
                            if (biome$spawnlistentry == null) continue block7;
                            l3 = biome$spawnlistentry.field_76301_c + worldServerIn.field_73012_v.nextInt(1 + biome$spawnlistentry.field_76299_d - biome$spawnlistentry.field_76301_c);
                        }
                        if (!worldServerIn.func_175732_a(enumcreaturetype, biome$spawnlistentry, (BlockPos)blockpos$mutableblockpos) || (entityspawnplacementregistry$spawnplacementtype = EntitySpawnPlacementRegistry.func_209344_a(biome$spawnlistentry.field_200702_b)) == null || !WorldEntitySpawner.func_209382_a(entityspawnplacementregistry$spawnplacementtype, worldServerIn, (BlockPos)blockpos$mutableblockpos, biome$spawnlistentry.field_200702_b)) continue;
                        try {
                            entityliving = biome$spawnlistentry.field_200702_b.func_200721_a(worldServerIn);
                        }
                        catch (Exception exception) {
                            field_209383_a.warn("Failed to create mob", (Throwable)exception);
                            return k4;
                        }
                        entityliving.func_70012_b(f, i3, f1, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        int canSpawn = ForgeHooks.canEntitySpawn((EntityLiving)entityliving, (IWorld)worldServerIn, (double)f, (double)i3, (double)f1, null);
                        if ((d0 <= 16384.0 || !entityliving.func_70692_ba()) && (canSpawn == 1 || canSpawn == 0 && entityliving.func_205020_a(worldServerIn, false) && entityliving.func_205019_a(worldServerIn))) {
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1, null)) {
                                ientitylivingdata = entityliving.func_204210_a(worldServerIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata, null);
                            }
                            if (entityliving.func_205019_a(worldServerIn)) {
                                ++j2;
                                ++i4;
                                worldServerIn.func_72838_d(entityliving);
                            } else {
                                entityliving.func_70106_y();
                            }
                            if (j2 >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block6;
                            if (entityliving.func_204209_c(i4)) continue block7;
                        }
                        k4 += j2;
                    }
                }
            }
        }
        return k4;
    }

    private static BlockPos func_180621_a(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = chunk.func_201576_a(Heightmap.Type.LIGHT_BLOCKING, i, j) + 1;
        int l = worldIn.field_73012_v.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static boolean func_206851_a(IBlockState blockIn, IFluidState fluidIn) {
        if (blockIn.func_185898_k()) {
            return false;
        }
        if (blockIn.func_185897_m()) {
            return false;
        }
        if (!fluidIn.func_206888_e()) {
            return false;
        }
        return !blockIn.func_203425_a(BlockTags.field_203437_y);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.SpawnPlacementType placeType, IWorldReaderBase worldIn, BlockPos pos, @Nullable EntityType<? extends EntityLiving> entityTypeIn) {
        if (entityTypeIn != null && worldIn.func_175723_af().func_177746_a(pos)) {
            return placeType.canSpawnAt(worldIn, pos, entityTypeIn);
        }
        return false;
    }

    public static boolean canSpawnAtBody(EntitySpawnPlacementRegistry.SpawnPlacementType placeType, IWorldReaderBase worldIn, BlockPos pos, @Nullable EntityType<? extends EntityLiving> entityTypeIn) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        switch (placeType) {
            case IN_WATER: {
                return ifluidstate.func_206884_a(FluidTags.field_206959_a) && worldIn.func_204610_c(pos.func_177977_b()).func_206884_a(FluidTags.field_206959_a) && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
            }
        }
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        if (iblockstate1.canCreatureSpawn(worldIn, pos.func_177977_b(), placeType, entityTypeIn)) {
            Block block = iblockstate1.func_177230_c();
            boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
            return flag && WorldEntitySpawner.func_206851_a(iblockstate, ifluidstate) && WorldEntitySpawner.func_206851_a(worldIn.func_180495_p(pos.func_177984_a()), worldIn.func_204610_c(pos.func_177984_a()));
        }
        return false;
    }

    public static void func_77191_a(IWorld worldIn, Biome biomeIn, int centerX, int centerZ, Random diameterX) {
        List<Biome.SpawnListEntry> list = biomeIn.func_76747_a(EnumCreatureType.CREATURE);
        if (!list.isEmpty()) {
            int i = centerX << 4;
            int j = centerZ << 4;
            while (diameterX.nextFloat() < biomeIn.func_76741_f()) {
                Biome.SpawnListEntry biome$spawnlistentry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)diameterX, list);
                int k = biome$spawnlistentry.field_76301_c + diameterX.nextInt(1 + biome$spawnlistentry.field_76299_d - biome$spawnlistentry.field_76301_c);
                IEntityLivingData ientitylivingdata = null;
                int l = i + diameterX.nextInt(16);
                int i1 = j + diameterX.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = WorldEntitySpawner.func_208498_a(worldIn, biome$spawnlistentry.field_200702_b, l, i1);
                        if (WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.SpawnPlacementType.ON_GROUND, worldIn, blockpos, biome$spawnlistentry.field_200702_b)) {
                            EntityLiving entityliving;
                            try {
                                entityliving = biome$spawnlistentry.field_200702_b.func_200721_a(worldIn.func_201672_e());
                            }
                            catch (Exception exception) {
                                field_209383_a.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            double d0 = MathHelper.func_151237_a((double)l, (double)((double)i + (double)entityliving.field_70130_N), (double)((double)i + 16.0 - (double)entityliving.field_70130_N));
                            double d1 = MathHelper.func_151237_a((double)i1, (double)((double)j + (double)entityliving.field_70130_N), (double)((double)j + 16.0 - (double)entityliving.field_70130_N));
                            if (ForgeHooks.canEntitySpawn((EntityLiving)entityliving, (IWorld)worldIn, (double)d0, (double)blockpos.func_177956_o(), (double)d1, null) == -1) continue;
                            entityliving.func_70012_b(d0, blockpos.func_177956_o(), d1, diameterX.nextFloat() * 360.0f, 0.0f);
                            if (entityliving.func_205020_a(worldIn, false) && entityliving.func_205019_a(worldIn)) {
                                ientitylivingdata = entityliving.func_204210_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata, null);
                                worldIn.func_72838_d(entityliving);
                                flag = true;
                            }
                        }
                        l += diameterX.nextInt(5) - diameterX.nextInt(5);
                        i1 += diameterX.nextInt(5) - diameterX.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                            i1 = k1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorld p_208498_0_, @Nullable EntityType<? extends EntityLiving> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        BlockPos blockpos = new BlockPos(p_208498_2_, p_208498_0_.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(p_208498_1_), p_208498_2_, p_208498_3_), p_208498_3_);
        BlockPos blockpos1 = blockpos.func_177977_b();
        return p_208498_0_.func_180495_p(blockpos1).func_196957_g((IBlockReader)p_208498_0_, blockpos1, PathType.LAND) ? blockpos1 : blockpos;
    }
}

