/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerInteractionManager {
    public World field_73092_a;
    public EntityPlayerMP field_73090_b;
    private GameType field_73091_c = GameType.NOT_SET;
    private boolean field_73088_d;
    private int field_73089_e;
    private BlockPos field_180240_f = BlockPos.field_177992_a;
    private int field_73100_i;
    private boolean field_73097_j;
    private BlockPos field_180241_i = BlockPos.field_177992_a;
    private int field_73093_n;
    private int field_73094_o = -1;

    public PlayerInteractionManager(World worldIn) {
        this.field_73092_a = worldIn;
    }

    public void func_73076_a(GameType type) {
        this.field_73091_c = type;
        type.func_77147_a(this.field_73090_b.field_71075_bZ);
        this.field_73090_b.func_71016_p();
        this.field_73090_b.field_71133_b.func_184103_al().func_148540_a((Packet<?>)new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_GAME_MODE, new EntityPlayerMP[]{this.field_73090_b}));
        this.field_73092_a.func_72854_c();
    }

    public GameType func_73081_b() {
        return this.field_73091_c;
    }

    public boolean func_180239_c() {
        return this.field_73091_c.func_77144_e();
    }

    public boolean func_73083_d() {
        return this.field_73091_c.func_77145_d();
    }

    public void func_73077_b(GameType type) {
        if (this.field_73091_c == GameType.NOT_SET) {
            this.field_73091_c = type;
        }
        this.func_73076_a(this.field_73091_c);
    }

    public void func_73075_a() {
        ++this.field_73100_i;
        if (this.field_73097_j) {
            int i = this.field_73100_i - this.field_73093_n;
            IBlockState iblockstate = this.field_73092_a.func_180495_p(this.field_180241_i);
            if (iblockstate.isAir((IBlockReader)this.field_73092_a, this.field_180241_i)) {
                this.field_73097_j = false;
            } else {
                float f = iblockstate.func_185903_a(this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, this.field_180241_i) * (float)(i + 1);
                int j = (int)(f * 10.0f);
                if (j != this.field_73094_o) {
                    this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180241_i, j);
                    this.field_73094_o = j;
                }
                if (f >= 1.0f) {
                    this.field_73097_j = false;
                    this.func_180237_b(this.field_180241_i);
                }
            }
        } else if (this.field_73088_d) {
            IBlockState iblockstate1 = this.field_73092_a.func_180495_p(this.field_180240_f);
            if (iblockstate1.isAir((IBlockReader)this.field_73092_a, this.field_180240_f)) {
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73094_o = -1;
                this.field_73088_d = false;
            } else {
                int k = this.field_73100_i - this.field_73089_e;
                float f1 = iblockstate1.func_185903_a(this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, this.field_180240_f) * (float)(k + 1);
                int l = (int)(f1 * 10.0f);
                if (l != this.field_73094_o) {
                    this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, l);
                    this.field_73094_o = l;
                }
            }
        }
    }

    public void func_180784_a(BlockPos pos, EnumFacing side) {
        double reachDist = this.field_73090_b.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((EntityPlayer)this.field_73090_b, (BlockPos)pos, (EnumFacing)side, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.field_73090_b, (double)(reachDist + 1.0)));
        if (event.isCanceled()) {
            this.field_73090_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)this.field_73092_a, pos));
            this.field_73092_a.func_184138_a(pos, this.field_73092_a.func_180495_p(pos), this.field_73092_a.func_180495_p(pos), 3);
            return;
        }
        if (this.func_73083_d()) {
            if (!this.field_73092_a.func_175719_a(null, pos, side)) {
                this.func_180237_b(pos);
            }
        } else {
            if (this.field_73091_c.func_82752_c()) {
                if (this.field_73091_c == GameType.SPECTATOR) {
                    return;
                }
                if (!this.field_73090_b.func_175142_cm()) {
                    ItemStack itemstack = this.field_73090_b.func_184614_ca();
                    if (itemstack.func_190926_b()) {
                        return;
                    }
                    BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)this.field_73092_a, pos, false);
                    if (!itemstack.func_206848_a(this.field_73092_a.func_205772_D(), blockworldstate)) {
                        return;
                    }
                }
            }
            this.field_73089_e = this.field_73100_i;
            float f = 1.0f;
            IBlockState iblockstate = this.field_73092_a.func_180495_p(pos);
            if (!iblockstate.isAir((IBlockReader)this.field_73092_a, pos)) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    iblockstate.func_196942_a(this.field_73092_a, pos, this.field_73090_b);
                    this.field_73092_a.func_175719_a(null, pos, side);
                } else {
                    this.field_73090_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)this.field_73092_a, pos));
                    this.field_73092_a.func_184138_a(pos, this.field_73092_a.func_180495_p(pos), this.field_73092_a.func_180495_p(pos), 3);
                }
                f = iblockstate.func_185903_a(this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, pos);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                if (f >= 1.0f) {
                    this.field_73090_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)this.field_73092_a, pos));
                    this.field_73092_a.func_184138_a(pos, this.field_73092_a.func_180495_p(pos), this.field_73092_a.func_180495_p(pos), 3);
                }
                return;
            }
            if (!iblockstate.isAir((IBlockReader)this.field_73092_a, pos) && f >= 1.0f) {
                this.func_180237_b(pos);
            } else {
                this.field_73088_d = true;
                this.field_180240_f = pos;
                int i = (int)(f * 10.0f);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), pos, i);
                this.field_73090_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)this.field_73092_a, pos));
                this.field_73094_o = i;
            }
        }
    }

    public void func_180785_a(BlockPos pos) {
        if (pos.equals((Object)this.field_180240_f)) {
            int i = this.field_73100_i - this.field_73089_e;
            IBlockState iblockstate = this.field_73092_a.func_180495_p(pos);
            if (!iblockstate.isAir((IBlockReader)this.field_73092_a, pos)) {
                float f = iblockstate.func_185903_a(this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, pos) * (float)(i + 1);
                if (f >= 0.7f) {
                    this.field_73088_d = false;
                    this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), pos, -1);
                    this.func_180237_b(pos);
                } else if (!this.field_73097_j) {
                    this.field_73088_d = false;
                    this.field_73097_j = true;
                    this.field_180241_i = pos;
                    this.field_73093_n = this.field_73089_e;
                }
            }
        }
    }

    public void func_180238_e() {
        this.field_73088_d = false;
        this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
    }

    private boolean func_180235_c(BlockPos pos) {
        return this.removeBlock(pos, false);
    }

    private boolean removeBlock(BlockPos pos, boolean canHarvest) {
        IBlockState iblockstate = this.field_73092_a.func_180495_p(pos);
        boolean flag = iblockstate.removedByPlayer(this.field_73092_a, pos, this.field_73090_b, canHarvest, this.field_73092_a.func_204610_c(pos));
        if (flag) {
            iblockstate.func_177230_c().func_176206_d(this.field_73092_a, pos, iblockstate);
        }
        return flag;
    }

    public boolean func_180237_b(BlockPos pos) {
        IBlockState iblockstate = this.field_73092_a.func_180495_p(pos);
        int exp = ForgeHooks.onBlockBreakEvent((World)this.field_73092_a, (GameType)this.field_73091_c, (EntityPlayerMP)this.field_73090_b, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        TileEntity tileentity = this.field_73092_a.func_175625_s(pos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !this.field_73090_b.func_195070_dx()) {
            this.field_73092_a.func_184138_a(pos, iblockstate, iblockstate, 3);
            return false;
        }
        ItemStack stack = this.field_73090_b.func_184614_ca();
        if (stack.onBlockStartBreak(pos, this.field_73090_b)) {
            return false;
        }
        if (this.field_73091_c.func_82752_c()) {
            if (this.field_73091_c == GameType.SPECTATOR) {
                return false;
            }
            if (!this.field_73090_b.func_175142_cm()) {
                ItemStack itemstack = this.field_73090_b.func_184614_ca();
                if (itemstack.func_190926_b()) {
                    return false;
                }
                BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)this.field_73092_a, pos, false);
                if (!itemstack.func_206848_a(this.field_73092_a.func_205772_D(), blockworldstate)) {
                    return false;
                }
            }
        }
        boolean flag1 = false;
        if (!this.func_73083_d()) {
            ItemStack itemstack2 = this.field_73090_b.func_184614_ca();
            ItemStack copy = itemstack2.func_77946_l();
            boolean flag = iblockstate.canHarvestBlock((IBlockReader)this.field_73092_a, pos, this.field_73090_b);
            itemstack2.func_179548_a(this.field_73092_a, iblockstate, pos, this.field_73090_b);
            if (itemstack2.func_190926_b() && !copy.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.field_73090_b, (ItemStack)copy, (EnumHand)EnumHand.MAIN_HAND);
            }
            if ((flag1 = this.removeBlock(pos, flag)) && flag) {
                ItemStack itemstack1 = itemstack2.func_190926_b() ? ItemStack.field_190927_a : itemstack2.func_77946_l();
                iblockstate.func_177230_c().func_180657_a(this.field_73092_a, this.field_73090_b, pos, iblockstate, tileentity, itemstack1);
            }
        } else {
            flag1 = this.func_180235_c(pos);
        }
        if (!this.func_73083_d() && flag1 && exp > 0) {
            iblockstate.func_177230_c().func_180637_b(this.field_73092_a, pos, exp);
        }
        return flag1;
    }

    public EnumActionResult func_187250_a(EntityPlayer player, World worldIn, ItemStack stack, EnumHand hand) {
        if (this.field_73091_c == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onItemRightClick((EntityPlayer)player, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = stack.func_190916_E();
        int j = stack.func_77952_i();
        ItemStack copyBeforeUse = stack.func_77946_l();
        ActionResult<ItemStack> actionresult = stack.func_77957_a(worldIn, player, hand);
        ItemStack itemstack = actionresult.func_188398_b();
        if (itemstack == stack && itemstack.func_190916_E() == i && itemstack.func_77988_m() <= 0 && itemstack.func_77952_i() == j) {
            return actionresult.func_188397_a();
        }
        if (actionresult.func_188397_a() == EnumActionResult.FAIL && itemstack.func_77988_m() > 0 && !player.func_184587_cr()) {
            return actionresult.func_188397_a();
        }
        player.func_184611_a(hand, itemstack);
        if (this.func_73083_d()) {
            itemstack.func_190920_e(i);
            if (itemstack.func_77984_f()) {
                itemstack.func_196085_b(j);
            }
        }
        if (itemstack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        if (!player.func_184587_cr()) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        return actionresult.func_188397_a();
    }

    public EnumActionResult func_187251_a(EntityPlayer player, World worldIn, ItemStack stack, EnumHand hand, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean flag1;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (this.field_73091_c == GameType.SPECTATOR) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ILockableContainer) {
                Block block = iblockstate.func_177230_c();
                ILockableContainer ilockablecontainer = (ILockableContainer)tileentity;
                if (ilockablecontainer instanceof TileEntityChest && block instanceof BlockChest) {
                    ilockablecontainer = ((BlockChest)((Object)block)).func_196309_a(iblockstate, worldIn, pos, false);
                }
                if (ilockablecontainer != null) {
                    player.func_71007_a((IInventory)ilockablecontainer);
                    return EnumActionResult.SUCCESS;
                }
            } else if (tileentity instanceof IInventory) {
                player.func_71007_a((IInventory)tileentity);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        double reachDist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)pos, (EnumFacing)facing, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)player, (double)(reachDist + 1.0)));
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        EnumActionResult result = EnumActionResult.PASS;
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(new ItemUseContext(player, stack, pos, facing, hitX, hitY, hitZ))) != EnumActionResult.PASS) {
            return result;
        }
        boolean flag = !player.func_184614_ca().doesSneakBypassUse(worldIn, pos, player) || !player.func_184592_cb().doesSneakBypassUse(worldIn, pos, player);
        boolean bl = flag1 = player.func_70093_af() && flag;
        if ((!flag1 || event.getUseBlock() == Event.Result.ALLOW) && event.getUseBlock() != Event.Result.DENY && iblockstate.func_196943_a(worldIn, pos, player, hand, facing, hitX, hitY, hitZ)) {
            result = EnumActionResult.SUCCESS;
        }
        if (!stack.func_190926_b() && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            ItemUseContext itemusecontext = new ItemUseContext(player, player.func_184586_b(hand), pos, facing, hitX, hitY, hitZ);
            if (this.func_73083_d()) {
                int i = stack.func_190916_E();
                if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                    EnumActionResult enumactionresult = stack.func_196084_a(itemusecontext);
                    stack.func_190920_e(i);
                    return enumactionresult;
                }
                return result;
            }
            if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                ItemStack copyBeforeUse = stack.func_77946_l();
                result = stack.func_196084_a(itemusecontext);
                if (stack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
                }
            }
            return result;
        }
        return EnumActionResult.PASS;
    }

    public void func_73080_a(WorldServer serverWorld) {
        this.field_73092_a = serverWorld;
    }
}

