/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackInfo {
    private static final Logger field_195799_a = LogManager.getLogger();
    private static final PackMetadataSection field_212500_b = new PackMetadataSection(new TextComponentTranslation("resourcePack.broken_assets", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}), 4);
    private final String field_195800_b;
    private final Supplier<IResourcePack> field_195801_c;
    private final ITextComponent field_195802_d;
    private final ITextComponent field_195803_e;
    private final PackCompatibility field_195804_f;
    private final Priority field_195805_g;
    private final boolean field_195806_h;
    private final boolean field_195807_i;
    private final boolean hidden;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T extends ResourcePackInfo> T func_195793_a(String p_195793_0_, boolean p_195793_1_, Supplier<IResourcePack> p_195793_2_, IFactory<T> p_195793_3_, Priority p_195793_4_) {
        try (IResourcePack iresourcepack = p_195793_2_.get();){
            PackMetadataSection packmetadatasection = (PackMetadataSection)iresourcepack.func_195760_a(PackMetadataSection.field_198964_a);
            if (p_195793_1_ && packmetadatasection == null) {
                field_195799_a.error("Broken/missing pack.mcmeta detected, fudging it into existance. Please check that your launcher has downloaded all assets for the game correctly!");
                packmetadatasection = field_212500_b;
            }
            if (packmetadatasection != null) {
                T resourcepackinfo;
                T t = resourcepackinfo = p_195793_3_.create(p_195793_0_, p_195793_1_, p_195793_2_, iresourcepack, packmetadatasection, p_195793_4_);
                return t;
            }
            field_195799_a.warn("Couldn't find pack meta for pack {}", (Object)p_195793_0_);
            return (T)((ResourcePackInfo)null);
        }
        catch (IOException ioexception) {
            field_195799_a.warn("Couldn't get pack info for: {}", (Object)ioexception.toString());
        }
        return (T)((ResourcePackInfo)null);
    }

    @Deprecated
    public ResourcePackInfo(String nameIn, boolean p_i47907_2_, Supplier<IResourcePack> resourcePackSupplierIn, ITextComponent p_i47907_4_, ITextComponent p_i47907_5_, PackCompatibility p_i47907_6_, Priority p_i47907_7_, boolean p_i47907_8_) {
        this(nameIn, p_i47907_2_, resourcePackSupplierIn, p_i47907_4_, p_i47907_5_, p_i47907_6_, p_i47907_7_, p_i47907_8_, false);
    }

    public ResourcePackInfo(String nameIn, boolean p_i47907_2_, Supplier<IResourcePack> resourcePackSupplierIn, ITextComponent p_i47907_4_, ITextComponent p_i47907_5_, PackCompatibility p_i47907_6_, Priority p_i47907_7_, boolean p_i47907_8_, boolean hidden) {
        this.field_195800_b = nameIn;
        this.field_195801_c = resourcePackSupplierIn;
        this.field_195802_d = p_i47907_4_;
        this.field_195803_e = p_i47907_5_;
        this.field_195804_f = p_i47907_6_;
        this.field_195806_h = p_i47907_2_;
        this.field_195805_g = p_i47907_7_;
        this.field_195807_i = p_i47907_8_;
        this.hidden = hidden;
    }

    @Deprecated
    public ResourcePackInfo(String p_i47908_1_, boolean p_i47908_2_, Supplier<IResourcePack> p_i47908_3_, IResourcePack p_i47908_4_, PackMetadataSection p_i47908_5_, Priority p_i47908_6_) {
        this(p_i47908_1_, p_i47908_2_, p_i47908_3_, p_i47908_4_, p_i47908_5_, p_i47908_6_, false);
    }

    public ResourcePackInfo(String p_i47908_1_, boolean p_i47908_2_, Supplier<IResourcePack> p_i47908_3_, IResourcePack p_i47908_4_, PackMetadataSection p_i47908_5_, Priority p_i47908_6_, boolean hidden) {
        this(p_i47908_1_, p_i47908_2_, p_i47908_3_, (ITextComponent)new TextComponentString(p_i47908_4_.func_195762_a()), p_i47908_5_.func_198963_a(), PackCompatibility.func_198969_a((int)p_i47908_5_.func_198962_b()), p_i47908_6_, hidden, hidden);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_195789_b() {
        return this.field_195802_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_195795_c() {
        return this.field_195803_e;
    }

    public ITextComponent func_195794_a(boolean p_195794_1_) {
        return TextComponentUtils.func_197676_a((ITextComponent)new TextComponentString(this.field_195800_b)).func_211710_a(p_211689_2_ -> p_211689_2_.func_150238_a(p_195794_1_ ? TextFormatting.GREEN : TextFormatting.RED).func_179989_a(StringArgumentType.escapeIfRequired((String)this.field_195800_b)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentString("").func_150257_a(this.field_195802_d).func_150258_a("\n").func_150257_a(this.field_195803_e))));
    }

    public PackCompatibility func_195791_d() {
        return this.field_195804_f;
    }

    public IResourcePack func_195796_e() {
        return this.field_195801_c.get();
    }

    public String func_195790_f() {
        return this.field_195800_b;
    }

    public boolean func_195797_g() {
        return this.field_195806_h;
    }

    public boolean func_195798_h() {
        return this.field_195807_i;
    }

    public Priority func_195792_i() {
        return this.field_195805_g;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourcePackInfo)) {
            return false;
        }
        ResourcePackInfo resourcepackinfo = (ResourcePackInfo)p_equals_1_;
        return this.field_195800_b.equals(resourcepackinfo.field_195800_b);
    }

    public int hashCode() {
        return this.field_195800_b.hashCode();
    }

    public static enum Priority {
        TOP,
        BOTTOM;


        public <T, P extends ResourcePackInfo> int func_198993_a(List<T> p_198993_1_, T p_198993_2_, Function<T, P> p_198993_3_, boolean p_198993_4_) {
            ResourcePackInfo p;
            int i;
            Priority resourcepackinfo$priority;
            Priority priority = resourcepackinfo$priority = p_198993_4_ ? this.func_198992_a() : this;
            if (resourcepackinfo$priority == BOTTOM) {
                ResourcePackInfo p1;
                int j;
                for (j = 0; j < p_198993_1_.size() && (p1 = (ResourcePackInfo)p_198993_3_.apply(p_198993_1_.get(j))).func_195798_h() && p1.func_195792_i() == this; ++j) {
                }
                p_198993_1_.add(j, p_198993_2_);
                return j;
            }
            for (i = p_198993_1_.size() - 1; i >= 0 && (p = (ResourcePackInfo)p_198993_3_.apply(p_198993_1_.get(i))).func_195798_h() && p.func_195792_i() == this; --i) {
            }
            p_198993_1_.add(i + 1, p_198993_2_);
            return i + 1;
        }

        public Priority func_198992_a() {
            return this == TOP ? BOTTOM : TOP;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends ResourcePackInfo> {
        @Nullable
        public T create(String var1, boolean var2, Supplier<IResourcePack> var3, IResourcePack var4, PackMetadataSection var5, Priority var6);
    }
}

