/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Type;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import net.minecraft.network.status.server.SPacketServerInfo;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.FMLStatusPing;

public class ServerStatusResponse {
    private ITextComponent field_151326_a;
    private Players field_151324_b;
    private Version field_151325_c;
    private String field_151323_d;
    private transient FMLStatusPing forgeData;
    private Semaphore mutex = new Semaphore(1);
    private String json = null;

    public FMLStatusPing getForgeData() {
        return this.forgeData;
    }

    public void setForgeData(FMLStatusPing data) {
        this.forgeData = data;
        this.invalidateJson();
    }

    public ITextComponent func_151317_a() {
        return this.field_151326_a;
    }

    public void func_151315_a(ITextComponent descriptionIn) {
        this.field_151326_a = descriptionIn;
        this.invalidateJson();
    }

    public Players func_151318_b() {
        return this.field_151324_b;
    }

    public void func_151319_a(Players playersIn) {
        this.field_151324_b = playersIn;
        this.invalidateJson();
    }

    public Version func_151322_c() {
        return this.field_151325_c;
    }

    public void func_151321_a(Version versionIn) {
        this.field_151325_c = versionIn;
        this.invalidateJson();
    }

    public void func_151320_a(String faviconBlob) {
        this.field_151323_d = faviconBlob;
        this.invalidateJson();
    }

    public String func_151316_d() {
        return this.field_151323_d;
    }

    public String getJson() {
        String ret = this.json;
        if (ret == null) {
            this.mutex.acquireUninterruptibly();
            ret = this.json;
            if (ret == null) {
                this.json = ret = SPacketServerInfo.field_149297_a.toJson((Object)this);
            }
            this.mutex.release();
        }
        return ret;
    }

    public void invalidateJson() {
        this.json = null;
    }

    public static class Version {
        private final String field_151306_a;
        private final int field_151305_b;

        public Version(String nameIn, int protocolIn) {
            this.field_151306_a = nameIn;
            this.field_151305_b = protocolIn;
        }

        public String func_151303_a() {
            return this.field_151306_a;
        }

        public int func_151304_b() {
            return this.field_151305_b;
        }

        public static class Serializer
        implements JsonDeserializer<Version>,
        JsonSerializer<Version> {
            public Version deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
                JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"version");
                return new Version(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name"), JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"protocol"));
            }

            public JsonElement serialize(Version p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("name", p_serialize_1_.func_151303_a());
                jsonobject.addProperty("protocol", (Number)p_serialize_1_.func_151304_b());
                return jsonobject;
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<ServerStatusResponse>,
    JsonSerializer<ServerStatusResponse> {
        public ServerStatusResponse deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"status");
            ServerStatusResponse serverstatusresponse = new ServerStatusResponse();
            if (jsonobject.has("description")) {
                serverstatusresponse.func_151315_a((ITextComponent)p_deserialize_3_.deserialize(jsonobject.get("description"), ITextComponent.class));
            }
            if (jsonobject.has("players")) {
                serverstatusresponse.func_151319_a((Players)p_deserialize_3_.deserialize(jsonobject.get("players"), Players.class));
            }
            if (jsonobject.has("version")) {
                serverstatusresponse.func_151321_a((Version)p_deserialize_3_.deserialize(jsonobject.get("version"), Version.class));
            }
            if (jsonobject.has("favicon")) {
                serverstatusresponse.func_151320_a(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"favicon"));
            }
            if (jsonobject.has("forgeData")) {
                serverstatusresponse.setForgeData(FMLStatusPing.Serializer.deserialize((JsonObject)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"forgeData"), (JsonDeserializationContext)p_deserialize_3_));
            }
            return serverstatusresponse;
        }

        public JsonElement serialize(ServerStatusResponse p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.func_151317_a() != null) {
                jsonobject.add("description", p_serialize_3_.serialize((Object)p_serialize_1_.func_151317_a()));
            }
            if (p_serialize_1_.func_151318_b() != null) {
                jsonobject.add("players", p_serialize_3_.serialize((Object)p_serialize_1_.func_151318_b()));
            }
            if (p_serialize_1_.func_151322_c() != null) {
                jsonobject.add("version", p_serialize_3_.serialize((Object)p_serialize_1_.func_151322_c()));
            }
            if (p_serialize_1_.func_151316_d() != null) {
                jsonobject.addProperty("favicon", p_serialize_1_.func_151316_d());
            }
            if (p_serialize_1_.getForgeData() != null) {
                jsonobject.add("forgeData", (JsonElement)FMLStatusPing.Serializer.serialize((FMLStatusPing)p_serialize_1_.getForgeData(), (JsonSerializationContext)p_serialize_3_));
            }
            return jsonobject;
        }
    }

    public static class Players {
        private final int field_151336_a;
        private final int field_151334_b;
        private GameProfile[] field_151335_c;

        public Players(int maxOnlinePlayers, int onlinePlayers) {
            this.field_151336_a = maxOnlinePlayers;
            this.field_151334_b = onlinePlayers;
        }

        public int func_151332_a() {
            return this.field_151336_a;
        }

        public int func_151333_b() {
            return this.field_151334_b;
        }

        public GameProfile[] func_151331_c() {
            return this.field_151335_c;
        }

        public void func_151330_a(GameProfile[] playersIn) {
            this.field_151335_c = playersIn;
        }

        public static class Serializer
        implements JsonDeserializer<Players>,
        JsonSerializer<Players> {
            public Players deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
                JsonArray jsonarray;
                JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"players");
                Players serverstatusresponse$players = new Players(JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"max"), JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"online"));
                if (JsonUtils.func_151202_d((JsonObject)jsonobject, (String)"sample") && (jsonarray = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"sample")).size() > 0) {
                    GameProfile[] agameprofile = new GameProfile[jsonarray.size()];
                    for (int i = 0; i < agameprofile.length; ++i) {
                        JsonObject jsonobject1 = JsonUtils.func_151210_l((JsonElement)jsonarray.get(i), (String)("player[" + i + "]"));
                        String s = JsonUtils.func_151200_h((JsonObject)jsonobject1, (String)"id");
                        agameprofile[i] = new GameProfile(UUID.fromString(s), JsonUtils.func_151200_h((JsonObject)jsonobject1, (String)"name"));
                    }
                    serverstatusresponse$players.func_151330_a(agameprofile);
                }
                return serverstatusresponse$players;
            }

            public JsonElement serialize(Players p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("max", (Number)p_serialize_1_.func_151332_a());
                jsonobject.addProperty("online", (Number)p_serialize_1_.func_151333_b());
                if (p_serialize_1_.func_151331_c() != null && p_serialize_1_.func_151331_c().length > 0) {
                    JsonArray jsonarray = new JsonArray();
                    for (int i = 0; i < p_serialize_1_.func_151331_c().length; ++i) {
                        JsonObject jsonobject1 = new JsonObject();
                        UUID uuid = p_serialize_1_.func_151331_c()[i].getId();
                        jsonobject1.addProperty("id", uuid == null ? "" : uuid.toString());
                        jsonobject1.addProperty("name", p_serialize_1_.func_151331_c()[i].getName());
                        jsonarray.add((JsonElement)jsonobject1);
                    }
                    jsonobject.add("sample", (JsonElement)jsonarray);
                }
                return jsonobject;
            }
        }
    }
}

