/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.extensions.ForgeRecipeManager;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManager
extends ForgeRecipeManager {
    private static final Logger field_199521_c = LogManager.getLogger();
    public static final int field_199519_a = "recipes/".length();
    public static final int field_199520_b = ".json".length();
    private final Map<ResourceLocation, IRecipe> field_199522_d = Maps.newHashMap();
    private boolean field_199523_e;

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        this.field_199523_e = false;
        this.field_199522_d.clear();
        super.func_195410_a(resourceManager);
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("recipes", p_199516_0_ -> p_199516_0_.endsWith(".json") && !p_199516_0_.startsWith("_"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(field_199519_a, s.length() - field_199520_b));
            try {
                IResource iresource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    JsonObject jsonobject = (JsonObject)JsonUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (jsonobject == null) {
                        field_199521_c.error("Couldn't load recipe {} as it's null or empty", (Object)resourcelocation1);
                        continue;
                    }
                    if (jsonobject.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"conditions"))) {
                        field_199521_c.info("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation1);
                        continue;
                    }
                    this.func_199509_a(RecipeSerializers.func_199572_a(resourcelocation1, jsonobject));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_199521_c.error("Parsing error loading recipe {}", (Object)resourcelocation1, (Object)jsonparseexception);
                this.field_199523_e = true;
            }
            catch (IOException ioexception) {
                field_199521_c.error("Couldn't read custom advancement {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)ioexception);
                this.field_199523_e = true;
            }
        }
        field_199521_c.info("Loaded {} recipes", (Object)this.field_199522_d.size());
    }

    public void func_199509_a(IRecipe recipe) {
        if (this.field_199522_d.containsKey(recipe.func_199560_c())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + recipe.func_199560_c());
        }
        this.field_199522_d.put(recipe.func_199560_c(), recipe);
        if (!recipe.getType().getBaseClass().isAssignableFrom(recipe.getClass())) {
            throw new IllegalStateException(String.format("Recipe type %s is not valid for class %s", recipe.getType().getBaseClass().getName(), recipe.getClass().getName()));
        }
        this.getRecipes(recipe.getType()).add(recipe);
    }

    @Deprecated
    public ItemStack func_199514_a(IInventory input, World worldIn) {
        for (IRecipe irecipe : this.field_199522_d.values()) {
            if (!irecipe.func_77569_a(input, worldIn)) continue;
            return irecipe.func_77572_b(input);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    @Deprecated
    public IRecipe func_199515_b(IInventory input, World worldIn) {
        for (IRecipe irecipe : this.field_199522_d.values()) {
            if (!irecipe.func_77569_a(input, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    @Deprecated
    public NonNullList<ItemStack> func_199513_c(IInventory input, World worldIn) {
        for (IRecipe irecipe : this.field_199522_d.values()) {
            if (!irecipe.func_77569_a(input, worldIn)) continue;
            return irecipe.func_179532_b(input);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)input.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)input.func_70301_a(i));
        }
        return nonnulllist;
    }

    @Nullable
    public IRecipe func_199517_a(ResourceLocation id) {
        return this.field_199522_d.get(id);
    }

    public Collection<IRecipe> func_199510_b() {
        return this.field_199522_d.values();
    }

    public Collection<ResourceLocation> func_199511_c() {
        return this.field_199522_d.keySet();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_199518_d() {
        this.field_199522_d.clear();
        this.sortedRecipes.clear();
    }
}

