/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLlamaSpit
extends Entity
implements IProjectile {
    public EntityLlama field_190539_a;
    private NBTTagCompound field_190540_b;

    public EntityLlamaSpit(World worldIn) {
        super(EntityType.field_200770_J, worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityLlamaSpit(World worldIn, EntityLlama p_i47273_2_) {
        this(worldIn);
        this.field_190539_a = p_i47273_2_;
        this.func_70107_b(p_i47273_2_.field_70165_t - (double)(p_i47273_2_.field_70130_N + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(p_i47273_2_.field_70761_aq * ((float)Math.PI / 180))), p_i47273_2_.field_70163_u + (double)p_i47273_2_.func_70047_e() - (double)0.1f, p_i47273_2_.field_70161_v + (double)(p_i47273_2_.field_70130_N + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(p_i47273_2_.field_70761_aq * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityLlamaSpit(World worldIn, double x, double y, double z, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.func_195594_a((IParticleData)Particles.field_197602_M, x, y, z, p_i47274_8_ * d0, p_i47274_10_, p_i47274_12_ * d0);
        }
        this.field_70159_w = p_i47274_8_;
        this.field_70181_x = p_i47274_10_;
        this.field_70179_y = p_i47274_12_;
    }

    @Override
    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        if (this.field_190540_b != null) {
            this.func_190537_j();
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.func_190538_a(vec3d, vec3d1)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.func_190536_a(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = 0.06f;
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.99f;
            this.field_70179_y *= (double)0.99f;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.06f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Nullable
    private Entity func_190538_a(Vec3d p_190538_1_, Vec3d p_190538_2_) {
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (entity1 == this.field_190539_a || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(p_190538_1_, p_190538_2_)) == null || !((d1 = p_190538_1_.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_190536_a(RayTraceResult p_190536_1_) {
        if (p_190536_1_.field_72308_g != null && this.field_190539_a != null) {
            p_190536_1_.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_190539_a).func_76349_b(), 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.field_190540_b = compound.func_74775_l("Owner");
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        if (this.field_190539_a != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            UUID uuid = this.field_190539_a.func_110124_au();
            nbttagcompound.func_186854_a("OwnerUUID", uuid);
            compound.func_74782_a("Owner", nbttagcompound);
        }
    }

    private void func_190537_j() {
        if (this.field_190540_b != null && this.field_190540_b.func_186855_b("OwnerUUID")) {
            UUID uuid = this.field_190540_b.func_186857_a("OwnerUUID");
            for (EntityLlama entityllama : this.field_70170_p.func_72872_a(EntityLlama.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!entityllama.func_110124_au().equals(uuid)) continue;
                this.field_190539_a = entityllama;
                break;
            }
        }
        this.field_190540_b = null;
    }
}

