/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHorse
extends AbstractHorse {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(EntityHorse.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184791_bI = EntityDataManager.func_187226_a(EntityHorse.class, DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> HORSE_ARMOR_STACK = EntityDataManager.func_187226_a(EntityHorse.class, DataSerializers.field_187196_f);
    private static final String[] field_110268_bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] field_110291_bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private String field_110286_bQ;
    private final String[] field_110280_bR = new String[3];

    public EntityHorse(World worldIn) {
        super(EntityType.field_200762_B, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
        this.field_70180_af.func_187214_a(field_184791_bI, HorseArmorType.NONE.func_188579_a());
        this.field_70180_af.func_187214_a(HORSE_ARMOR_STACK, ItemStack.field_190927_a);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.func_110202_bQ());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_74782_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.func_110235_q(compound.func_74762_e("Variant"));
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = ItemStack.func_199557_a(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_110232_cE();
    }

    public void func_110235_q(int variant) {
        this.field_70180_af.func_187227_b(field_184789_bG, variant);
        this.func_110230_cF();
    }

    public int func_110202_bQ() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_110247_cG() {
        int i = this.func_110202_bQ();
        int j = (i & 0xFF) % 7;
        int k = ((i & 0xFF00) >> 8) % 5;
        HorseArmorType horsearmortype = this.func_184783_dl();
        this.field_110280_bR[0] = field_110268_bz[j];
        this.field_110280_bR[1] = field_110291_bB[k];
        this.field_110280_bR[2] = horsearmortype.func_188574_d();
        this.field_110286_bQ = "horse/" + field_110269_bA[j] + field_110292_bC[k] + horsearmortype.func_188573_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_110264_co() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110286_bQ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String[] func_110212_cp() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110280_bR;
    }

    @Override
    protected void func_110232_cE() {
        super.func_110232_cE();
        this.func_146086_d(this.field_110296_bG.func_70301_a(1));
    }

    public void func_146086_d(ItemStack itemStackIn) {
        HorseArmorType horsearmortype = HorseArmorType.func_188580_a(itemStackIn);
        this.field_70180_af.func_187227_b(field_184791_bI, horsearmortype.func_188579_a());
        this.field_70180_af.func_187227_b(HORSE_ARMOR_STACK, itemStackIn);
        this.func_110230_cF();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(field_184786_bD);
            int i = horsearmortype.func_188578_c();
            if (i != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)i, 0).func_111168_a(false));
            }
        }
    }

    public HorseArmorType func_184783_dl() {
        ItemStack stack = this.field_70180_af.func_187225_a(HORSE_ARMOR_STACK);
        if (!stack.func_190926_b()) {
            return stack.getHorseArmorType();
        }
        return HorseArmorType.func_188575_a(this.field_70180_af.func_187225_a(field_184791_bI));
    }

    @Override
    public void func_76316_a(IInventory invBasic) {
        HorseArmorType horsearmortype = this.func_184783_dl();
        super.func_76316_a(invBasic);
        HorseArmorType horsearmortype1 = this.func_184783_dl();
        if (this.field_70173_aa > 20 && horsearmortype != horsearmortype1 && horsearmortype1 != HorseArmorType.NONE) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType p_190680_1_) {
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110267_cL());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    @Override
    public void func_70071_h_() {
        ItemStack stack;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.func_110230_cF();
        }
        if (this.func_190682_f(stack = this.field_110296_bG.func_70301_a(1))) {
            stack.onHorseArmorTick(this.field_70170_p, (EntityLiving)((Object)this));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186396_D;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b();
        if (flag && itemstack.func_77973_b() instanceof ItemSpawnEgg) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (flag) {
            boolean flag2;
            if (this.func_190678_b(player, itemstack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (EntityLivingBase)((Object)this), hand)) {
                return true;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return true;
            }
            boolean flag1 = HorseArmorType.func_188580_a(itemstack) != HorseArmorType.NONE;
            boolean bl2 = flag2 = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            if (flag1 || flag2) {
                this.func_110199_f(player);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        this.func_110237_h(player);
        return true;
    }

    @Override
    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityDonkey) && !(otherAnimal instanceof EntityHorse)) {
            return false;
        }
        return this.func_110200_cJ() && ((AbstractHorse)otherAnimal).func_110200_cJ();
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        Object abstracthorse;
        if (ageable instanceof EntityDonkey) {
            abstracthorse = new EntityMule(this.field_70170_p);
        } else {
            EntityHorse entityhorse = (EntityHorse)ageable;
            abstracthorse = new EntityHorse(this.field_70170_p);
            int j = this.field_70146_Z.nextInt(9);
            int i = j < 4 ? this.func_110202_bQ() & 0xFF : (j < 8 ? entityhorse.func_110202_bQ() & 0xFF : this.field_70146_Z.nextInt(7));
            int k = this.field_70146_Z.nextInt(5);
            i = k < 2 ? (i |= this.func_110202_bQ() & 0xFF00) : (k < 4 ? (i |= entityhorse.func_110202_bQ() & 0xFF00) : (i |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            ((EntityHorse)((Object)abstracthorse)).func_110235_q(i);
        }
        this.func_190681_a(ageable, (AbstractHorse)((Object)abstracthorse));
        return abstracthorse;
    }

    @Override
    public boolean func_190677_dK() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack stack) {
        return HorseArmorType.isHorseArmor(stack);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        int i;
        if ((entityLivingData = super.func_204210_a(difficulty, entityLivingData, itemNbt)) instanceof GroupData) {
            i = ((GroupData)entityLivingData).field_190885_a;
        } else {
            i = this.field_70146_Z.nextInt(7);
            entityLivingData = new GroupData(i);
        }
        this.func_110235_q(i | this.field_70146_Z.nextInt(5) << 8);
        return entityLivingData;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_190885_a;

        public GroupData(int variantIn) {
            this.field_190885_a = variantIn;
        }
    }
}

