/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityZombieVillager
extends EntityZombie {
    private static final DataParameter<Boolean> field_184739_bx = EntityDataManager.func_187226_a(EntityZombieVillager.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_190739_c = EntityDataManager.func_187226_a(EntityZombieVillager.class, DataSerializers.field_187192_b);
    private int field_82234_d;
    private UUID field_191992_by;
    @Nullable
    private VillagerRegistry.VillagerProfession prof;

    public EntityZombieVillager(World worldIn) {
        super(EntityType.field_200727_aF, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184739_bx, false);
        this.field_70180_af.func_187214_a(field_190739_c, 0);
    }

    public void func_190733_a(int profession) {
        this.field_70180_af.func_187227_b(field_190739_c, profession);
        VillagerRegistry.onSetProfession((EntityZombieVillager)this, (int)profession);
    }

    @Deprecated
    public int func_190736_dl() {
        return Math.max(this.field_70180_af.func_187225_a(field_190739_c), 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Profession", this.func_190736_dl());
        compound.func_74778_a("ProfessionName", this.getProfessionForge().getRegistryName().toString());
        compound.func_74768_a("ConversionTime", this.func_82230_o() ? this.field_82234_d : -1);
        if (this.field_191992_by != null) {
            compound.func_186854_a("ConversionPlayer", this.field_191992_by);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_190733_a(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = (VillagerRegistry.VillagerProfession)VillagerRegistry.FARMER.orElseThrow(() -> new IllegalStateException("Farmer profession not initialized?"));
            }
            this.setProfession(p);
        }
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.func_191991_a(compound.func_186855_b("ConversionPlayer") ? compound.func_186857_a("ConversionPlayer") : null, compound.func_74762_e("ConversionTime"));
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        VillagerRegistry.setRandomProfession((EntityZombieVillager)this, (Random)this.field_70170_p.field_73012_v);
        return super.func_204210_a(difficulty, entityLivingData, itemNbt);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_82230_o()) {
            int i = this.func_190735_dq();
            this.field_82234_d -= i;
            if (this.field_82234_d <= 0) {
                this.func_190738_dp();
            }
        }
        super.func_70071_h_();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151153_ao && this.func_70644_a(MobEffects.field_76437_t)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_191991_a(player.func_110124_au(), this.field_70146_Z.nextInt(2401) + 3600);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    public boolean func_70692_ba() {
        return !this.func_82230_o();
    }

    public boolean func_82230_o() {
        return this.func_184212_Q().func_187225_a(field_184739_bx);
    }

    protected void func_191991_a(@Nullable UUID conversionStarterIn, int conversionTimeIn) {
        this.field_191992_by = conversionStarterIn;
        this.field_82234_d = conversionTimeIn;
        this.func_184212_Q().func_187227_b(field_184739_bx, true);
        this.func_195063_d(MobEffects.field_76437_t);
        this.func_195064_c(new PotionEffect(MobEffects.field_76420_g, conversionTimeIn, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_190738_dp() {
        EntityPlayer entityplayer;
        EntityVillager entityvillager = new EntityVillager(this.field_70170_p);
        entityvillager.func_82149_j((Entity)((Object)this));
        entityvillager.setProfession(this.getProfessionForge());
        entityvillager.func_190672_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)entityvillager))), null, null, false);
        entityvillager.func_82187_q();
        if (this.func_70631_g_()) {
            entityvillager.func_70873_a(-24000);
        }
        this.field_70170_p.func_72900_e((Entity)((Object)this));
        entityvillager.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            entityvillager.func_200203_b(this.func_200201_e());
            entityvillager.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d((Entity)((Object)entityvillager));
        if (this.field_191992_by != null && (entityplayer = this.field_70170_p.func_152378_a(this.field_191992_by)) instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192137_q.func_192183_a((EntityPlayerMP)entityplayer, (EntityZombie)this, entityvillager);
        }
        entityvillager.func_195064_c(new PotionEffect(MobEffects.field_76431_k, 200, 0));
        this.field_70170_p.func_180498_a(null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected int func_190735_dq() {
        int i = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.field_70165_t - 4; k < (int)this.field_70165_t + 4 && j < 14; ++k) {
                for (int l = (int)this.field_70163_u - 4; l < (int)this.field_70163_u + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.field_70161_v - 4; i1 < (int)this.field_70161_v + 4 && j < 14; ++i1) {
                        Block block = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (block != Blocks.field_150411_aY && !(block instanceof BlockBed)) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent func_184639_G() {
        return SoundEvents.field_187940_hn;
    }

    @Override
    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187944_hr;
    }

    @Override
    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187943_hq;
    }

    @Override
    public SoundEvent func_190731_di() {
        return SoundEvents.field_187946_ht;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191183_as;
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        this.prof = prof;
        this.func_190733_a(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof));
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            this.prof = VillagerRegistry.getById((int)this.func_190736_dl());
            if (this.prof == null) {
                return (VillagerRegistry.VillagerProfession)VillagerRegistry.FARMER.orElseThrow(() -> new IllegalStateException("Farmer profession not initialized?"));
            }
        }
        return this.prof;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(field_190739_c)) {
            VillagerRegistry.onSetProfession((EntityZombieVillager)this, (int)this.field_70180_af.func_187225_a(field_190739_c));
        }
    }
}

