/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySnowman
extends EntityGolem
implements IRangedAttackMob,
IShearable {
    private static final DataParameter<Byte> field_184749_a = EntityDataManager.func_187226_a(EntitySnowman.class, DataSerializers.field_187191_a);

    public EntitySnowman(World worldIn) {
        super(EntityType.field_200745_ak, worldIn);
        this.func_70105_a(0.7f, 1.9f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, IMob.field_82192_a));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184749_a, (byte)16);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pumpkin", this.func_184748_o());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin")) {
            this.func_184747_a(compound.func_74767_n("Pumpkin"));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.func_203008_ap()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this))) {
                return;
            }
            IBlockState iblockstate = Blocks.field_150433_aE.func_176223_P();
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.field_70170_p.func_180495_p(blockpos).func_196958_f() || !(this.field_70170_p.func_180494_b(blockpos).func_180626_a(blockpos) < 0.8f) || !iblockstate.func_196955_c(this.field_70170_p, blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, iblockstate);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186444_z;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntitySnowball entitysnowball = new EntitySnowball(this.field_70170_p, (EntityLivingBase)((Object)this));
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = d0 - entitysnowball.field_70163_u;
        double d3 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
    }

    public float func_70047_e() {
        return 1.7f;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        return super.func_184645_a(player, hand);
    }

    public boolean func_184748_o() {
        return (this.field_70180_af.func_187225_a(field_184749_a) & 0x10) != 0;
    }

    public void func_184747_a(boolean pumpkinEquipped) {
        byte b0 = this.field_70180_af.func_187225_a(field_184749_a);
        if (pumpkinEquipped) {
            this.field_70180_af.func_187227_b(field_184749_a, (byte)(b0 | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184749_a, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187803_fD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187801_fC;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return this.func_184748_o();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.func_184747_a(false);
        return new ArrayList<ItemStack>();
    }
}

