/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySlime
extends EntityLiving
implements IMob {
    private static final DataParameter<Integer> field_184711_bt = EntityDataManager.func_187226_a(EntitySlime.class, DataSerializers.field_187192_b);
    public float field_70813_a;
    public float field_70811_b;
    public float field_70812_c;
    private boolean field_175452_bi;

    protected EntitySlime(EntityType<?> p_i48552_1_, World p_i48552_2_) {
        super(p_i48552_1_, p_i48552_2_);
        this.field_70765_h = new SlimeMoveHelper(this);
    }

    public EntitySlime(World worldIn) {
        this(EntityType.field_200743_ai, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntityIronGolem.class));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184711_bt, 1);
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(field_184711_bt, size);
        this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
    }

    public int func_70809_q() {
        return this.field_70180_af.func_187225_a(field_184711_bt);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Size", this.func_70809_q() - 1);
        compound.func_74757_a("wasOnGround", this.field_175452_bi);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.func_70799_a(i + 1, false);
        this.field_175452_bi = compound.func_74767_n("wasOnGround");
    }

    public boolean func_189101_db() {
        return this.func_70809_q() <= 1;
    }

    protected IParticleData func_195404_m() {
        return Particles.field_197592_C;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70809_q() > 0) {
            this.func_70106_y();
        }
        this.field_70811_b += (this.field_70813_a - this.field_70811_b) * 0.5f;
        this.field_70812_c = this.field_70811_b;
        super.func_70071_h_();
        if (this.field_70122_E && !this.field_175452_bi) {
            int i = this.func_70809_q();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                IParticleData iparticledata = this.func_195404_m();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_195594_a(iparticledata, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.field_70813_a = -0.5f;
        } else if (!this.field_70122_E && this.field_175452_bi) {
            this.field_70813_a = 1.0f;
        }
        this.field_175452_bi = this.field_70122_E;
        this.func_70808_l();
    }

    protected void func_70808_l() {
        this.field_70813_a *= 0.6f;
    }

    protected int func_70806_k() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184711_bt.equals(key)) {
            int i = this.func_70809_q();
            this.func_70105_a(0.51000005f * (float)i, 0.51000005f * (float)i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public EntityType<? extends EntitySlime> func_200600_R() {
        return super.func_200600_R();
    }

    @Override
    public void func_70106_y() {
        int i = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlime entityslime = this.func_200600_R().func_200721_a(this.field_70170_p);
                if (this.func_145818_k_()) {
                    entityslime.func_200203_b(this.func_200201_e());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.func_70799_a(i / 2, true);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d(entityslime);
            }
        }
        super.func_70106_y();
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof EntityIronGolem && this.func_70800_m()) {
            this.func_175451_e((EntityLivingBase)entityIn);
        }
    }

    @Override
    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.func_70800_m()) {
            this.func_175451_e(entityIn);
        }
    }

    protected void func_175451_e(EntityLivingBase entityIn) {
        int i = this.func_70809_q();
        if (this.func_70685_l(entityIn) && this.func_70068_e(entityIn) < 0.6 * (double)i * 0.6 * (double)i && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_70805_n())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a(this, entityIn);
        }
    }

    @Override
    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected boolean func_70800_m() {
        return !this.func_189101_db() && this.func_70613_aW();
    }

    protected int func_70805_n() {
        return this.func_70809_q();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_189101_db() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_189101_db() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    @Override
    protected Item func_146068_u() {
        return this.func_70809_q() == 1 ? Items.field_151123_aH : null;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.func_70809_q() == 1 ? LootTableList.field_186378_ac : LootTableList.field_186419_a;
    }

    @Override
    public boolean func_205020_a(IWorld worldIn, boolean p_205020_2_) {
        BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (worldIn.func_72912_H().func_76067_t().handleSlimeSpawnReduction(this.field_70146_Z, this.field_70170_p)) {
            return false;
        }
        if (worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            boolean flag;
            Biome biome = worldIn.func_180494_b(blockpos);
            if (biome == Biomes.field_76780_h && this.field_70163_u > 50.0 && this.field_70163_u < 70.0 && this.field_70146_Z.nextFloat() < 0.5f && this.field_70146_Z.nextFloat() < worldIn.func_130001_d() && worldIn.func_201696_r(new BlockPos((Entity)this)) <= this.field_70146_Z.nextInt(8)) {
                return super.func_205020_a(worldIn, p_205020_2_);
            }
            ChunkPos chunkpos = new ChunkPos(blockpos);
            boolean bl = flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)worldIn.func_72905_C(), (long)987234911L).nextInt(10) == 0;
            if (this.field_70146_Z.nextInt(10) == 0 && flag && this.field_70163_u < 40.0) {
                return super.func_205020_a(worldIn, p_205020_2_);
            }
        }
        return false;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f * (float)this.func_70809_q();
    }

    @Override
    public int func_70646_bf() {
        return 0;
    }

    protected boolean func_70807_r() {
        return this.func_70809_q() > 0;
    }

    @Override
    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.func_70799_a(j, true);
        return super.func_204210_a(difficulty, entityLivingData, itemNbt);
    }

    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float field_179922_g;
        private int field_179924_h;
        private final EntitySlime field_179925_i;
        private boolean field_179923_j;

        public SlimeMoveHelper(EntitySlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.field_179925_i = slimeIn;
            this.field_179922_g = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void func_179920_a(float p_179920_1_, boolean p_179920_2_) {
            this.field_179922_g = p_179920_1_;
            this.field_179923_j = p_179920_2_;
        }

        public void func_179921_a(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.field_179922_g, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.field_179924_h-- <= 0) {
                        this.field_179924_h = this.field_179925_i.func_70806_k();
                        if (this.field_179923_j) {
                            this.field_179924_h /= 3;
                        }
                        this.field_179925_i.func_70683_ar().func_75660_a();
                        if (this.field_179925_i.func_70807_r()) {
                            this.field_179925_i.func_184185_a(this.field_179925_i.func_184710_cZ(), this.field_179925_i.func_70599_aP(), ((this.field_179925_i.func_70681_au().nextFloat() - this.field_179925_i.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.field_179925_i.field_70702_br = 0.0f;
                        this.field_179925_i.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final EntitySlime field_179458_a;

        public AISlimeHop(EntitySlime slimeIn) {
            this.field_179458_a = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.field_179458_a.func_70605_aq()).func_179921_a(1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final EntitySlime field_179457_a;

        public AISlimeFloat(EntitySlime slimeIn) {
            this.field_179457_a = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_212239_d(true);
        }

        public boolean func_75250_a() {
            return this.field_179457_a.func_70090_H() || this.field_179457_a.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.field_179457_a.func_70681_au().nextFloat() < 0.8f) {
                this.field_179457_a.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.field_179457_a.func_70605_aq()).func_179921_a(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private final EntitySlime field_179461_a;
        private float field_179459_b;
        private int field_179460_c;

        public AISlimeFaceRandom(EntitySlime slimeIn) {
            this.field_179461_a = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.field_179461_a.func_70638_az() == null && (this.field_179461_a.field_70122_E || this.field_179461_a.func_70090_H() || this.field_179461_a.func_180799_ab() || this.field_179461_a.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.field_179460_c <= 0) {
                this.field_179460_c = 40 + this.field_179461_a.func_70681_au().nextInt(60);
                this.field_179459_b = this.field_179461_a.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.field_179461_a.func_70605_aq()).func_179920_a(this.field_179459_b, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final EntitySlime field_179466_a;
        private int field_179465_b;

        public AISlimeAttack(EntitySlime slimeIn) {
            this.field_179466_a = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.field_179466_a.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.field_179465_b = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.field_179466_a.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.field_179465_b > 0;
        }

        public void func_75246_d() {
            this.field_179466_a.func_70625_a(this.field_179466_a.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.field_179466_a.func_70605_aq()).func_179920_a(this.field_179466_a.field_70177_z, this.field_179466_a.func_70800_m());
        }
    }
}

