/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityShulker
extends EntityGolem
implements IMob {
    private static final UUID field_184703_bv = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier field_184704_bw = new AttributeModifier(field_184703_bv, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    protected static final DataParameter<EnumFacing> field_184700_a = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> field_184701_b = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> field_184702_c = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_190770_bw = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187191_a);
    private float field_184705_bx;
    private float field_184706_by;
    private BlockPos field_184707_bz;
    private int field_184708_bA;

    public EntityShulker(World worldIn) {
        super(EntityType.field_200738_ad, worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70178_ae = true;
        this.field_184707_bz = null;
        this.field_70728_aV = 5;
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        return super.func_204210_a(difficulty, entityLivingData, itemNbt);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIPeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIAttackNearest(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIDefenseAttack(this));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    public void func_70642_aH() {
        if (!this.func_184686_df()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_184686_df() ? SoundEvents.field_187785_eU : SoundEvents.field_187783_eT;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184700_a, EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(field_184701_b, Optional.empty());
        this.field_70180_af.func_187214_a(field_184702_c, (byte)0);
        this.field_70180_af.func_187214_a(field_190770_bw, (byte)16);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper((EntityLivingBase)((Object)this));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(field_184700_a, EnumFacing.func_82600_a(compound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(field_184702_c, compound.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(field_190770_bw, compound.func_74771_c("Color"));
        if (compound.func_74764_b("APX")) {
            int i = compound.func_74762_e("APX");
            int j = compound.func_74762_e("APY");
            int k = compound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(field_184701_b, Optional.empty());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("AttachFace", (byte)this.field_70180_af.func_187225_a(field_184700_a).func_176745_a());
        compound.func_74774_a("Peek", this.field_70180_af.func_187225_a(field_184702_c));
        compound.func_74774_a("Color", this.field_70180_af.func_187225_a(field_190770_bw));
        BlockPos blockpos = this.func_184699_da();
        if (blockpos != null) {
            compound.func_74768_a("APX", blockpos.func_177958_n());
            compound.func_74768_a("APY", blockpos.func_177956_o());
            compound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockpos = this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
        if (blockpos == null && !this.field_70170_p.field_72995_K) {
            blockpos = new BlockPos((Entity)((Object)this));
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
        }
        if (this.func_184218_aH()) {
            float f;
            blockpos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.field_184708_bA = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos2;
            BlockPos blockpos1;
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!iblockstate.func_196958_f()) {
                if (iblockstate.func_177230_c() == Blocks.field_196603_bb) {
                    EnumFacing enumfacing = (EnumFacing)((Object)iblockstate.func_177229_b((IProperty)BlockPistonBase.field_176387_N));
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing))) {
                        blockpos = blockpos.func_177972_a(enumfacing);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
                    } else {
                        this.func_184689_o();
                    }
                } else if (iblockstate.func_177230_c() == Blocks.field_150332_K) {
                    EnumFacing enumfacing3 = (EnumFacing)((Object)iblockstate.func_177229_b((IProperty)BlockPistonExtension.field_176387_N));
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing3))) {
                        blockpos = blockpos.func_177972_a(enumfacing3);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos));
                    } else {
                        this.func_184689_o();
                    }
                } else {
                    this.func_184689_o();
                }
            }
            if (!this.field_70170_p.func_195595_w(blockpos1 = blockpos.func_177972_a(this.func_184696_cZ()))) {
                boolean flag = false;
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    blockpos1 = blockpos.func_177972_a(enumfacing1);
                    if (!this.field_70170_p.func_195595_w(blockpos1)) continue;
                    this.field_70180_af.func_187227_b(field_184700_a, enumfacing1);
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.func_184689_o();
                }
            }
            if (this.field_70170_p.func_195595_w(blockpos2 = blockpos.func_177972_a(this.func_184696_cZ().func_176734_d()))) {
                this.func_184689_o();
            }
        }
        float f1 = (float)this.func_184684_db() * 0.01f;
        this.field_184705_bx = this.field_184706_by;
        if (this.field_184706_by > f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by - 0.05f), (float)f1, (float)1.0f);
        } else if (this.field_184706_by < f1) {
            this.field_184706_by = MathHelper.func_76131_a((float)(this.field_184706_by + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_184708_bA > 0 && this.field_184707_bz != null) {
                    --this.field_184708_bA;
                } else {
                    this.field_184707_bz = blockpos;
                }
            }
            this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
            this.field_70163_u = blockpos.func_177956_o();
            this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
            if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72866_a((Entity)((Object)this), false);
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            double d3 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184706_by) * (float)Math.PI)) * 0.5;
            double d4 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.field_184705_bx) * (float)Math.PI)) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            EnumFacing enumfacing2 = this.func_184696_cZ();
            switch (enumfacing2) {
                case DOWN: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d3, this.field_70161_v + 0.5));
                    d1 = d5;
                    break;
                }
                case UP: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - d3, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d1 = -d5;
                    break;
                }
                case NORTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d3));
                    d2 = d5;
                    break;
                }
                case SOUTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d3, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d2 = -d5;
                    break;
                }
                case WEST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d3, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = d5;
                    break;
                }
                case EAST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5 - d3, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = -d5;
                }
            }
            if (d5 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)((Object)this), this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(MoverType.SHULKER, d0, d1, d2);
                }
            }
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (type == MoverType.SHULKER_BOX) {
            this.func_184689_o();
        } else {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70180_af != null && this.field_70173_aa != 0) {
            Optional<BlockPos> optional = this.field_70180_af.func_187225_a(field_184701_b);
            Optional<BlockPos> optional1 = Optional.of(new BlockPos(x, y, z));
            if (!optional1.equals(optional)) {
                this.field_70180_af.func_187227_b(field_184701_b, optional1);
                this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
                this.field_70160_al = true;
            }
        }
    }

    protected boolean func_184689_o() {
        if (!this.func_175446_cd() && this.func_70089_S()) {
            BlockPos blockpos = new BlockPos((Entity)((Object)this));
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17));
                if (blockpos1.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockpos1) || !this.field_70170_p.func_191503_g((Entity)((Object)this)) || !this.field_70170_p.func_195586_b((Entity)((Object)this), new AxisAlignedBB(blockpos1))) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (!this.field_70170_p.func_195595_w(blockpos1.func_177972_a(enumfacing))) continue;
                    this.field_70180_af.func_187227_b(field_184700_a, enumfacing);
                    flag = true;
                    break;
                }
                if (flag) {
                    EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)((Object)this), (double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p(), 0.0f);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        flag = false;
                    }
                    blockpos1 = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (!flag) continue;
                this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
                this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockpos1));
                this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    public void func_184206_a(DataParameter<?> key) {
        BlockPos blockpos;
        if (field_184701_b.equals(key) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (blockpos = this.func_184699_da()) != null) {
            if (this.field_184707_bz == null) {
                this.field_184707_bz = blockpos;
            } else {
                this.field_184708_bA = 6;
            }
            this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
            this.field_70163_u = blockpos.func_177956_o();
            this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70716_bi = 0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_184686_df() && (entity = source.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.func_184689_o();
            }
            return true;
        }
        return false;
    }

    private boolean func_184686_df() {
        return this.func_184684_db() == 0;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public EnumFacing func_184696_cZ() {
        return this.field_70180_af.func_187225_a(field_184700_a);
    }

    @Nullable
    public BlockPos func_184699_da() {
        return this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
    }

    public void func_184694_g(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(field_184701_b, Optional.ofNullable(pos));
    }

    public int func_184684_db() {
        return this.field_70180_af.func_187225_a(field_184702_c).byteValue();
    }

    public void func_184691_a(int p_184691_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(field_184704_bw);
            if (p_184691_1_ == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(field_184704_bw);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(field_184702_c, (byte)p_184691_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184688_a(float p_184688_1_) {
        return this.field_184705_bx + (this.field_184706_by - this.field_184705_bx) * p_184688_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_184693_dc() {
        return this.field_184708_bA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_184692_dd() {
        return this.field_184707_bz;
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184697_de() {
        return this.field_184707_bz != null && this.func_184699_da() != null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186442_x;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumDyeColor func_190769_dn() {
        Byte obyte = this.field_70180_af.func_187225_a(field_190770_bw);
        return obyte != 16 && obyte <= 15 ? EnumDyeColor.func_196056_a(obyte.byteValue()) : null;
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase theEntity) {
            super(theEntity);
        }

        public void func_75664_a() {
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int field_188522_b;

        private AIPeek() {
        }

        public boolean func_75250_a() {
            return EntityShulker.this.func_70638_az() == null && EntityShulker.this.field_70146_Z.nextInt(40) == 0;
        }

        public boolean func_75253_b() {
            return EntityShulker.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        public void func_75249_e() {
            this.field_188522_b = 20 * (1 + EntityShulker.this.field_70146_Z.nextInt(3));
            EntityShulker.this.func_184691_a(30);
        }

        public void func_75251_c() {
            if (EntityShulker.this.func_70638_az() == null) {
                EntityShulker.this.func_184691_a(0);
            }
        }

        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    static class AIDefenseAttack
    extends EntityAINearestAttackableTarget<EntityLivingBase> {
        public AIDefenseAttack(EntityShulker shulker) {
            super((EntityCreature)shulker, EntityLivingBase.class, 10, true, false, p_200826_0_ -> p_200826_0_ instanceof IMob);
        }

        public boolean func_75250_a() {
            return this.field_75299_d.func_96124_cp() == null ? false : super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            EnumFacing enumfacing = ((EntityShulker)this.field_75299_d).func_184696_cZ();
            if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, targetDistance, targetDistance);
            }
            return enumfacing.func_176740_k() == EnumFacing.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
        }
    }

    class AIAttackNearest
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackNearest(EntityShulker shulker) {
            super((EntityCreature)shulker, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return EntityShulker.this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? false : super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            EnumFacing enumfacing = ((EntityShulker)this.field_75299_d).func_184696_cZ();
            if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, targetDistance, targetDistance);
            }
            return enumfacing.func_176740_k() == EnumFacing.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int field_188520_b;

        public AIAttack() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_70089_S()) {
                return EntityShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_188520_b = 20;
            EntityShulker.this.func_184691_a(100);
        }

        public void func_75251_c() {
            EntityShulker.this.func_184691_a(0);
        }

        public void func_75246_d() {
            if (EntityShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                --this.field_188520_b;
                EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
                EntityShulker.this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
                double d0 = EntityShulker.this.func_70068_e(entitylivingbase);
                if (d0 < 400.0) {
                    if (this.field_188520_b <= 0) {
                        this.field_188520_b = 20 + EntityShulker.this.field_70146_Z.nextInt(10) * 20 / 2;
                        EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(EntityShulker.this.field_70170_p, (EntityLivingBase)((Object)EntityShulker.this), entitylivingbase, EntityShulker.this.func_184696_cZ().func_176740_k());
                        EntityShulker.this.field_70170_p.func_72838_d(entityshulkerbullet);
                        EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    EntityShulker.this.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

