/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderAreaEffectCloud;
import net.minecraft.client.renderer.entity.RenderArmorStand;
import net.minecraft.client.renderer.entity.RenderBat;
import net.minecraft.client.renderer.entity.RenderBlaze;
import net.minecraft.client.renderer.entity.RenderBoat;
import net.minecraft.client.renderer.entity.RenderCaveSpider;
import net.minecraft.client.renderer.entity.RenderChicken;
import net.minecraft.client.renderer.entity.RenderCod;
import net.minecraft.client.renderer.entity.RenderCow;
import net.minecraft.client.renderer.entity.RenderCreeper;
import net.minecraft.client.renderer.entity.RenderDolphin;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderDragonFireball;
import net.minecraft.client.renderer.entity.RenderDrowned;
import net.minecraft.client.renderer.entity.RenderElderGuardian;
import net.minecraft.client.renderer.entity.RenderEnderCrystal;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderEndermite;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderEvoker;
import net.minecraft.client.renderer.entity.RenderEvokerFangs;
import net.minecraft.client.renderer.entity.RenderFallingBlock;
import net.minecraft.client.renderer.entity.RenderFireball;
import net.minecraft.client.renderer.entity.RenderFish;
import net.minecraft.client.renderer.entity.RenderGhast;
import net.minecraft.client.renderer.entity.RenderGiantZombie;
import net.minecraft.client.renderer.entity.RenderGuardian;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderHorseChest;
import net.minecraft.client.renderer.entity.RenderHorseUndead;
import net.minecraft.client.renderer.entity.RenderHusk;
import net.minecraft.client.renderer.entity.RenderIllusionIllager;
import net.minecraft.client.renderer.entity.RenderIronGolem;
import net.minecraft.client.renderer.entity.RenderItemFrame;
import net.minecraft.client.renderer.entity.RenderLeashKnot;
import net.minecraft.client.renderer.entity.RenderLightningBolt;
import net.minecraft.client.renderer.entity.RenderLlama;
import net.minecraft.client.renderer.entity.RenderLlamaSpit;
import net.minecraft.client.renderer.entity.RenderMagmaCube;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.entity.RenderMinecartMobSpawner;
import net.minecraft.client.renderer.entity.RenderMooshroom;
import net.minecraft.client.renderer.entity.RenderOcelot;
import net.minecraft.client.renderer.entity.RenderPainting;
import net.minecraft.client.renderer.entity.RenderParrot;
import net.minecraft.client.renderer.entity.RenderPhantom;
import net.minecraft.client.renderer.entity.RenderPig;
import net.minecraft.client.renderer.entity.RenderPigZombie;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderPolarBear;
import net.minecraft.client.renderer.entity.RenderPotion;
import net.minecraft.client.renderer.entity.RenderPufferFish;
import net.minecraft.client.renderer.entity.RenderRabbit;
import net.minecraft.client.renderer.entity.RenderSalmon;
import net.minecraft.client.renderer.entity.RenderSheep;
import net.minecraft.client.renderer.entity.RenderShulker;
import net.minecraft.client.renderer.entity.RenderShulkerBullet;
import net.minecraft.client.renderer.entity.RenderSilverfish;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.RenderSnowMan;
import net.minecraft.client.renderer.entity.RenderSpectralArrow;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.entity.RenderSprite;
import net.minecraft.client.renderer.entity.RenderSquid;
import net.minecraft.client.renderer.entity.RenderStray;
import net.minecraft.client.renderer.entity.RenderTNTPrimed;
import net.minecraft.client.renderer.entity.RenderTippedArrow;
import net.minecraft.client.renderer.entity.RenderTntMinecart;
import net.minecraft.client.renderer.entity.RenderTrident;
import net.minecraft.client.renderer.entity.RenderTropicalFish;
import net.minecraft.client.renderer.entity.RenderTurtle;
import net.minecraft.client.renderer.entity.RenderVex;
import net.minecraft.client.renderer.entity.RenderVillager;
import net.minecraft.client.renderer.entity.RenderVindicator;
import net.minecraft.client.renderer.entity.RenderWitch;
import net.minecraft.client.renderer.entity.RenderWither;
import net.minecraft.client.renderer.entity.RenderWitherSkeleton;
import net.minecraft.client.renderer.entity.RenderWitherSkull;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.client.renderer.entity.RenderXPOrb;
import net.minecraft.client.renderer.entity.RenderZombie;
import net.minecraft.client.renderer.entity.RenderZombieVillager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityDrowned;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPhantom;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCod;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDolphin;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityPufferFish;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySalmon;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTropicalFish;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class RenderManager {
    public final Map<Class<? extends Entity>, Render<? extends Entity>> field_78729_o = Maps.newHashMap();
    private final Map<String, RenderPlayer> field_178636_l = Maps.newHashMap();
    private final RenderPlayer field_178637_m;
    private FontRenderer field_78736_p;
    private double field_78725_b;
    private double field_78726_c;
    private double field_78723_d;
    public TextureManager field_78724_e;
    public World field_78722_g;
    public Entity field_78734_h;
    public Entity field_147941_i;
    public float field_78735_i;
    public float field_78732_j;
    public GameSettings field_78733_k;
    public double field_78730_l;
    public double field_78731_m;
    public double field_78728_n;
    private boolean field_178639_r;
    private boolean field_178638_s = true;
    private boolean field_85095_o;

    public RenderManager(TextureManager renderEngineIn, ItemRenderer itemRendererIn) {
        this.field_78724_e = renderEngineIn;
        this.field_78729_o.put(EntityCaveSpider.class, (Render<? extends Entity>)new RenderCaveSpider(this));
        this.field_78729_o.put(EntitySpider.class, (Render<? extends Entity>)new RenderSpider(this));
        this.field_78729_o.put(EntityPig.class, (Render<? extends Entity>)new RenderPig(this));
        this.field_78729_o.put(EntitySheep.class, (Render<? extends Entity>)new RenderSheep(this));
        this.field_78729_o.put(EntityCow.class, (Render<? extends Entity>)new RenderCow(this));
        this.field_78729_o.put(EntityMooshroom.class, (Render<? extends Entity>)new RenderMooshroom(this));
        this.field_78729_o.put(EntityWolf.class, (Render<? extends Entity>)new RenderWolf(this));
        this.field_78729_o.put(EntityChicken.class, (Render<? extends Entity>)new RenderChicken(this));
        this.field_78729_o.put(EntityOcelot.class, (Render<? extends Entity>)new RenderOcelot(this));
        this.field_78729_o.put(EntityRabbit.class, (Render<? extends Entity>)new RenderRabbit(this));
        this.field_78729_o.put(EntityParrot.class, (Render<? extends Entity>)new RenderParrot(this));
        this.field_78729_o.put(EntityTurtle.class, (Render<? extends Entity>)new RenderTurtle(this));
        this.field_78729_o.put(EntitySilverfish.class, (Render<? extends Entity>)new RenderSilverfish(this));
        this.field_78729_o.put(EntityEndermite.class, (Render<? extends Entity>)new RenderEndermite(this));
        this.field_78729_o.put(EntityCreeper.class, (Render<? extends Entity>)new RenderCreeper(this));
        this.field_78729_o.put(EntityEnderman.class, (Render<? extends Entity>)new RenderEnderman(this));
        this.field_78729_o.put(EntitySnowman.class, (Render<? extends Entity>)new RenderSnowMan(this));
        this.field_78729_o.put(EntitySkeleton.class, (Render<? extends Entity>)new RenderSkeleton(this));
        this.field_78729_o.put(EntityWitherSkeleton.class, (Render<? extends Entity>)new RenderWitherSkeleton(this));
        this.field_78729_o.put(EntityStray.class, (Render<? extends Entity>)new RenderStray(this));
        this.field_78729_o.put(EntityWitch.class, (Render<? extends Entity>)new RenderWitch(this));
        this.field_78729_o.put(EntityBlaze.class, (Render<? extends Entity>)new RenderBlaze(this));
        this.field_78729_o.put(EntityPigZombie.class, (Render<? extends Entity>)new RenderPigZombie(this));
        this.field_78729_o.put(EntityZombie.class, (Render<? extends Entity>)new RenderZombie(this));
        this.field_78729_o.put(EntityZombieVillager.class, (Render<? extends Entity>)new RenderZombieVillager(this));
        this.field_78729_o.put(EntityHusk.class, (Render<? extends Entity>)new RenderHusk(this));
        this.field_78729_o.put(EntityDrowned.class, (Render<? extends Entity>)new RenderDrowned(this));
        this.field_78729_o.put(EntitySlime.class, (Render<? extends Entity>)new RenderSlime(this));
        this.field_78729_o.put(EntityMagmaCube.class, (Render<? extends Entity>)new RenderMagmaCube(this));
        this.field_78729_o.put(EntityGiantZombie.class, (Render<? extends Entity>)new RenderGiantZombie(this, 6.0f));
        this.field_78729_o.put(EntityGhast.class, (Render<? extends Entity>)new RenderGhast(this));
        this.field_78729_o.put(EntitySquid.class, (Render<? extends Entity>)new RenderSquid(this));
        this.field_78729_o.put(EntityVillager.class, (Render<? extends Entity>)new RenderVillager(this));
        this.field_78729_o.put(EntityIronGolem.class, (Render<? extends Entity>)new RenderIronGolem(this));
        this.field_78729_o.put(EntityBat.class, (Render<? extends Entity>)new RenderBat(this));
        this.field_78729_o.put(EntityGuardian.class, (Render<? extends Entity>)new RenderGuardian(this));
        this.field_78729_o.put(EntityElderGuardian.class, (Render<? extends Entity>)new RenderElderGuardian(this));
        this.field_78729_o.put(EntityShulker.class, (Render<? extends Entity>)new RenderShulker(this));
        this.field_78729_o.put(EntityPolarBear.class, (Render<? extends Entity>)new RenderPolarBear(this));
        this.field_78729_o.put(EntityEvoker.class, (Render<? extends Entity>)new RenderEvoker(this));
        this.field_78729_o.put(EntityVindicator.class, (Render<? extends Entity>)new RenderVindicator(this));
        this.field_78729_o.put(EntityVex.class, (Render<? extends Entity>)new RenderVex(this));
        this.field_78729_o.put(EntityIllusionIllager.class, (Render<? extends Entity>)new RenderIllusionIllager(this));
        this.field_78729_o.put(EntityPhantom.class, (Render<? extends Entity>)new RenderPhantom(this));
        this.field_78729_o.put(EntityPufferFish.class, (Render<? extends Entity>)new RenderPufferFish(this));
        this.field_78729_o.put(EntitySalmon.class, (Render<? extends Entity>)new RenderSalmon(this));
        this.field_78729_o.put(EntityCod.class, (Render<? extends Entity>)new RenderCod(this));
        this.field_78729_o.put(EntityTropicalFish.class, (Render<? extends Entity>)new RenderTropicalFish(this));
        this.field_78729_o.put(EntityDolphin.class, (Render<? extends Entity>)new RenderDolphin(this));
        this.field_78729_o.put(EntityDragon.class, (Render<? extends Entity>)new RenderDragon(this));
        this.field_78729_o.put(EntityEnderCrystal.class, (Render<? extends Entity>)new RenderEnderCrystal(this));
        this.field_78729_o.put(EntityWither.class, (Render<? extends Entity>)new RenderWither(this));
        this.field_78729_o.put(Entity.class, (Render<? extends Entity>)new RenderEntity(this));
        this.field_78729_o.put(EntityPainting.class, (Render<? extends Entity>)new RenderPainting(this));
        this.field_78729_o.put(EntityItemFrame.class, new RenderItemFrame(this, itemRendererIn));
        this.field_78729_o.put(EntityLeashKnot.class, (Render<? extends Entity>)new RenderLeashKnot(this));
        this.field_78729_o.put(EntityTippedArrow.class, (Render<? extends Entity>)new RenderTippedArrow(this));
        this.field_78729_o.put(EntitySpectralArrow.class, (Render<? extends Entity>)new RenderSpectralArrow(this));
        this.field_78729_o.put(EntityTrident.class, (Render<? extends Entity>)new RenderTrident(this));
        this.field_78729_o.put(EntitySnowball.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_151126_ay, itemRendererIn));
        this.field_78729_o.put(EntityEnderPearl.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_151079_bi, itemRendererIn));
        this.field_78729_o.put(EntityEnderEye.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_151061_bv, itemRendererIn));
        this.field_78729_o.put(EntityEgg.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_151110_aK, itemRendererIn));
        this.field_78729_o.put(EntityPotion.class, (Render<? extends Entity>)new RenderPotion(this, itemRendererIn));
        this.field_78729_o.put(EntityExpBottle.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_151062_by, itemRendererIn));
        this.field_78729_o.put(EntityFireworkRocket.class, (Render<? extends Entity>)new RenderSprite(this, Items.field_196152_dE, itemRendererIn));
        this.field_78729_o.put(EntityLargeFireball.class, (Render<? extends Entity>)new RenderFireball(this, 2.0f));
        this.field_78729_o.put(EntitySmallFireball.class, (Render<? extends Entity>)new RenderFireball(this, 0.5f));
        this.field_78729_o.put(EntityDragonFireball.class, (Render<? extends Entity>)new RenderDragonFireball(this));
        this.field_78729_o.put(EntityWitherSkull.class, (Render<? extends Entity>)new RenderWitherSkull(this));
        this.field_78729_o.put(EntityShulkerBullet.class, (Render<? extends Entity>)new RenderShulkerBullet(this));
        this.field_78729_o.put(EntityItem.class, new RenderEntityItem(this, itemRendererIn));
        this.field_78729_o.put(EntityXPOrb.class, (Render<? extends Entity>)new RenderXPOrb(this));
        this.field_78729_o.put(EntityTNTPrimed.class, (Render<? extends Entity>)new RenderTNTPrimed(this));
        this.field_78729_o.put(EntityFallingBlock.class, (Render<? extends Entity>)new RenderFallingBlock(this));
        this.field_78729_o.put(EntityArmorStand.class, (Render<? extends Entity>)new RenderArmorStand(this));
        this.field_78729_o.put(EntityEvokerFangs.class, (Render<? extends Entity>)new RenderEvokerFangs(this));
        this.field_78729_o.put(EntityMinecartTNT.class, (Render<? extends Entity>)new RenderTntMinecart(this));
        this.field_78729_o.put(EntityMinecartMobSpawner.class, (Render<? extends Entity>)new RenderMinecartMobSpawner(this));
        this.field_78729_o.put(EntityMinecart.class, (Render<? extends Entity>)new RenderMinecart(this));
        this.field_78729_o.put(EntityBoat.class, (Render<? extends Entity>)new RenderBoat(this));
        this.field_78729_o.put(EntityFishHook.class, new RenderFish(this));
        this.field_78729_o.put(EntityAreaEffectCloud.class, (Render<? extends Entity>)new RenderAreaEffectCloud(this));
        this.field_78729_o.put(EntityHorse.class, (Render<? extends Entity>)new RenderHorse(this));
        this.field_78729_o.put(EntitySkeletonHorse.class, (Render<? extends Entity>)new RenderHorseUndead(this));
        this.field_78729_o.put(EntityZombieHorse.class, (Render<? extends Entity>)new RenderHorseUndead(this));
        this.field_78729_o.put(EntityMule.class, (Render<? extends Entity>)new RenderHorseChest(this, 0.92f));
        this.field_78729_o.put(EntityDonkey.class, (Render<? extends Entity>)new RenderHorseChest(this, 0.87f));
        this.field_78729_o.put(EntityLlama.class, (Render<? extends Entity>)new RenderLlama(this));
        this.field_78729_o.put(EntityLlamaSpit.class, (Render<? extends Entity>)new RenderLlamaSpit(this));
        this.field_78729_o.put(EntityLightningBolt.class, (Render<? extends Entity>)new RenderLightningBolt(this));
        this.field_178637_m = new RenderPlayer(this);
        this.field_178636_l.put("default", this.field_178637_m);
        this.field_178636_l.put("slim", new RenderPlayer(this, true));
        RenderingRegistry.loadEntityRenderers((RenderManager)this, this.field_78729_o);
    }

    public Map<String, RenderPlayer> getSkinMap() {
        return Collections.unmodifiableMap(this.field_178636_l);
    }

    public void func_178628_a(double renderPosXIn, double renderPosYIn, double renderPosZIn) {
        this.field_78725_b = renderPosXIn;
        this.field_78726_c = renderPosYIn;
        this.field_78723_d = renderPosZIn;
    }

    public <T extends Entity> Render<T> func_78715_a(Class<? extends Entity> entityClass) {
        Object render = this.field_78729_o.get(entityClass);
        if (render == null && entityClass != Entity.class) {
            render = this.func_78715_a(entityClass.getSuperclass());
            this.field_78729_o.put(entityClass, (Render<? extends Entity>)render);
        }
        return render;
    }

    @Nullable
    public <T extends Entity> Render<T> func_78713_a(Entity entityIn) {
        if (entityIn instanceof AbstractClientPlayer) {
            String s = ((AbstractClientPlayer)entityIn).func_175154_l();
            RenderPlayer renderplayer = this.field_178636_l.get(s);
            return renderplayer != null ? renderplayer : this.field_178637_m;
        }
        return this.func_78715_a(((Object)((Object)entityIn)).getClass());
    }

    public void func_180597_a(World worldIn, FontRenderer textRendererIn, Entity livingPlayerIn, Entity pointedEntityIn, GameSettings optionsIn, float partialTicks) {
        this.field_78722_g = worldIn;
        this.field_78733_k = optionsIn;
        this.field_78734_h = livingPlayerIn;
        this.field_147941_i = pointedEntityIn;
        this.field_78736_p = textRendererIn;
        if (livingPlayerIn instanceof EntityLivingBase && ((EntityLivingBase)livingPlayerIn).func_70608_bn()) {
            BlockPos pos = new BlockPos(livingPlayerIn);
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (block.isBed(iblockstate, (IBlockReader)worldIn, pos, livingPlayerIn)) {
                int i = block.getBedDirection(iblockstate, worldIn, pos).func_176736_b();
                this.field_78735_i = i * 90 + 180;
                this.field_78732_j = 0.0f;
            }
        } else {
            this.field_78735_i = livingPlayerIn.field_70126_B + (livingPlayerIn.field_70177_z - livingPlayerIn.field_70126_B) * partialTicks;
            this.field_78732_j = livingPlayerIn.field_70127_C + (livingPlayerIn.field_70125_A - livingPlayerIn.field_70127_C) * partialTicks;
        }
        if (optionsIn.field_74320_O == 2) {
            this.field_78735_i += 180.0f;
        }
        this.field_78730_l = livingPlayerIn.field_70142_S + (livingPlayerIn.field_70165_t - livingPlayerIn.field_70142_S) * (double)partialTicks;
        this.field_78731_m = livingPlayerIn.field_70137_T + (livingPlayerIn.field_70163_u - livingPlayerIn.field_70137_T) * (double)partialTicks;
        this.field_78728_n = livingPlayerIn.field_70136_U + (livingPlayerIn.field_70161_v - livingPlayerIn.field_70136_U) * (double)partialTicks;
    }

    public void func_178631_a(float playerViewYIn) {
        this.field_78735_i = playerViewYIn;
    }

    public boolean func_178627_a() {
        return this.field_178638_s;
    }

    public void func_178633_a(boolean renderShadowIn) {
        this.field_178638_s = renderShadowIn;
    }

    public void func_178629_b(boolean debugBoundingBoxIn) {
        this.field_85095_o = debugBoundingBoxIn;
    }

    public boolean func_178634_b() {
        return this.field_85095_o;
    }

    public boolean func_188390_b(Entity entityIn) {
        return this.func_78713_a(entityIn).func_188295_H_();
    }

    public boolean func_178635_a(Entity entityIn, ICamera camera, double camX, double camY, double camZ) {
        Render render = this.func_78713_a(entityIn);
        return render != null && render.func_177071_a(entityIn, camera, camX, camY, camZ);
    }

    public void func_188388_a(Entity entityIn, float partialTicks, boolean p_188388_3_) {
        if (entityIn.field_70173_aa == 0) {
            entityIn.field_70142_S = entityIn.field_70165_t;
            entityIn.field_70137_T = entityIn.field_70163_u;
            entityIn.field_70136_U = entityIn.field_70161_v;
        }
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        float f = entityIn.field_70126_B + (entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks;
        int i = entityIn.func_70070_b();
        if (entityIn.func_70027_ad()) {
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, j, k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_188391_a(entityIn, d0 - this.field_78725_b, d1 - this.field_78726_c, d2 - this.field_78723_d, f, partialTicks, p_188388_3_);
    }

    public void func_188391_a(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_) {
        block9: {
            Render render = null;
            try {
                render = this.func_78713_a(entityIn);
                if (render == null || this.field_78724_e == null) break block9;
                try {
                    render.func_188297_a(this.field_178639_r);
                    render.func_76986_a(entityIn, x, y, z, yaw, partialTicks);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.func_85055_a(throwable1, "Rendering entity in world"));
                }
                try {
                    if (!this.field_178639_r) {
                        render.func_76979_b(entityIn, x, y, z, yaw, partialTicks);
                    }
                }
                catch (Throwable throwable2) {
                    throw new ReportedException(CrashReport.func_85055_a(throwable2, "Post-rendering entity in world"));
                }
                if (!this.field_85095_o || entityIn.func_82150_aj() || p_188391_10_ || Minecraft.func_71410_x().func_189648_am()) break block9;
                try {
                    this.func_85094_b(entityIn, x, y, z, yaw, partialTicks);
                }
                catch (Throwable throwable) {
                    throw new ReportedException(CrashReport.func_85055_a(throwable, "Rendering entity hitbox in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable3, "Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                entityIn.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", render);
                crashreportcategory1.func_71507_a("Location", CrashReportCategory.func_85074_a(x, y, z));
                crashreportcategory1.func_71507_a("Rotation", Float.valueOf(yaw));
                crashreportcategory1.func_71507_a("Delta", Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_188389_a(Entity entityIn, float partialTicks) {
        if (entityIn.field_70173_aa == 0) {
            entityIn.field_70142_S = entityIn.field_70165_t;
            entityIn.field_70137_T = entityIn.field_70163_u;
            entityIn.field_70136_U = entityIn.field_70161_v;
        }
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        float f = entityIn.field_70126_B + (entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks;
        int i = entityIn.func_70070_b();
        if (entityIn.func_70027_ad()) {
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, j, k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Render render = this.func_78713_a(entityIn);
        if (render != null && this.field_78724_e != null) {
            render.func_188300_b(entityIn, d0 - this.field_78725_b, d1 - this.field_78726_c, d2 - this.field_78723_d, f, partialTicks);
        }
    }

    private void func_85094_b(Entity entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        float f = entityIn.field_70130_N / 2.0f;
        AxisAlignedBB axisalignedbb = entityIn.func_174813_aQ();
        WorldRenderer.func_189694_a(axisalignedbb.field_72340_a - entityIn.field_70165_t + x, axisalignedbb.field_72338_b - entityIn.field_70163_u + y, axisalignedbb.field_72339_c - entityIn.field_70161_v + z, axisalignedbb.field_72336_d - entityIn.field_70165_t + x, axisalignedbb.field_72337_e - entityIn.field_70163_u + y, axisalignedbb.field_72334_f - entityIn.field_70161_v + z, 1.0f, 1.0f, 1.0f, 1.0f);
        Entity[] aentity = entityIn.func_70021_al();
        if (aentity != null) {
            for (Entity entity : aentity) {
                double d0 = (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
                double d1 = (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
                double d2 = (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                WorldRenderer.func_189694_a(axisalignedbb1.field_72340_a - this.field_78725_b + d0, axisalignedbb1.field_72338_b - this.field_78726_c + d1, axisalignedbb1.field_72339_c - this.field_78723_d + d2, axisalignedbb1.field_72336_d - this.field_78725_b + d0, axisalignedbb1.field_72337_e - this.field_78726_c + d1, axisalignedbb1.field_72334_f - this.field_78723_d + d2, 0.25f, 1.0f, 0.0f, 1.0f);
            }
        }
        if (entityIn instanceof EntityLivingBase) {
            float f1 = 0.01f;
            WorldRenderer.func_189694_a(x - (double)f, y + (double)entityIn.func_70047_e() - (double)0.01f, z - (double)f, x + (double)f, y + (double)entityIn.func_70047_e() + (double)0.01f, z + (double)f, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Vec3d vec3d = entityIn.func_70676_i(partialTicks);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b(x, y + (double)entityIn.func_70047_e(), z).func_181669_b(0, 0, 255, 255).func_181675_d();
        bufferbuilder.func_181662_b(x + vec3d.field_72450_a * 2.0, y + (double)entityIn.func_70047_e() + vec3d.field_72448_b * 2.0, z + vec3d.field_72449_c * 2.0).func_181669_b(0, 0, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    public void func_78717_a(@Nullable World worldIn) {
        this.field_78722_g = worldIn;
        if (worldIn == null) {
            this.field_78734_h = null;
        }
    }

    public double func_78714_a(double x, double y, double z) {
        double d0 = x - this.field_78730_l;
        double d1 = y - this.field_78731_m;
        double d2 = z - this.field_78728_n;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public FontRenderer func_78716_a() {
        return this.field_78736_p;
    }

    public void func_178632_c(boolean renderOutlinesIn) {
        this.field_178639_r = renderOutlinesIn;
    }
}

