/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer {
    private static final ResourceLocation field_110931_c = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation field_110929_d = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft field_78455_a;
    private ItemStack field_187467_d = ItemStack.field_190927_a;
    private ItemStack field_187468_e = ItemStack.field_190927_a;
    private float field_187469_f;
    private float field_187470_g;
    private float field_187471_h;
    private float field_187472_i;
    private final RenderManager field_178111_g;
    private final ItemRenderer field_178112_h;

    public FirstPersonRenderer(Minecraft mcIn) {
        this.field_78455_a = mcIn;
        this.field_178111_g = mcIn.func_175598_ae();
        this.field_178112_h = mcIn.func_175599_af();
    }

    public void func_178099_a(EntityLivingBase entityIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform) {
        this.func_187462_a(entityIn, heldStack, transform, false);
    }

    public void func_187462_a(EntityLivingBase entitylivingbaseIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!heldStack.func_190926_b()) {
            boolean flag;
            Item item = heldStack.func_77973_b();
            Block block = Block.func_149634_a(item);
            GlStateManager.func_179094_E();
            boolean bl = flag = this.field_178112_h.func_175050_a(heldStack) && block.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
            if (flag) {
                GlStateManager.func_179132_a((boolean)false);
            }
            this.field_178112_h.func_184392_a(heldStack, entitylivingbaseIn, transform, leftHanded);
            if (flag) {
                GlStateManager.func_179132_a((boolean)true);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void func_178101_a(float angle, float angleY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void func_187464_b() {
        EntityPlayerSP abstractclientplayer = this.field_78455_a.field_71439_g;
        int i = this.field_78455_a.field_71441_e.func_175626_b(new BlockPos(abstractclientplayer.field_70165_t, abstractclientplayer.field_70163_u + (double)abstractclientplayer.func_70047_e(), abstractclientplayer.field_70161_v), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, f, f1);
    }

    private void func_187458_c(float partialTicks) {
        EntityPlayerSP entityplayersp = this.field_78455_a.field_71439_g;
        float f = entityplayersp.field_71164_i + (entityplayersp.field_71155_g - entityplayersp.field_71164_i) * partialTicks;
        float f1 = entityplayersp.field_71163_h + (entityplayersp.field_71154_f - entityplayersp.field_71163_h) * partialTicks;
        GlStateManager.func_179114_b((float)((entityplayersp.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((entityplayersp.field_70177_z - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private float func_178100_c(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }

    private void func_187466_c() {
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.func_187455_a(EnumHandSide.RIGHT);
            this.func_187455_a(EnumHandSide.LEFT);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
        }
    }

    private void func_187455_a(EnumHandSide side) {
        this.field_78455_a.func_110434_K().func_110577_a(this.field_78455_a.field_71439_g.func_110306_p());
        Render render = this.field_178111_g.func_78713_a(this.field_78455_a.field_71439_g);
        RenderPlayer renderplayer = (RenderPlayer)render;
        GlStateManager.func_179094_E();
        float f = side == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        if (side == EnumHandSide.RIGHT) {
            renderplayer.func_177138_b(this.field_78455_a.field_71439_g);
        } else {
            renderplayer.func_177139_c(this.field_78455_a.field_71439_g);
        }
        GlStateManager.func_179121_F();
    }

    private void func_187465_a(float equippedProgress, EnumHandSide hand, float swingProgress, ItemStack stack) {
        float f = hand == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179109_b((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_187456_a(equippedProgress, swingProgress, hand);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(f * 0.51f), (float)(-0.08f + equippedProgress * -1.2f), (float)-0.75f);
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
        GlStateManager.func_179114_b((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_187461_a(stack);
        GlStateManager.func_179121_F();
    }

    private void func_187463_a(float pitch, float equippedProgress, float swingProgress) {
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        float f3 = this.func_178100_c(pitch);
        GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + equippedProgress * -1.2f + f3 * -0.5f), (float)-0.72f);
        GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_187466_c();
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.func_187461_a(this.field_187467_d);
    }

    private void func_187461_a(ItemStack stack) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.38f, (float)0.38f, (float)0.38f);
        GlStateManager.func_179140_f();
        this.field_78455_a.func_110434_K().func_110577_a(field_110931_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData mapdata = ItemMap.func_195950_a(stack, this.field_78455_a.field_71441_e);
        if (mapdata != null) {
            this.field_78455_a.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.func_179145_e();
    }

    private void func_187456_a(float equippedProgress, float swingProgress, EnumHandSide side) {
        boolean flag = side != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + equippedProgress * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        EntityPlayerSP abstractclientplayer = this.field_78455_a.field_71439_g;
        this.field_78455_a.func_110434_K().func_110577_a(abstractclientplayer.func_110306_p());
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        RenderPlayer renderplayer = (RenderPlayer)this.field_178111_g.func_78713_a(abstractclientplayer);
        GlStateManager.func_179129_p();
        if (flag) {
            renderplayer.func_177138_b(abstractclientplayer);
        } else {
            renderplayer.func_177139_c(abstractclientplayer);
        }
        GlStateManager.func_179089_o();
    }

    private void func_187454_a(float partialTicks, EnumHandSide hand, ItemStack stack) {
        float f = (float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f;
        float f1 = f / (float)stack.func_77988_m();
        if (f1 < 0.8f) {
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            GlStateManager.func_179109_b((float)0.0f, (float)f2, (float)0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)(f3 * 0.6f * (float)i), (float)(f3 * -0.5f), (float)(f3 * 0.0f));
        GlStateManager.func_179114_b((float)((float)i * f3 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f3 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * f3 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void func_187453_a(EnumHandSide hand, float swingProgress) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void func_187459_b(EnumHandSide hand, float equippedProg) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + equippedProg * -0.6f), (float)-0.72f);
    }

    public void func_78440_a(float partialTicks) {
        float f6;
        float f5;
        float f3;
        float f4;
        ItemStack itemstack;
        EntityPlayerSP abstractclientplayer = this.field_78455_a.field_71439_g;
        float f = abstractclientplayer.func_70678_g(partialTicks);
        EnumHand enumhand = (EnumHand)MoreObjects.firstNonNull((Object)abstractclientplayer.field_184622_au, (Object)EnumHand.MAIN_HAND);
        float f1 = abstractclientplayer.field_70127_C + (abstractclientplayer.field_70125_A - abstractclientplayer.field_70127_C) * partialTicks;
        float f2 = abstractclientplayer.field_70126_B + (abstractclientplayer.field_70177_z - abstractclientplayer.field_70126_B) * partialTicks;
        boolean flag = true;
        boolean flag1 = true;
        if (((EntityLivingBase)abstractclientplayer).func_184587_cr() && (itemstack = abstractclientplayer.func_184607_cu()).func_77973_b() instanceof ItemBow) {
            flag = ((EntityLivingBase)abstractclientplayer).func_184600_cs() == EnumHand.MAIN_HAND;
            flag1 = !flag;
        }
        this.func_178101_a(f1, f2);
        this.func_187464_b();
        this.func_187458_c(partialTicks);
        GlStateManager.func_179091_B();
        if (flag && !ForgeHooksClient.renderSpecificFirstPersonHand((EnumHand)EnumHand.MAIN_HAND, (float)partialTicks, (float)f1, (float)(f4 = enumhand == EnumHand.MAIN_HAND ? f : 0.0f), (float)(f3 = 1.0f - (this.field_187470_g + (this.field_187469_f - this.field_187470_g) * partialTicks)), (ItemStack)this.field_187467_d)) {
            this.func_187457_a(abstractclientplayer, partialTicks, f1, EnumHand.MAIN_HAND, f4, this.field_187467_d, f3);
        }
        if (flag1 && !ForgeHooksClient.renderSpecificFirstPersonHand((EnumHand)EnumHand.OFF_HAND, (float)partialTicks, (float)f1, (float)(f5 = enumhand == EnumHand.OFF_HAND ? f : 0.0f), (float)(f6 = 1.0f - (this.field_187472_i + (this.field_187471_h - this.field_187472_i) * partialTicks)), (ItemStack)this.field_187468_e)) {
            this.func_187457_a(abstractclientplayer, partialTicks, f1, EnumHand.OFF_HAND, f5, this.field_187468_e, f6);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    public void func_187457_a(AbstractClientPlayer player, float partialTicks, float pitch, EnumHand hand, float swingProgress, ItemStack stack, float equippedProgress) {
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        if (stack.func_190926_b()) {
            if (flag && !player.func_82150_aj()) {
                this.func_187456_a(equippedProgress, swingProgress, enumhandside);
            }
        } else if (stack.func_77973_b() instanceof ItemMap) {
            if (flag && this.field_187468_e.func_190926_b()) {
                this.func_187463_a(pitch, equippedProgress, swingProgress);
            } else {
                this.func_187465_a(equippedProgress, enumhandside, swingProgress, stack);
            }
        } else {
            boolean flag1;
            boolean bl = flag1 = enumhandside == EnumHandSide.RIGHT;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == hand) {
                int k = flag1 ? 1 : -1;
                switch (stack.func_77975_n()) {
                    case NONE: {
                        this.func_187459_b(enumhandside, equippedProgress);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.func_187454_a(partialTicks, enumhandside, stack);
                        this.func_187459_b(enumhandside, equippedProgress);
                        break;
                    }
                    case BLOCK: {
                        this.func_187459_b(enumhandside, equippedProgress);
                        break;
                    }
                    case BOW: {
                        this.func_187459_b(enumhandside, equippedProgress);
                        GlStateManager.func_179109_b((float)((float)k * -0.2785682f), (float)0.18344387f, (float)0.15731531f);
                        GlStateManager.func_179114_b((float)-13.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)k * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)k * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f6 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f8 = f6 / 20.0f;
                        f8 = (f8 * f8 + f8 * 2.0f) / 3.0f;
                        if (f8 > 1.0f) {
                            f8 = 1.0f;
                        }
                        if (f8 > 0.1f) {
                            float f10 = MathHelper.func_76126_a((float)((f6 - 0.1f) * 1.3f));
                            float f11 = f8 - 0.1f;
                            float f12 = f10 * f11;
                            GlStateManager.func_179109_b((float)(f12 * 0.0f), (float)(f12 * 0.004f), (float)(f12 * 0.0f));
                        }
                        GlStateManager.func_179109_b((float)(f8 * 0.0f), (float)(f8 * 0.0f), (float)(f8 * 0.04f));
                        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f + f8 * 0.2f));
                        GlStateManager.func_179114_b((float)((float)k * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case SPEAR: {
                        this.func_187459_b(enumhandside, equippedProgress);
                        GlStateManager.func_179109_b((float)((float)k * -0.5f), (float)0.7f, (float)0.1f);
                        GlStateManager.func_179114_b((float)-55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)k * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)k * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f5 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f7 = f5 / 10.0f;
                        if (f7 > 1.0f) {
                            f7 = 1.0f;
                        }
                        if (f7 > 0.1f) {
                            float f9 = MathHelper.func_76126_a((float)((f5 - 0.1f) * 1.3f));
                            float f2 = f7 - 0.1f;
                            float f3 = f9 * f2;
                            GlStateManager.func_179109_b((float)(f3 * 0.0f), (float)(f3 * 0.004f), (float)(f3 * 0.0f));
                        }
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(f7 * 0.2f));
                        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f + f7 * 0.2f));
                        GlStateManager.func_179114_b((float)((float)k * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                    }
                }
            } else if (player.func_204805_cN()) {
                this.func_187459_b(enumhandside, equippedProgress);
                int i = flag1 ? 1 : -1;
                GlStateManager.func_179109_b((float)((float)i * -0.4f), (float)0.8f, (float)0.3f);
                GlStateManager.func_179114_b((float)((float)i * 65.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)i * -85.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                float f4 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                int j = flag1 ? 1 : -1;
                GlStateManager.func_179109_b((float)((float)j * f4), (float)f, (float)f1);
                this.func_187459_b(enumhandside, equippedProgress);
                this.func_187453_a(enumhandside, swingProgress);
            }
            this.func_187462_a(player, stack, flag1 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag1);
        }
        GlStateManager.func_179121_F();
    }

    public void func_78447_b(float partialTicks) {
        GlStateManager.func_179118_c();
        if (this.field_78455_a.field_71439_g.func_70094_T()) {
            IBlockState iblockstate = this.field_78455_a.field_71441_e.func_180495_p(new BlockPos((Entity)this.field_78455_a.field_71439_g));
            BlockPos overlayPos = new BlockPos((Entity)this.field_78455_a.field_71439_g);
            EntityPlayerSP entityplayer = this.field_78455_a.field_71439_g;
            for (int i = 0; i < 8; ++i) {
                double d0 = entityplayer.field_70165_t + (double)(((float)((i >> 0) % 2) - 0.5f) * entityplayer.field_70130_N * 0.8f);
                double d1 = entityplayer.field_70163_u + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double d2 = entityplayer.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * entityplayer.field_70130_N * 0.8f);
                BlockPos blockpos = new BlockPos(d0, d1 + (double)entityplayer.func_70047_e(), d2);
                IBlockState iblockstate1 = this.field_78455_a.field_71441_e.func_180495_p(blockpos);
                if (!iblockstate1.func_191058_s()) continue;
                iblockstate = iblockstate1;
                overlayPos = blockpos;
            }
            if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE && !ForgeEventFactory.renderBlockOverlay((EntityPlayer)this.field_78455_a.field_71439_g, (float)partialTicks, (RenderBlockOverlayEvent.OverlayType)RenderBlockOverlayEvent.OverlayType.BLOCK, (IBlockState)iblockstate, (BlockPos)overlayPos)) {
                this.func_178108_a(this.field_78455_a.func_175602_ab().func_175023_a().func_178122_a(iblockstate));
            }
        }
        if (!this.field_78455_a.field_71439_g.func_175149_v()) {
            if (this.field_78455_a.field_71439_g.func_208600_a(FluidTags.field_206959_a) && !ForgeEventFactory.renderWaterOverlay((EntityPlayer)this.field_78455_a.field_71439_g, (float)partialTicks)) {
                this.func_78448_c(partialTicks);
            }
            if (this.field_78455_a.field_71439_g.func_70027_ad() && !ForgeEventFactory.renderFireOverlay((EntityPlayer)this.field_78455_a.field_71439_g, (float)partialTicks)) {
                this.func_78442_d();
            }
        }
        GlStateManager.func_179141_d();
    }

    private void func_178108_a(TextureAtlasSprite sprite) {
        this.field_78455_a.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f = 0.1f;
        GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.5f);
        GlStateManager.func_179094_E();
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = sprite.func_94209_e();
        float f7 = sprite.func_94212_f();
        float f8 = sprite.func_94206_g();
        float f9 = sprite.func_94210_h();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a(f7, f9).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a(f6, f9).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a(f6, f8).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(f7, f8).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void func_78448_c(float partialTicks) {
        this.field_78455_a.func_110434_K().func_110577_a(field_110929_d);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f = this.field_78455_a.field_71439_g.func_70013_c();
        GlStateManager.func_179131_c((float)f, (float)f, (float)f, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -this.field_78455_a.field_71439_g.field_70177_z / 64.0f;
        float f8 = this.field_78455_a.field_71439_g.field_70125_A / 64.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a(4.0f + f7, 4.0f + f8).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a(0.0f + f7, 4.0f + f8).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a(0.0f + f7, 0.0f + f8).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(4.0f + f7, 0.0f + f8).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private void func_78442_d() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float f = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179094_E();
            TextureAtlasSprite textureatlassprite = this.field_78455_a.func_147117_R().func_195424_a(ModelBakery.field_207764_b);
            this.field_78455_a.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            float f1 = textureatlassprite.func_94209_e();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94206_g();
            float f4 = textureatlassprite.func_94210_h();
            float f5 = -0.5f;
            float f6 = 0.5f;
            float f7 = -0.5f;
            float f8 = 0.5f;
            float f9 = -0.5f;
            GlStateManager.func_179109_b((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(f2, f4).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, -0.5).func_187315_a(f1, f4).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, -0.5).func_187315_a(f1, f3).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(f2, f3).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
    }

    public void func_78441_a() {
        this.field_187470_g = this.field_187469_f;
        this.field_187472_i = this.field_187471_h;
        EntityPlayerSP entityplayersp = this.field_78455_a.field_71439_g;
        ItemStack itemstack = entityplayersp.func_184614_ca();
        ItemStack itemstack1 = entityplayersp.func_184592_cb();
        if (entityplayersp.func_184838_M()) {
            this.field_187469_f = MathHelper.func_76131_a((float)(this.field_187469_f - 0.4f), (float)0.0f, (float)1.0f);
            this.field_187471_h = MathHelper.func_76131_a((float)(this.field_187471_h - 0.4f), (float)0.0f, (float)1.0f);
        } else {
            float f = entityplayersp.func_184825_o(1.0f);
            boolean requipM = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.field_187467_d, (ItemStack)itemstack, (int)entityplayersp.field_71071_by.field_70461_c);
            boolean requipO = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.field_187468_e, (ItemStack)itemstack1, (int)-1);
            if (!requipM && !Objects.equals((Object)this.field_187467_d, (Object)itemstack)) {
                this.field_187467_d = itemstack;
            }
            if (!requipO && !Objects.equals((Object)this.field_187468_e, (Object)itemstack1)) {
                this.field_187468_e = itemstack1;
            }
            this.field_187469_f += MathHelper.func_76131_a((float)((Objects.equals((Object)this.field_187467_d, (Object)itemstack) ? f * f * f : 0.0f) - this.field_187469_f), (float)-0.4f, (float)0.4f);
            this.field_187471_h += MathHelper.func_76131_a((float)((float)(Objects.equals((Object)this.field_187468_e, (Object)itemstack1) ? 1 : 0) - this.field_187471_h), (float)-0.4f, (float)0.4f);
        }
        if (this.field_187469_f < 0.1f) {
            this.field_187467_d = itemstack;
        }
        if (this.field_187471_h < 0.1f) {
            this.field_187468_e = itemstack1;
        }
    }

    public void func_187460_a(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            this.field_187469_f = 0.0f;
        } else {
            this.field_187471_h = 0.0f;
        }
    }
}

